/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.http.netty.server.servlet.NettyServletOutputStream;

public class NettyServletResponse
implements HttpServletResponse {
    private HttpResponse originalResponse;
    private NettyServletOutputStream outputStream;
    private PrintWriter writer;
    private boolean responseCommited;

    public NettyServletResponse(HttpResponse response) {
        this.originalResponse = response;
        this.outputStream = new NettyServletOutputStream((HttpContent)response);
        this.writer = new PrintWriter((OutputStream)((Object)this.outputStream));
    }

    public HttpResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public void addDateHeader(String name, long date) {
        this.originalResponse.headers().set(name, (Object)date);
    }

    public void addHeader(String name, String value) {
        this.originalResponse.headers().set(name, (Object)value);
    }

    public void addIntHeader(String name, int value) {
        this.originalResponse.headers().set(name, (Object)value);
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String name) {
        return this.originalResponse.headers().contains(name);
    }

    public void sendError(int sc) throws IOException {
        this.originalResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    public void sendError(int sc, String msg) throws IOException {
        this.originalResponse.setStatus(new HttpResponseStatus(sc, msg));
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader(HttpHeaderNames.LOCATION, location);
    }

    public void setDateHeader(String name, long date) {
        this.originalResponse.headers().set(name, (Object)date);
    }

    public void setHeader(AsciiString name, String value) {
        this.originalResponse.headers().set((CharSequence)name, (Object)value);
    }

    public void setHeader(String name, String value) {
        this.originalResponse.headers().set(name, (Object)value);
    }

    public void setIntHeader(String name, int value) {
        this.originalResponse.headers().set(name, (Object)value);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void setStatus(int sc) {
        this.originalResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    public void setStatus(int sc, String sm) {
        this.originalResponse.setStatus(new HttpResponseStatus(sc, sm));
    }

    public void setContentType(String type) {
        this.originalResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)type);
    }

    public void setContentLength(int len) {
        HttpUtil.setContentLength((HttpMessage)this.originalResponse, (long)len);
    }

    public boolean isCommitted() {
        return this.responseCommited;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already commited!");
        }
        this.originalResponse.headers().clear();
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already commited!");
        }
        this.outputStream.resetBuffer();
    }

    public void flushBuffer() throws IOException {
        this.getWriter().flush();
        this.responseCommited = true;
    }

    public int getBufferSize() {
        return this.outputStream.getBufferSize();
    }

    public void setBufferSize(int size) {
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding url!", e);
        }
    }

    public String encodeUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String getCharacterEncoding() {
        throw new IllegalStateException("Method 'getCharacterEncoding' not yet implemented!");
    }

    public String getContentType() {
        throw new IllegalStateException("Method 'getContentType' not yet implemented!");
    }

    public Locale getLocale() {
        throw new IllegalStateException("Method 'getLocale' not yet implemented!");
    }

    public void setCharacterEncoding(String charset) {
        throw new IllegalStateException("Method 'setCharacterEncoding' not yet implemented!");
    }

    public void setLocale(Locale loc) {
        throw new IllegalStateException("Method 'setLocale' not yet implemented!");
    }
}

