/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.ram.RamFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RamFileRandomAccessContentTest {
    private final int EOF = -1;

    @Test
    public void testInputStreamRead0xff() throws IOException {
        FileObject file = VFS.getManager().resolveFile("ram://file");
        file.createFile();
        try (OutputStream out = file.getContent().getOutputStream();){
            out.write(255);
        }
        try (InputStream in = new RamFileRandomAccessContent((RamFileObject)file, RandomAccessMode.READ).getInputStream();){
            int read = in.read();
            Assertions.assertNotEquals((int)-1, (int)read);
            Assertions.assertEquals((int)255, (int)read);
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }
}

