/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.util;

import org.apache.commons.validator.util.Flags;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FlagsTest {
    private static final long LONG_FLAG = 1L;
    private static final long LONG_FLAG_2 = 2L;
    private static final int INT_FLAG = 4;

    FlagsTest() {
    }

    @Test
    void testClear() {
        Flags f = new Flags(98432L);
        f.clear();
        Assertions.assertEquals((long)0L, (long)f.getFlags());
    }

    @Test
    void testClone() {
    }

    @Test
    void testEqualsObject() {
    }

    @Test
    void testGetFlags() {
        Flags f = new Flags(45L);
        Assertions.assertEquals((long)f.getFlags(), (long)45L);
    }

    @Test
    void testHashCode() {
        Flags f = new Flags(45L);
        Assertions.assertEquals((int)f.hashCode(), (int)45);
    }

    @Test
    void testIsOnIsFalseWhenNotAllFlagsInArgumentAreOn() {
        Flags first = new Flags(1L);
        long firstAndSecond = 3L;
        Assertions.assertFalse((boolean)first.isOn(3L));
    }

    @Test
    void testIsOnIsTrueWhenHighOrderBitIsSetAndQueried() {
        Flags allOn = new Flags(-1L);
        long highOrderBit = Long.MIN_VALUE;
        Assertions.assertTrue((boolean)allOn.isOn(Long.MIN_VALUE));
    }

    @Test
    void testIsOnOff() {
        Flags f = new Flags();
        f.turnOn(1L);
        f.turnOn(4L);
        Assertions.assertTrue((boolean)f.isOn(1L));
        Assertions.assertFalse((boolean)f.isOff(1L));
        Assertions.assertTrue((boolean)f.isOn(4L));
        Assertions.assertFalse((boolean)f.isOff(4L));
        Assertions.assertTrue((boolean)f.isOff(2L));
    }

    @Test
    void testToString() {
        Flags f = new Flags();
        String s = f.toString();
        Assertions.assertEquals((int)64, (int)s.length());
        f.turnOn(4L);
        s = f.toString();
        Assertions.assertEquals((int)64, (int)s.length());
        Assertions.assertEquals((Object)"0000000000000000000000000000000000000000000000000000000000000100", (Object)s);
    }

    @Test
    void testTurnOff() {
    }

    @Test
    void testTurnOffAll() {
        Flags f = new Flags(98432L);
        f.turnOffAll();
        Assertions.assertEquals((long)0L, (long)f.getFlags());
    }

    @Test
    void testTurnOnAll() {
        Flags f = new Flags();
        f.turnOnAll();
        Assertions.assertEquals((long)-1L, (long)f.getFlags());
    }

    @Test
    void testTurnOnOff() {
    }
}

