/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.mail;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.examples.mail.Utils;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.commons.net.imap.IMAPSClient;

final class IMAPUtils {
    IMAPUtils() {
    }

    static IMAPClient imapLogin(URI uri, int defaultTimeout, ProtocolCommandListener listener) throws IOException {
        IMAPClient imap;
        String userInfo = uri.getUserInfo();
        if (userInfo == null) {
            throw new IllegalArgumentException("Missing userInfo details");
        }
        String[] userPassword = userInfo.split(":");
        if (userPassword.length != 2) {
            throw new IllegalArgumentException("Invalid userInfo details: '" + userInfo + "'");
        }
        String user = userPassword[0];
        String password = userPassword[1];
        password = Utils.getPassword(user, password);
        String scheme = uri.getScheme();
        if ("imaps".equalsIgnoreCase(scheme)) {
            System.out.println("Using secure protocol");
            imap = new IMAPSClient(true);
        } else if ("imap".equalsIgnoreCase(scheme)) {
            imap = new IMAPClient();
        } else {
            throw new IllegalArgumentException("Invalid protocol: " + scheme);
        }
        int port = uri.getPort();
        if (port != -1) {
            imap.setDefaultPort(port);
        }
        imap.setDefaultTimeout(defaultTimeout);
        if (listener != null) {
            imap.addProtocolCommandListener(listener);
        }
        String server = uri.getHost();
        System.out.println("Connecting to server " + server + " on " + imap.getDefaultPort());
        try {
            imap.connect(server);
            System.out.println("Successfully connected");
        }
        catch (IOException e) {
            throw new IOException("Could not connect to server.", e);
        }
        if (!imap.login(user, password)) {
            imap.disconnect();
            throw new IOException("Could not login to server. Check login details.");
        }
        return imap;
    }
}

