/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.awt.Insets;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.reflect.AAAAClass;
import org.apache.commons.lang3.reflect.AAAClass;
import org.apache.commons.lang3.reflect.AAClass;
import org.apache.commons.lang3.reflect.AClass;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.Test1;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.testbed.Foo;
import org.apache.commons.lang3.reflect.testbed.GenericParent;
import org.apache.commons.lang3.reflect.testbed.GenericTypeHolder;
import org.apache.commons.lang3.reflect.testbed.StringParameterizedChild;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TypeUtilsTest<B>
extends AbstractLangTest {
    public static Comparable<Integer> intComparable;
    public static Comparable<Long> longComparable;
    public static Comparable<String> stringComparable;
    public static List<String>[] stringListArray;
    public static URI uri;
    public static Comparable<URI> uriComparable;
    public static Comparable<?> wildcardComparable;
    public The<String, String> da;
    public That<String, String> dat;
    public That<String, String> dat2;
    public That<String, String> dat3;
    public Thing ding;
    public This<String, String> dis;
    public Comparable<? extends Integer>[] intWildcardComparable;
    public Iterable<? extends Map<Integer, ? extends Collection<?>>> iterable;
    public Tester tester;
    public Tester tester2;
    public Other<String> uhder;

    public static <G extends Comparable<G>> G stub() {
        return null;
    }

    public static <G extends Comparable<? super G>> G stub2() {
        return null;
    }

    public static <T extends Comparable<? extends T>> T stub3() {
        return null;
    }

    static Stream<Type> testTypeToString() {
        return Stream.of(Comparator.class, Comparable.class, ArrayList.class, HashMap.class).flatMap(cls -> Stream.of(cls.getDeclaredMethods())).flatMap(m -> Stream.concat(Stream.of(m.getGenericExceptionTypes()), Stream.concat(Stream.of(m.getGenericParameterTypes()), Stream.concat(Stream.of(m.getGenericReturnType()), Stream.of(m.getTypeParameters())))));
    }

    private <U> MyInnerClass<U> aMethod() {
        return null;
    }

    @Test
    void test_LANG_1114() throws NoSuchFieldException {
        Type nonWildcardType = this.getClass().getDeclaredField("wildcardComparable").getGenericType();
        Type wildcardType = ((ParameterizedType)nonWildcardType).getActualTypeArguments()[0];
        Assertions.assertFalse((boolean)TypeUtils.equals((Type)wildcardType, (Type)nonWildcardType));
        Assertions.assertFalse((boolean)TypeUtils.equals((Type)nonWildcardType, (Type)wildcardType));
    }

    @Test
    void test_LANG_1190() throws NoSuchMethodException {
        Type fromType = ClassWithSuperClassWithGenericType.class.getDeclaredMethod("methodWithGenericReturnType", new Class[0]).getGenericReturnType();
        WildcardType failingToType = TypeUtils.wildcardType().withLowerBounds(new Type[]{ClassWithSuperClassWithGenericType.class}).build();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fromType, (Type)failingToType));
    }

    @Test
    void test_LANG_1348() throws NoSuchMethodException {
        Method method = Enum.class.getMethod("valueOf", Class.class, String.class);
        Assertions.assertEquals((Object)"T extends java.lang.Enum<T>", (Object)TypeUtils.toString((Type)method.getGenericReturnType()));
    }

    @Test
    void test_LANG_1524() {
        Assertions.assertEquals((Object)"AAAAClass(cycle).BBBBClass.CCCClass", (Object)TypeUtils.toString(AAAAClass.BBBBClass.CCCClass.class));
        Assertions.assertEquals((Object)"AAAAClass(cycle).BBBBClass", (Object)TypeUtils.toString(AAAAClass.BBBBClass.class));
        Assertions.assertEquals((Object)"AAAAClass(cycle)", (Object)TypeUtils.toString(AAAAClass.class));
    }

    @Test
    void test_LANG_1698() {
        ParameterizedType comparing = (ParameterizedType)Arrays.stream(Comparator.class.getDeclaredMethods()).filter(k -> k.getName().equals("comparing")).findFirst().orElse(Comparator.class.getDeclaredMethods()[0]).getGenericParameterTypes()[0];
        String typeName = TypeUtils.parameterize((Class)((Class)comparing.getRawType()), (Type[])comparing.getActualTypeArguments()).getTypeName();
        Assertions.assertEquals((Object)"java.util.function.Function<? super T, ? extends U>", (Object)typeName);
    }

    @Test
    void test_LANG_1702() throws NoSuchMethodException, SecurityException {
        Type type = TypeUtilsTest.class.getDeclaredMethod("aMethod", new Class[0]).getGenericReturnType();
        Map typeArguments = Collections.emptyMap();
        Type unrolledType = TypeUtils.unrollVariables(typeArguments, (Type)type);
    }

    @Test
    void testContainsTypeVariables() throws NoSuchMethodException {
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m0", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m1", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m2", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m3", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m4", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m5", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m6", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m7", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m8", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m9", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m10", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m11", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m12", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m13", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m14", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m15", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m16", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test1.class.getMethod("m17", new Class[0]).getGenericReturnType()));
    }

    @Test
    void testContainsTypeVariablesPr437() throws Exception {
        abstract class Test2<G> {
            Test2() {
            }

            public abstract Object m0();

            public abstract String[] m1();

            public abstract <K, V> Map<? extends K, V[]> m10();

            public abstract <K, V> Map<? extends K, List<V[]>> m11();

            public abstract List m12();

            public abstract Map m13();

            public abstract Properties m14();

            public abstract G m15();

            public abstract List<G> m16();

            public abstract Enum m17();

            public abstract <E> E[] m2();

            public abstract <E> List<? extends E> m3();

            public abstract <E extends Enum<E>> List<? extends Enum<E>> m4();

            public abstract List<? extends Enum<?>> m5();

            public abstract List<? super Enum<?>> m6();

            public abstract List<?> m7();

            public abstract Map<? extends Enum<?>, ? super Enum<?>> m8();

            public abstract <K, V> Map<? extends K, ? super V[]> m9();
        }
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m0", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m1", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m2", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m3", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m4", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m5", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m6", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m7", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m8", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m9", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m10", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m11", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m12", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m13", new Class[0]).getGenericReturnType()));
        Assertions.assertFalse((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m14", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m15", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m16", new Class[0]).getGenericReturnType()));
        Assertions.assertTrue((boolean)TypeUtils.containsTypeVariables((Type)Test2.class.getMethod("m17", new Class[0]).getGenericReturnType()));
    }

    @Test
    void testDeprecatedConstructor() {
        Assertions.assertNotNull((Object)new TypeUtils().toString());
    }

    @Test
    void testDetermineTypeArguments() throws NoSuchFieldException {
        ParameterizedType iterableType = (ParameterizedType)this.getClass().getField("iterable").getGenericType();
        Assertions.assertNull((Object)TypeUtils.determineTypeArguments(Object.class, (ParameterizedType)iterableType));
        Map typeVarAssigns = TypeUtils.determineTypeArguments(TreeSet.class, (ParameterizedType)iterableType);
        TypeVariable treeSetTypeVar = TreeSet.class.getTypeParameters()[0];
        Assertions.assertTrue((boolean)typeVarAssigns.containsKey(treeSetTypeVar));
        Assertions.assertEquals((Object)iterableType.getActualTypeArguments()[0], typeVarAssigns.get(treeSetTypeVar));
        LangAssertions.assertNullPointerException(() -> TypeUtils.determineTypeArguments(TreeSet.class, null));
        LangAssertions.assertNullPointerException(() -> TypeUtils.determineTypeArguments(null, (ParameterizedType)iterableType));
    }

    @Test
    void testEquals() throws NoSuchFieldException {
        Type expected = this.getClass().getField("intWildcardComparable").getGenericType();
        GenericArrayType gat1 = TypeUtils.genericArrayType((Type)TypeUtils.parameterize(Comparable.class, (Type[])new Type[]{TypeUtils.wildcardType().withUpperBounds(new Type[]{Integer.class}).build()}));
        GenericArrayType gat2 = TypeUtils.genericArrayType((Type)TypeUtils.parameterize(Comparable.class, (Type[])new Type[]{TypeUtils.wildcardType().withUpperBounds(new Type[]{Integer.class}).build()}));
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)gat1, (Type)gat1));
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)gat1, (Type)gat2));
        Assertions.assertFalse((boolean)TypeUtils.equals((Type)gat1, null));
        Assertions.assertFalse((boolean)TypeUtils.equals(null, (Type)gat1));
    }

    @Test
    void testGenericArrayType() throws NoSuchFieldException {
        Type expected = this.getClass().getField("intWildcardComparable").getGenericType();
        GenericArrayType actual = TypeUtils.genericArrayType((Type)TypeUtils.parameterize(Comparable.class, (Type[])new Type[]{TypeUtils.wildcardType().withUpperBounds(new Type[]{Integer.class}).build()}));
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)expected, (Type)actual));
        Assertions.assertEquals((Object)"java.lang.Comparable<? extends java.lang.Integer>[]", (Object)actual.toString());
        Assertions.assertNotEquals((int)0, (int)actual.hashCode());
        Assertions.assertEquals((Object)actual, (Object)actual);
        Assertions.assertFalse((boolean)actual.equals(null));
        Assertions.assertFalse((boolean)actual.equals(TypeUtils.wildcardType().build()));
    }

    @Test
    void testGetArrayComponentType() throws NoSuchFieldException {
        Type rawListType = GenericTypeHolder.class.getDeclaredField("rawList").getGenericType();
        Type objectListType = GenericTypeHolder.class.getDeclaredField("objectList").getGenericType();
        Type unboundListType = GenericTypeHolder.class.getDeclaredField("unboundList").getGenericType();
        Type superObjectListType = GenericTypeHolder.class.getDeclaredField("superObjectList").getGenericType();
        Type stringListType = GenericTypeHolder.class.getDeclaredField("stringList").getGenericType();
        Type subStringListType = GenericTypeHolder.class.getDeclaredField("subStringList").getGenericType();
        Type superStringListType = GenericTypeHolder.class.getDeclaredField("superStringList").getGenericType();
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)rawListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)objectListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)unboundListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)superObjectListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)stringListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)subStringListType));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType((Type)superStringListType));
        Type rawListTypeArray = GenericTypeHolder.class.getDeclaredField("rawListArray").getGenericType();
        Type objectListTypeArray = GenericTypeHolder.class.getDeclaredField("objectListArray").getGenericType();
        Type unboundListTypeArray = GenericTypeHolder.class.getDeclaredField("unboundListArray").getGenericType();
        Type superObjectListTypeArray = GenericTypeHolder.class.getDeclaredField("superObjectListArray").getGenericType();
        Type stringListTypeArray = GenericTypeHolder.class.getDeclaredField("stringListArray").getGenericType();
        Type subStringListTypeArray = GenericTypeHolder.class.getDeclaredField("subStringListArray").getGenericType();
        Type superStringListTypeArray = GenericTypeHolder.class.getDeclaredField("superStringListArray").getGenericType();
        Assertions.assertEquals((Object)rawListType, (Object)TypeUtils.getArrayComponentType((Type)rawListTypeArray));
        Assertions.assertEquals((Object)objectListType, (Object)TypeUtils.getArrayComponentType((Type)objectListTypeArray));
        Assertions.assertEquals((Object)unboundListType, (Object)TypeUtils.getArrayComponentType((Type)unboundListTypeArray));
        Assertions.assertEquals((Object)superObjectListType, (Object)TypeUtils.getArrayComponentType((Type)superObjectListTypeArray));
        Assertions.assertEquals((Object)stringListType, (Object)TypeUtils.getArrayComponentType((Type)stringListTypeArray));
        Assertions.assertEquals((Object)subStringListType, (Object)TypeUtils.getArrayComponentType((Type)subStringListTypeArray));
        Assertions.assertEquals((Object)superStringListType, (Object)TypeUtils.getArrayComponentType((Type)superStringListTypeArray));
    }

    @Test
    void testGetPrimitiveArrayComponentType() {
        Assertions.assertEquals(Boolean.TYPE, (Object)TypeUtils.getArrayComponentType(boolean[].class));
        Assertions.assertEquals(Byte.TYPE, (Object)TypeUtils.getArrayComponentType(byte[].class));
        Assertions.assertEquals(Short.TYPE, (Object)TypeUtils.getArrayComponentType(short[].class));
        Assertions.assertEquals(Integer.TYPE, (Object)TypeUtils.getArrayComponentType(int[].class));
        Assertions.assertEquals(Character.TYPE, (Object)TypeUtils.getArrayComponentType(char[].class));
        Assertions.assertEquals(Long.TYPE, (Object)TypeUtils.getArrayComponentType(long[].class));
        Assertions.assertEquals(Float.TYPE, (Object)TypeUtils.getArrayComponentType(float[].class));
        Assertions.assertEquals(Double.TYPE, (Object)TypeUtils.getArrayComponentType(double[].class));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Boolean.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Byte.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Short.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Integer.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Character.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Long.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Float.TYPE));
        Assertions.assertNull((Object)TypeUtils.getArrayComponentType(Double.TYPE));
    }

    @Test
    void testGetRawType() throws NoSuchFieldException {
        Type stringParentFieldType = GenericTypeHolder.class.getDeclaredField("stringParent").getGenericType();
        Type integerParentFieldType = GenericTypeHolder.class.getDeclaredField("integerParent").getGenericType();
        Type foosFieldType = GenericTypeHolder.class.getDeclaredField("foos").getGenericType();
        TypeVariable genericParentT = GenericParent.class.getTypeParameters()[0];
        Assertions.assertEquals(GenericParent.class, (Object)TypeUtils.getRawType((Type)stringParentFieldType, null));
        Assertions.assertEquals(GenericParent.class, (Object)TypeUtils.getRawType((Type)integerParentFieldType, null));
        Assertions.assertEquals(List.class, (Object)TypeUtils.getRawType((Type)foosFieldType, null));
        Assertions.assertEquals(String.class, (Object)TypeUtils.getRawType(genericParentT, StringParameterizedChild.class));
        Assertions.assertEquals(String.class, (Object)TypeUtils.getRawType(genericParentT, (Type)stringParentFieldType));
        Assertions.assertEquals(Foo.class, (Object)TypeUtils.getRawType(Iterable.class.getTypeParameters()[0], (Type)foosFieldType));
        Assertions.assertEquals(Foo.class, (Object)TypeUtils.getRawType(List.class.getTypeParameters()[0], (Type)foosFieldType));
        Assertions.assertNull((Object)TypeUtils.getRawType(genericParentT, GenericParent.class));
        Assertions.assertEquals(GenericParent[].class, (Object)TypeUtils.getRawType((Type)GenericTypeHolder.class.getDeclaredField("barParents").getGenericType(), null));
    }

    @Test
    void testGetRawType_LANG_1697() {
        Assertions.assertEquals(int[].class, (Object)TypeUtils.getRawType((Type)TypeUtils.genericArrayType(Integer.TYPE), Integer.TYPE));
        Assertions.assertNull((Object)TypeUtils.getRawType((Type)TypeUtils.genericArrayType((Type)TypeUtils.WILDCARD_ALL), null));
        Assertions.assertNull((Object)TypeUtils.getRawType((Type)TypeUtils.genericArrayType((Type)TypeUtils.WILDCARD_ALL), (Type)TypeUtils.WILDCARD_ALL));
        Assertions.assertNull((Object)TypeUtils.getRawType((Type)TypeUtils.genericArrayType((Type)TypeUtils.WILDCARD_ALL), Integer.TYPE));
    }

    @Test
    void testGetTypeArguments() {
        Map typeVarAssigns = TypeUtils.getTypeArguments(Integer.class, Comparable.class);
        TypeVariable treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assertions.assertTrue((boolean)typeVarAssigns.containsKey(treeSetTypeVar), (String)("Type var assigns for Comparable from Integer: " + typeVarAssigns));
        Type typeArg = (Type)typeVarAssigns.get(treeSetTypeVar);
        Assertions.assertEquals(Integer.class, typeVarAssigns.get(treeSetTypeVar), (String)("Type argument of Comparable from Integer: " + typeArg));
        typeVarAssigns = TypeUtils.getTypeArguments(Integer.TYPE, Comparable.class);
        treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assertions.assertTrue((boolean)typeVarAssigns.containsKey(treeSetTypeVar), (String)("Type var assigns for Comparable from int: " + typeVarAssigns));
        typeArg = (Type)typeVarAssigns.get(treeSetTypeVar);
        Assertions.assertEquals(Integer.class, typeVarAssigns.get(treeSetTypeVar), (String)("Type argument of Comparable from int: " + typeArg));
        List col = Collections.emptyList();
        typeVarAssigns = TypeUtils.getTypeArguments(List.class, Collection.class);
        treeSetTypeVar = Comparable.class.getTypeParameters()[0];
        Assertions.assertFalse((boolean)typeVarAssigns.containsKey(treeSetTypeVar), (String)("Type var assigns for Collection from List: " + typeVarAssigns));
        typeVarAssigns = TypeUtils.getTypeArguments(AAAClass.BBBClass.class, AAClass.BBClass.class);
        Assertions.assertEquals((int)2, (int)typeVarAssigns.size());
        Assertions.assertEquals(String.class, typeVarAssigns.get(AAClass.class.getTypeParameters()[0]));
        Assertions.assertEquals(String.class, typeVarAssigns.get(AAClass.BBClass.class.getTypeParameters()[0]));
        typeVarAssigns = TypeUtils.getTypeArguments(Other.class, This.class);
        Assertions.assertEquals((int)2, (int)typeVarAssigns.size());
        Assertions.assertEquals(String.class, typeVarAssigns.get(This.class.getTypeParameters()[0]));
        Assertions.assertEquals(Other.class.getTypeParameters()[0], typeVarAssigns.get(This.class.getTypeParameters()[1]));
        typeVarAssigns = TypeUtils.getTypeArguments(And.class, This.class);
        Assertions.assertEquals((int)2, (int)typeVarAssigns.size());
        Assertions.assertEquals(Number.class, typeVarAssigns.get(This.class.getTypeParameters()[0]));
        Assertions.assertEquals(Number.class, typeVarAssigns.get(This.class.getTypeParameters()[1]));
        typeVarAssigns = TypeUtils.getTypeArguments(Thing.class, Other.class);
        Assertions.assertEquals((int)2, (int)typeVarAssigns.size());
        Assertions.assertEquals(this.getClass().getTypeParameters()[0], typeVarAssigns.get(this.getClass().getTypeParameters()[0]));
        Assertions.assertEquals(this.getClass().getTypeParameters()[0], typeVarAssigns.get(Other.class.getTypeParameters()[0]));
    }

    @Test
    void testIsArrayGenericTypes() throws NoSuchFieldException {
        Type rawListType = GenericTypeHolder.class.getDeclaredField("rawList").getGenericType();
        Type objectListType = GenericTypeHolder.class.getDeclaredField("objectList").getGenericType();
        Type unboundListType = GenericTypeHolder.class.getDeclaredField("unboundList").getGenericType();
        Type superObjectListType = GenericTypeHolder.class.getDeclaredField("superObjectList").getGenericType();
        Type stringListType = GenericTypeHolder.class.getDeclaredField("stringList").getGenericType();
        Type subStringListType = GenericTypeHolder.class.getDeclaredField("subStringList").getGenericType();
        Type superStringListType = GenericTypeHolder.class.getDeclaredField("superStringList").getGenericType();
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)rawListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)objectListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)superObjectListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)stringListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType((Type)superStringListType));
        Type rawListTypeArray = GenericTypeHolder.class.getDeclaredField("rawListArray").getGenericType();
        Type objectListTypeArray = GenericTypeHolder.class.getDeclaredField("objectListArray").getGenericType();
        Type unboundListTypeArray = GenericTypeHolder.class.getDeclaredField("unboundListArray").getGenericType();
        Type superObjectListTypeArray = GenericTypeHolder.class.getDeclaredField("superObjectListArray").getGenericType();
        Type stringListTypeArray = GenericTypeHolder.class.getDeclaredField("stringListArray").getGenericType();
        Type subStringListTypeArray = GenericTypeHolder.class.getDeclaredField("subStringListArray").getGenericType();
        Type superStringListTypeArray = GenericTypeHolder.class.getDeclaredField("superStringListArray").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)unboundListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)subStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType((Type)superStringListTypeArray));
    }

    @Test
    void testIsArrayTypeClasses() {
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(boolean[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(byte[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(short[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(int[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(char[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(long[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(float[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(double[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(Object[].class));
        Assertions.assertTrue((boolean)TypeUtils.isArrayType(String[].class));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Boolean.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Byte.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Short.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Integer.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Character.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Long.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Float.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Double.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(Object.class));
        Assertions.assertFalse((boolean)TypeUtils.isArrayType(String.class));
    }

    @Test
    void testIsAssignableClasses() {
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Character.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Byte.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Short.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Long.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Float.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Long.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.class, Long.TYPE));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer.TYPE, Long.class));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer.class, Long.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.class, Integer.TYPE));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Integer.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Number.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Object.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Comparable.class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Serializable.class));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(int[].class, long[].class));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer[].class, int[].class));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(int[].class, Object[].class));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer[].class, Object[].class));
    }

    @Test
    void testIsAssignableDirectClassHierarchy() throws NoSuchFieldException {
        Type bClassType = AClass.class.getField("bClass").getGenericType();
        Type cClassType = AClass.class.getField("cClass").getGenericType();
        Type dClassType = AClass.class.getField("dClass").getGenericType();
        Type eClassType = AClass.class.getField("eClass").getGenericType();
        Type fClassType = AClass.class.getField("fClass").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)cClassType, (Type)bClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)dClassType, (Type)bClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)bClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)bClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)dClassType, (Type)cClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)cClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)cClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)eClassType, (Type)dClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)dClassType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)fClassType, (Type)eClassType));
    }

    @Test
    void testIsAssignableGenericArrayTypeToObject() {
        Class<Constructor> rawClass = Constructor.class;
        Class<Insets> typeArgClass = Insets.class;
        ParameterizedType paramType = TypeUtils.parameterize(rawClass, (Type[])new Type[]{typeArgClass});
        Assertions.assertEquals(rawClass, (Object)paramType.getRawType());
        Assertions.assertEquals(typeArgClass, (Object)paramType.getActualTypeArguments()[0]);
        Assertions.assertTrue((boolean)Object.class.isAssignableFrom(paramType.getClass()));
        Assertions.assertFalse((boolean)paramType.getClass().isAssignableFrom(Object.class));
        Class<Object> testType = Object.class;
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)paramType, testType), () -> String.format("TypeUtils.isAssignable(%s, %s)", paramType, testType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(testType, (Type)paramType), () -> String.format("TypeUtils.isAssignable(%s, %s)", testType, paramType));
    }

    @Test
    void testIsAssignableGenericArrayTypeToParameterizedType() {
        Class<Constructor> rawClass = Constructor.class;
        Class<Insets> typeArgClass = Insets.class;
        ParameterizedType paramType = TypeUtils.parameterize(rawClass, (Type[])new Type[]{typeArgClass});
        Assertions.assertEquals(rawClass, (Object)paramType.getRawType());
        Assertions.assertEquals(typeArgClass, (Object)paramType.getActualTypeArguments()[0]);
        Assertions.assertFalse((boolean)GenericArrayType.class.isAssignableFrom(paramType.getClass()));
        Assertions.assertFalse((boolean)paramType.getClass().isAssignableFrom(GenericArrayType.class));
        GenericArrayType testType = TypeUtils.genericArrayType((Type)paramType);
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)paramType, (Type)testType), () -> String.format("TypeUtils.isAssignable(%s, %s)", paramType, testType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)testType, (Type)paramType), () -> String.format("TypeUtils.isAssignable(%s, %s)", testType, paramType));
    }

    @Test
    @Disabled(value="TODO")
    void testIsAssignableGenericArrayTypeToWildcardType() {
        Class<Constructor> rawClass = Constructor.class;
        Class<Insets> typeArgClass = Insets.class;
        ParameterizedType paramType = TypeUtils.parameterize(rawClass, (Type[])new Type[]{typeArgClass});
        Assertions.assertEquals(rawClass, (Object)paramType.getRawType());
        Assertions.assertEquals(typeArgClass, (Object)paramType.getActualTypeArguments()[0]);
        Assertions.assertFalse((boolean)WildcardType.class.isAssignableFrom(paramType.getClass()));
        Assertions.assertFalse((boolean)paramType.getClass().isAssignableFrom(WildcardType.class));
        WildcardType testType = TypeUtils.WILDCARD_ALL;
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)paramType, (Type)testType), () -> String.format("TypeUtils.isAssignable(%s, %s)", paramType, testType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)testType, (Type)paramType), () -> String.format("TypeUtils.isAssignable(%s, %s)", testType, paramType));
    }

    @Test
    void testIsAssignableGenericClassHierarchy() throws NoSuchFieldException {
        Type disType = this.getClass().getField("dis").getGenericType();
        Type datType = this.getClass().getField("dat").getGenericType();
        Type dat2Type = this.getClass().getField("dat2").getGenericType();
        Type dat3Type = this.getClass().getField("dat3").getGenericType();
        Type daType = this.getClass().getField("da").getGenericType();
        Type uhderType = this.getClass().getField("uhder").getGenericType();
        Type dingType = this.getClass().getField("ding").getGenericType();
        Type testerType = this.getClass().getField("tester").getGenericType();
        Type tester2Type = this.getClass().getField("tester2").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)datType, (Type)disType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)daType, (Type)disType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)uhderType, (Type)disType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)dingType, (Type)disType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)testerType, (Type)disType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)tester2Type, (Type)disType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)dat2Type, (Type)datType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)datType, (Type)dat2Type));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)dat3Type, (Type)datType));
    }

    @Test
    void testIsAssignableGenericComparableTypes() throws NoSuchFieldException {
        Type intComparableType = this.getClass().getField("intComparable").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, (Type)intComparableType));
        Type longComparableType = this.getClass().getField("longComparable").getGenericType();
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer.TYPE, (Type)longComparableType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable(Integer.class, (Type)longComparableType));
        Type intComparableArrayType = this.getClass().getField("intWildcardComparable").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable(Integer[].class, (Type)intComparableArrayType));
    }

    @Test
    void testIsAssignableGenericListArrays() throws NoSuchFieldException {
        Type rawListTypeArray = GenericTypeHolder.class.getDeclaredField("rawListArray").getGenericType();
        Type objectListTypeArray = GenericTypeHolder.class.getDeclaredField("objectListArray").getGenericType();
        Type unboundListTypeArray = GenericTypeHolder.class.getDeclaredField("unboundListArray").getGenericType();
        Type superObjectListTypeArray = GenericTypeHolder.class.getDeclaredField("superObjectListArray").getGenericType();
        Type stringListTypeArray = GenericTypeHolder.class.getDeclaredField("stringListArray").getGenericType();
        Type subStringListTypeArray = GenericTypeHolder.class.getDeclaredField("subStringListArray").getGenericType();
        Type superStringListTypeArray = GenericTypeHolder.class.getDeclaredField("superStringListArray").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)rawListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)objectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)stringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)objectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)objectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)unboundListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)stringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)superObjectListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)stringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListTypeArray, (Type)superStringListTypeArray));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)subStringListTypeArray));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListTypeArray, (Type)superStringListTypeArray));
    }

    @Test
    void testIsAssignableGenericListTypes() throws NoSuchFieldException {
        Type rawListType = GenericTypeHolder.class.getDeclaredField("rawList").getGenericType();
        Type objectListType = GenericTypeHolder.class.getDeclaredField("objectList").getGenericType();
        Type unboundListType = GenericTypeHolder.class.getDeclaredField("unboundList").getGenericType();
        Type superObjectListType = GenericTypeHolder.class.getDeclaredField("superObjectList").getGenericType();
        Type stringListType = GenericTypeHolder.class.getDeclaredField("stringList").getGenericType();
        Type subStringListType = GenericTypeHolder.class.getDeclaredField("subStringList").getGenericType();
        Type superStringListType = GenericTypeHolder.class.getDeclaredField("superStringList").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)unboundListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)superObjectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)subStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)rawListType, (Type)superStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)rawListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)superObjectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)objectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)stringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)objectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)objectListType, (Type)superStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)objectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)superObjectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)subStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)unboundListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)unboundListType, (Type)superStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)unboundListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)superObjectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)stringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)superObjectListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)superObjectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superObjectListType, (Type)superStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)superObjectListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)stringListType, (Type)superStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)stringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)subStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)subStringListType, (Type)superStringListType));
        Assertions.assertFalse((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)subStringListType));
        Assertions.assertTrue((boolean)TypeUtils.isAssignable((Type)superStringListType, (Type)superStringListType));
    }

    @Test
    void testIsInstance() throws NoSuchFieldException {
        Assertions.assertFalse((boolean)TypeUtils.isInstance((Object)1, null));
        Type intComparableType = this.getClass().getField("intComparable").getGenericType();
        Type uriComparableType = this.getClass().getField("uriComparable").getGenericType();
        Assertions.assertTrue((boolean)TypeUtils.isInstance((Object)1, (Type)intComparableType));
        Assertions.assertFalse((boolean)TypeUtils.isInstance((Object)1, (Type)uriComparableType));
    }

    @Test
    void testLowerBoundedWildcardType() {
        WildcardType lowerBounded = TypeUtils.wildcardType().withLowerBounds(new Type[]{Date.class}).build();
        Assertions.assertEquals((Object)String.format("? super %s", Date.class.getName()), (Object)TypeUtils.toString((Type)lowerBounded));
        Assertions.assertEquals((Object)String.format("? super %s", Date.class.getName()), (Object)lowerBounded.toString());
        TypeVariable iterableT0 = Iterable.class.getTypeParameters()[0];
        WildcardType lowerTypeVariable = TypeUtils.wildcardType().withLowerBounds(new Type[]{iterableT0}).build();
        Assertions.assertEquals((Object)String.format("? super %s", iterableT0.getName()), (Object)TypeUtils.toString((Type)lowerTypeVariable));
        Assertions.assertEquals((Object)String.format("? super %s", iterableT0.getName()), (Object)lowerTypeVariable.toString());
    }

    @Test
    void testNormalizeUpperBounds() {
        Type[] typeArray = new Type[]{Collection.class, List.class};
        Object[] expectedArray = new Type[]{List.class};
        Assertions.assertArrayEquals((Object[])expectedArray, (Object[])TypeUtils.normalizeUpperBounds((Type[])typeArray));
    }

    @Test
    void testNormalizeUpperBounds_LANG_820() {
        Type[] typeArray = new Type[]{String.class, String.class};
        Object[] expectedArray = new Type[]{String.class};
        Assertions.assertArrayEquals((Object[])expectedArray, (Object[])TypeUtils.normalizeUpperBounds((Type[])typeArray));
    }

    @Test
    void testParameterizeMapArg() throws NoSuchFieldException {
        HashMap typeVariableMap = new HashMap();
        typeVariableMap.put(Comparable.class.getTypeParameters()[0], String.class);
        ParameterizedType stringComparableType = TypeUtils.parameterize(Comparable.class, typeVariableMap);
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)this.getClass().getField("stringComparable").getGenericType(), (Type)stringComparableType));
        Assertions.assertEquals((Object)"java.lang.Comparable<java.lang.String>", (Object)stringComparableType.toString());
    }

    @Test
    void testParameterizeNarrowerTypeArray() {
        Type[] variables = ArrayList.class.getTypeParameters();
        ParameterizedType parameterizedType = TypeUtils.parameterize(ArrayList.class, (Type[])variables);
        Map<Type, Class<String>> mapping = Collections.singletonMap(variables[0], String.class);
        Type unrolled = TypeUtils.unrollVariables(mapping, (Type)parameterizedType);
        Assertions.assertEquals((Object)TypeUtils.parameterize(ArrayList.class, (Type[])new Type[]{String.class}), (Object)unrolled);
    }

    @Test
    void testParameterizeNullPointerException() {
        LangAssertions.assertNullPointerException(() -> TypeUtils.parameterize(null, Collections.emptyMap()));
        Map nullTypeVariableMap = null;
        LangAssertions.assertNullPointerException(() -> TypeUtils.parameterize(String.class, (Map)nullTypeVariableMap));
    }

    @Test
    void testParameterizeVarArgs() throws NoSuchFieldException {
        ParameterizedType stringComparableType = TypeUtils.parameterize(Comparable.class, (Type[])new Type[]{String.class});
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)this.getClass().getField("stringComparable").getGenericType(), (Type)stringComparableType));
        Assertions.assertEquals((Object)"java.lang.Comparable<java.lang.String>", (Object)stringComparableType.toString());
    }

    @Test
    void testParameterizeVarArgsNullPointerException() {
        LangAssertions.assertNullPointerException(() -> TypeUtils.parameterize(null, (Type[])new Type[0]));
    }

    @Test
    void testParameterizeWithOwner() throws NoSuchFieldException {
        ParameterizedType owner = TypeUtils.parameterize(TypeUtilsTest.class, (Type[])new Type[]{String.class});
        ParameterizedType dat2Type1 = TypeUtils.parameterizeWithOwner((Type)owner, That.class, (Type[])new Type[]{String.class, String.class});
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)this.getClass().getField("dat2").getGenericType(), (Type)dat2Type1));
        Assertions.assertNotEquals((int)0, (int)dat2Type1.hashCode());
        Assertions.assertEquals((Object)dat2Type1, (Object)dat2Type1);
        ParameterizedType dat2Type2 = TypeUtils.parameterizeWithOwner(null, That.class, (Type[])new Type[]{String.class, String.class});
        Assertions.assertEquals(That.class, (Object)dat2Type2.getRawType());
        Assertions.assertNotEquals((int)0, (int)dat2Type2.hashCode());
        Assertions.assertEquals((Object)dat2Type2, (Object)dat2Type2);
        Assertions.assertNotEquals((Object)dat2Type2, (Object)dat2Type1);
        Assertions.assertFalse((boolean)dat2Type1.equals(null));
        Assertions.assertFalse((boolean)dat2Type1.equals(TypeUtils.genericArrayType(String.class)));
    }

    @Test
    void testParameterizeWithOwner3ArgsNullPointerException() {
        ParameterizedType owner = TypeUtils.parameterize(TypeUtilsTest.class, (Type[])new Type[]{String.class});
        LangAssertions.assertNullPointerException(() -> TypeUtils.parameterizeWithOwner((Type)owner, null, (Type[])new Type[]{String.class}));
        Map nullTypeVariableMap = null;
        LangAssertions.assertNullPointerException(() -> TypeUtils.parameterizeWithOwner((Type)owner, That.class, (Map)nullTypeVariableMap));
        HashMap typeVariableMap1 = new HashMap();
        typeVariableMap1.put(Comparable.class.getTypeParameters()[0], String.class);
        Assertions.assertEquals(Comparable.class, (Object)TypeUtils.parameterizeWithOwner(null, Comparable.class, typeVariableMap1).getRawType());
        HashMap typeVariableMap2 = new HashMap();
        typeVariableMap2.put(MyInnerClass.class.getTypeParameters()[0], String.class);
        Assertions.assertEquals(MyInnerClass.class, (Object)TypeUtils.parameterizeWithOwner(null, MyInnerClass.class, typeVariableMap2).getRawType());
        Assertions.assertEquals(MyInnerClass.class, (Object)TypeUtils.parameterizeWithOwner((Type)owner, MyInnerClass.class, typeVariableMap2).getRawType());
    }

    @Test
    void testParameterizeWithOwnerVarArgsNullPointerException() {
        ParameterizedType owner = TypeUtils.parameterize(TypeUtilsTest.class, (Type[])new Type[]{String.class});
        LangAssertions.assertNullPointerException(() -> TypeUtils.parameterizeWithOwner((Type)owner, null, (Type[])new Type[0]));
    }

    @Test
    void testToLongString() {
        LangAssertions.assertNullPointerException(() -> TypeUtils.toLongString(null));
        Assertions.assertEquals((Object)(this.getClass().getName() + ":B"), (Object)TypeUtils.toLongString(this.getClass().getTypeParameters()[0]));
        Assertions.assertEquals((Object)(this.getClass().getName() + ".MyInnerClass:T"), (Object)TypeUtils.toLongString(MyInnerClass.class.getTypeParameters()[0]));
        Assertions.assertEquals((Object)(this.getClass().getName() + ".That:K"), (Object)TypeUtils.toLongString(That.class.getTypeParameters()[0]));
        Assertions.assertEquals((Object)(this.getClass().getName() + ".The:K"), (Object)TypeUtils.toLongString(The.class.getTypeParameters()[0]));
        Assertions.assertEquals((Object)(this.getClass().getName() + ".MyInnerClass.MyInnerClass2:X"), (Object)TypeUtils.toLongString(MyInnerClass.MyInnerClass2.class.getTypeParameters()[0]));
    }

    @Test
    void testToString() {
        LangAssertions.assertNullPointerException(() -> TypeUtils.toString(null));
        LangAssertions.assertIllegalArgumentException(() -> TypeUtils.toString((Type)new Type(){}));
    }

    @Test
    void testToString_LANG_1311() {
        Assertions.assertEquals((Object)"int[]", (Object)TypeUtils.toString(int[].class));
        Assertions.assertEquals((Object)"java.lang.Integer[]", (Object)TypeUtils.toString(Integer[].class));
        Field stringListField = FieldUtils.getDeclaredField(this.getClass(), (String)"stringListArray");
        Assertions.assertEquals((Object)"java.util.List<java.lang.String>[]", (Object)TypeUtils.toString((Type)stringListField.getGenericType()));
    }

    @Test
    void testTypesSatisfyVariables() throws NoSuchMethodException {
        HashMap<TypeVariable<Method>, Class<Integer>> typeVarAssigns = new HashMap<TypeVariable<Method>, Class<Integer>>();
        Integer max = (Integer)TypeUtilsTest.stub();
        typeVarAssigns.put(this.getClass().getMethod("stub", new Class[0]).getTypeParameters()[0], Integer.class);
        Assertions.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
        typeVarAssigns.clear();
        typeVarAssigns.put(this.getClass().getMethod("stub2", new Class[0]).getTypeParameters()[0], Integer.class);
        Assertions.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
        typeVarAssigns.clear();
        typeVarAssigns.put(this.getClass().getMethod("stub3", new Class[0]).getTypeParameters()[0], Integer.class);
        Assertions.assertTrue((boolean)TypeUtils.typesSatisfyVariables(typeVarAssigns));
        LangAssertions.assertNullPointerException(() -> TypeUtils.typesSatisfyVariables(null));
    }

    @ParameterizedTest
    @MethodSource
    void testTypeToString(Type type) {
        Assertions.assertNotNull((Object)TypeUtils.toString((Type)type));
    }

    @Test
    void testUnboundedWildcardType() {
        WildcardType unbounded = TypeUtils.wildcardType().withLowerBounds(new Type[]{null}).withUpperBounds(new Type[0]).build();
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)TypeUtils.WILDCARD_ALL, (Type)unbounded));
        Assertions.assertArrayEquals((Object[])new Type[]{Object.class}, (Object[])TypeUtils.getImplicitUpperBounds((WildcardType)unbounded));
        Assertions.assertArrayEquals((Object[])new Type[]{null}, (Object[])TypeUtils.getImplicitLowerBounds((WildcardType)unbounded));
        Assertions.assertEquals((Object)"?", (Object)TypeUtils.toString((Type)unbounded));
        Assertions.assertEquals((Object)"?", (Object)unbounded.toString());
        LangAssertions.assertNullPointerException(() -> TypeUtils.getImplicitLowerBounds(null));
        LangAssertions.assertNullPointerException(() -> TypeUtils.getImplicitUpperBounds(null));
    }

    @Test
    void testUnrollVariables() {
        Type[] variables = ArrayList.class.getTypeParameters();
        ParameterizedType parameterizedType = TypeUtils.parameterize(ArrayList.class, (Type[])variables);
        Assertions.assertEquals((Object)"java.util.ArrayList<E>", (Object)TypeUtils.unrollVariables(null, (Type)parameterizedType).getTypeName());
        Map<Type, Class<String>> mapping = Collections.singletonMap(variables[0], String.class);
        Assertions.assertEquals((Object)"java.util.ArrayList<java.lang.String>", (Object)TypeUtils.unrollVariables(mapping, (Type)parameterizedType).getTypeName());
    }

    @Test
    void testWildcardType() throws NoSuchFieldException {
        WildcardType simpleWildcard = TypeUtils.wildcardType().withUpperBounds(new Type[]{String.class}).build();
        Field cClass = AClass.class.getField("cClass");
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)((ParameterizedType)cClass.getGenericType()).getActualTypeArguments()[0], (Type)simpleWildcard));
        Assertions.assertEquals((Object)String.format("? extends %s", String.class.getName()), (Object)TypeUtils.toString((Type)simpleWildcard));
        Assertions.assertEquals((Object)String.format("? extends %s", String.class.getName()), (Object)simpleWildcard.toString());
        Assertions.assertNotEquals((int)0, (int)simpleWildcard.hashCode());
        Assertions.assertEquals((Object)simpleWildcard, (Object)simpleWildcard);
        Assertions.assertFalse((boolean)simpleWildcard.equals(null));
        Assertions.assertFalse((boolean)simpleWildcard.equals(TypeUtils.genericArrayType(String.class)));
    }

    @Test
    void testWrap() {
        TypeVariable<Class<?>> t = this.getClass().getTypeParameters()[0];
        Assertions.assertTrue((boolean)TypeUtils.equals(t, (Type)TypeUtils.wrap(t).getType()));
        Assertions.assertEquals(String.class, (Object)TypeUtils.wrap(String.class).getType());
    }

    public static class ClassWithSuperClassWithGenericType
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        public static <U> Iterable<U> methodWithGenericReturnType() {
            return null;
        }
    }

    public class Other<T>
    implements This<String, T> {
    }

    public static interface This<K, V> {
    }

    public static interface And<K, V>
    extends This<Number, Number> {
    }

    public class Thing<Q>
    extends Other<B> {
    }

    public class That<K, V>
    implements This<K, V> {
    }

    private class MyInnerClass<T> {
        private MyInnerClass() {
        }

        class MyInnerClass2<X> {
            MyInnerClass2() {
            }
        }
    }

    public class The<K, V>
    extends That<Number, Number>
    implements And<String, String> {
    }

    public class Tester
    implements This<String, B> {
    }
}

