/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DateUtilsFragmentTest
extends AbstractLangTest {
    private static final int months = 7;
    private static final int days = 23;
    private static final int hours = 19;
    private static final int minutes = 53;
    private static final int seconds = 47;
    private static final int millis = 991;
    private Date aDate;
    private Calendar aCalendar;

    DateUtilsFragmentTest() {
    }

    @BeforeEach
    public void setUp() {
        this.aCalendar = Calendar.getInstance();
        this.aCalendar.set(2005, 7, 23, 19, 53, 47);
        this.aCalendar.set(14, 991);
        this.aDate = this.aCalendar.getTime();
    }

    @Test
    void testDateFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)5));
    }

    @Test
    void testDateFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)5));
    }

    @Test
    void testDayOfYearFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)6));
    }

    @Test
    void testDayOfYearFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)6));
    }

    @Test
    void testDaysOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)23L, (long)testResult);
    }

    @Test
    void testDaysOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInDays((Date)this.aDate, (int)2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)cal.get(5), (long)testResult);
    }

    @Test
    void testDaysOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)this.aCalendar.get(6), (long)testResult);
    }

    @Test
    void testDaysOfYearWithDate() {
        long testResult = DateUtils.getFragmentInDays((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)cal.get(6), (long)testResult);
    }

    @Test
    void testHourOfDayFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)11));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)11));
    }

    @Test
    void testHourOfDayFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)11));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)11));
    }

    @Test
    void testHoursOfDayWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)5);
        long expectedValue = 19L;
        Assertions.assertEquals((long)19L, (long)testResult);
        testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)6);
        Assertions.assertEquals((long)19L, (long)testResult);
    }

    @Test
    void testHoursOfDayWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)5);
        long expectedValue = 19L;
        Assertions.assertEquals((long)19L, (long)testResult);
        testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)6);
        Assertions.assertEquals((long)19L, (long)testResult);
    }

    @Test
    void testHoursOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)547L, (long)testResult);
    }

    @Test
    void testHoursOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)2);
        Assertions.assertEquals((long)547L, (long)testResult);
    }

    @Test
    void testHoursOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)(19L + (long)(this.aCalendar.get(6) - 1) * 86400000L / 3600000L), (long)testResult);
    }

    @Test
    void testHoursOfYearWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)(19L + (long)(cal.get(6) - 1) * 86400000L / 3600000L), (long)testResult);
    }

    @Test
    void testInvalidFragmentWithCalendar() {
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)0));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)0));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)0));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)0));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)0));
    }

    @Test
    void testInvalidFragmentWithDate() {
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)0));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInSeconds((Date)this.aDate, (int)0));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInMinutes((Date)this.aDate, (int)0));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInHours((Date)this.aDate, (int)0));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.getFragmentInDays((Date)this.aDate, (int)0));
    }

    @Test
    void testMillisecondFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)14));
    }

    @Test
    void testMillisecondFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Date)this.aDate, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)14));
    }

    @Test
    void testMillisecondsOfDayWithCalendar() {
        long testresult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)5);
        long expectedValue = 71627991L;
        Assertions.assertEquals((long)71627991L, (long)testresult);
        testresult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)6);
        Assertions.assertEquals((long)71627991L, (long)testresult);
    }

    @Test
    void testMillisecondsOfDayWithDate() {
        long testresult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)5);
        long expectedValue = 71627991L;
        Assertions.assertEquals((long)71627991L, (long)testresult);
        testresult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)6);
        Assertions.assertEquals((long)71627991L, (long)testresult);
    }

    @Test
    void testMillisecondsOfHourWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)11);
        Assertions.assertEquals((long)3227991L, (long)testResult);
    }

    @Test
    void testMillisecondsOfHourWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)11);
        Assertions.assertEquals((long)3227991L, (long)testResult);
    }

    @Test
    void testMillisecondsOfMinuteWithCalender() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)12);
        Assertions.assertEquals((long)47991L, (long)testResult);
    }

    @Test
    void testMillisecondsOfMinuteWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)12);
        Assertions.assertEquals((long)47991L, (long)testResult);
    }

    @Test
    void testMillisecondsOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)1972427991L, (long)testResult);
    }

    @Test
    void testMillisecondsOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)2);
        Assertions.assertEquals((long)1972427991L, (long)testResult);
    }

    @Test
    void testMillisecondsOfSecondWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)13);
        Assertions.assertEquals((long)991L, (long)testResult);
        Assertions.assertEquals((long)this.aCalendar.get(14), (long)testResult);
    }

    @Test
    void testMillisecondsOfSecondWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)13);
        Assertions.assertEquals((long)991L, (long)testResult);
    }

    @Test
    void testMillisecondsOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)(71627991L + (long)(this.aCalendar.get(6) - 1) * 86400000L), (long)testResult);
    }

    @Test
    void testMillisecondsOfYearWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)(71627991L + (long)(cal.get(6) - 1) * 86400000L), (long)testResult);
    }

    @Test
    void testMinuteFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)12));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)12));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)12));
    }

    @Test
    void testMinuteFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)12));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)12));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)12));
    }

    @Test
    void testMinutesOfDayWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)5);
        long expectedValue = 1193L;
        Assertions.assertEquals((long)1193L, (long)testResult);
        testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)6);
        Assertions.assertEquals((long)1193L, (long)testResult);
    }

    @Test
    void testMinutesOfDayWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)5);
        long expectedValue = 1193L;
        Assertions.assertEquals((long)1193L, (long)testResult);
        testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)6);
        Assertions.assertEquals((long)1193L, (long)testResult);
    }

    @Test
    void testMinutesOfHourWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)11);
        Assertions.assertEquals((long)53L, (long)testResult);
    }

    @Test
    void testMinutesOfHourWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)11);
        Assertions.assertEquals((long)53L, (long)testResult);
    }

    @Test
    void testMinutesOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)32873L, (long)testResult);
    }

    @Test
    void testMinutesOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)2);
        Assertions.assertEquals((long)32873L, (long)testResult);
    }

    @Test
    void testMinutesOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)(53L + (68400000L + (long)(this.aCalendar.get(6) - 1) * 86400000L) / 60000L), (long)testResult);
    }

    @Test
    void testMinutesOfYearWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)(53L + (68400000L + (long)(cal.get(6) - 1) * 86400000L) / 60000L), (long)testResult);
    }

    @Test
    void testMinutesOfYearWithWrongOffsetBugWithCalendar() {
        Calendar c = Calendar.getInstance();
        c.set(2, 0);
        c.set(6, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long testResult = DateUtils.getFragmentInMinutes((Calendar)c, (int)1);
        Assertions.assertEquals((long)0L, (long)testResult);
    }

    @Test
    void testNullCalendar() {
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInMilliseconds((Calendar)null, (int)14));
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInSeconds((Calendar)null, (int)14));
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInMinutes((Calendar)null, (int)14));
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInHours((Calendar)null, (int)14));
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInDays((Calendar)null, (int)14));
    }

    @Test
    void testNullDate() {
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInMilliseconds((Date)null, (int)14));
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInSeconds((Date)null, (int)14));
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInMinutes((Date)null, (int)14));
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInHours((Date)null, (int)14));
        LangAssertions.assertNullPointerException(() -> DateUtils.getFragmentInDays((Date)null, (int)14));
    }

    @Test
    void testSecondFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)13));
    }

    @Test
    void testSecondFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Date)this.aDate, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)13));
    }

    @Test
    void testSecondsOfDayWithCalendar() {
        long testresult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)5);
        long expectedValue = 71627L;
        Assertions.assertEquals((long)71627L, (long)testresult);
        testresult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)6);
        Assertions.assertEquals((long)71627L, (long)testresult);
    }

    @Test
    void testSecondsOfDayWithDate() {
        long testresult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)5);
        long expectedValue = 71627L;
        Assertions.assertEquals((long)71627L, (long)testresult);
        testresult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)6);
        Assertions.assertEquals((long)71627L, (long)testresult);
    }

    @Test
    void testSecondsofHourWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)11);
        Assertions.assertEquals((long)3227L, (long)testResult);
    }

    @Test
    void testSecondsofHourWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)11);
        Assertions.assertEquals((long)3227L, (long)testResult);
    }

    @Test
    void testSecondsofMinuteWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)12);
        Assertions.assertEquals((long)47L, (long)testResult);
        Assertions.assertEquals((long)this.aCalendar.get(13), (long)testResult);
    }

    @Test
    void testSecondsofMinuteWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)12);
        Assertions.assertEquals((long)47L, (long)testResult);
    }

    @Test
    void testSecondsOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)1972427L, (long)testResult);
    }

    @Test
    void testSecondsOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)2);
        Assertions.assertEquals((long)1972427L, (long)testResult);
    }

    @Test
    void testSecondsOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)(47L + (71580000L + (long)(this.aCalendar.get(6) - 1) * 86400000L) / 1000L), (long)testResult);
    }

    @Test
    void testSecondsOfYearWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)(47L + (71580000L + (long)(cal.get(6) - 1) * 86400000L) / 1000L), (long)testResult);
    }
}

