/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import java.util.List;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.model.AbstractXMLModelTest;
import org.apache.commons.jxpath.ri.model.jdom.TestJDOMFactory;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class JDOMModelTest
extends AbstractXMLModelTest {
    private void appendXMLSignature(StringBuilder buffer, List children, boolean elements, boolean attributes, boolean text, boolean pi) {
        for (Object child : children) {
            this.appendXMLSignature(buffer, child, elements, attributes, text, pi);
        }
    }

    private void appendXMLSignature(StringBuilder buffer, Object object, boolean elements, boolean attributes, boolean text, boolean pi) {
        if (object instanceof Document) {
            buffer.append("<D>");
            this.appendXMLSignature(buffer, ((Document)object).getContent(), elements, attributes, text, pi);
            buffer.append("</D");
        } else if (object instanceof Element) {
            String tag = elements ? ((Element)object).getName() : "E";
            buffer.append("<");
            buffer.append(tag);
            buffer.append(">");
            this.appendXMLSignature(buffer, ((Element)object).getContent(), elements, attributes, text, pi);
            buffer.append("</");
            buffer.append(tag);
            buffer.append(">");
        } else if ((object instanceof Text || object instanceof CDATA) && text) {
            String string = ((Text)object).getText();
            string = string.replace('\n', '=');
            buffer.append(string);
        }
    }

    @Override
    protected AbstractFactory getAbstractFactory() {
        return new TestJDOMFactory();
    }

    @Override
    protected String getModel() {
        return "JDOM";
    }

    @Override
    protected String getXMLSignature(Object node, boolean elements, boolean attributes, boolean text, boolean pi) {
        StringBuilder buffer = new StringBuilder();
        this.appendXMLSignature(buffer, node, elements, attributes, text, pi);
        return buffer.toString();
    }

    @Test
    public void testGetElementDescendantOrSelf() {
        JXPathContext childContext = this.context.getRelativeContext(this.context.getPointer("/vendor"));
        Assertions.assertInstanceOf(Element.class, (Object)childContext.getContextBean());
        this.assertXPathNodeType(childContext, "//vendor", Element.class);
    }

    @Test
    public void testGetNode() {
        this.assertXPathNodeType(this.context, "/", Document.class);
        this.assertXPathNodeType(this.context, "/vendor/location", Element.class);
        this.assertXPathNodeType(this.context, "//location/@name", Attribute.class);
        this.assertXPathNodeType(this.context, "//vendor", Element.class);
    }

    @Override
    @Test
    @Disabled(value="id() is not supported by JDOM")
    public void testID() {
    }
}

