/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class NodeSetContext
extends EvalContext {
    private boolean startedSet;
    private final NodeSet nodeSet;

    public NodeSetContext(EvalContext parentContext, NodeSet nodeSet) {
        super(parentContext);
        this.nodeSet = nodeSet;
    }

    @Override
    public NodePointer getCurrentNodePointer() {
        if (this.position == 0 && !this.setPosition(1)) {
            return null;
        }
        return (NodePointer)this.nodeSet.getPointers().get(this.position - 1);
    }

    @Override
    public NodeSet getNodeSet() {
        return this.nodeSet;
    }

    @Override
    public boolean nextNode() {
        return this.setPosition(this.position + 1);
    }

    @Override
    public boolean nextSet() {
        if (this.startedSet) {
            return false;
        }
        this.startedSet = true;
        return true;
    }

    @Override
    public boolean setPosition(int position) {
        super.setPosition(position);
        return position >= 1 && position <= this.nodeSet.getPointers().size();
    }
}

