/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.internal.introspection.ArrayIterator;
import org.apache.commons.jexl3.internal.introspection.ArrayListWrapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MiscIntrospectionTest {
    @Test
    public void testArrayIterator() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ArrayIterator(new ArrayList()));
        ArrayIterator ai0 = new ArrayIterator(null);
        Assertions.assertFalse((boolean)ai0.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((ArrayIterator)ai0).next());
        ai0 = new ArrayIterator((Object)new int[]{42});
        Assertions.assertTrue((boolean)ai0.hasNext());
        Assertions.assertEquals((Object)42, (Object)ai0.next());
        Assertions.assertFalse((boolean)ai0.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((ArrayIterator)ai0).next());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ai0.remove());
    }

    @Test
    public void testArrayListWrapper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ArrayListWrapper((Object)1));
        Integer[] ai = new Integer[]{1, 2};
        ArrayListWrapper alw = new ArrayListWrapper((Object)ai);
        Assertions.assertEquals((int)1, (int)alw.indexOf((Object)2));
        Assertions.assertEquals((int)-1, (int)alw.indexOf(null));
    }

    @Test
    public void testEmptyContext() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> JexlEngine.EMPTY_CONTEXT.set("nope", (Object)42));
    }
}

