/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.AbstractFileUploadWrapper;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractFileUploadTest<AFU extends AbstractFileUpload<R, I, F>, R, I extends FileItem<I>, F extends FileItemFactory<I>>
extends AbstractFileUploadWrapper<AFU, R, I, F> {
    protected AbstractFileUploadTest(AFU fileUpload) {
        super(fileUpload);
    }

    private void assertHeaders(String[] headerNames, String[] headerValues, I fileItems, int index) {
        for (int i = 0; i < headerNames.length; ++i) {
            String value = fileItems.getHeaders().getHeader(headerNames[i]);
            if (i == index) {
                Assertions.assertEquals((Object)headerValues[i], (Object)value);
                continue;
            }
            Assertions.assertNull((Object)value);
        }
    }

    @Test
    void testContentTypeAttachment() throws IOException {
        List fileItems = this.parseUpload(this.upload, "-----1234\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n-----1234\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed, boundary=---9876\r\n\r\n-----9876\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n-----9876--\r\n-----1234--\r\n");
        Assertions.assertEquals((int)2, (int)fileItems.size());
        FileItem field = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"field1", (Object)field.getFieldName());
        Assertions.assertTrue((boolean)field.isFormField());
        Assertions.assertEquals((Object)"Joe Blow", (Object)field.getString());
        FileItem fileItem = (FileItem)fileItems.get(1);
        Assertions.assertEquals((Object)"pics", (Object)fileItem.getFieldName());
        Assertions.assertFalse((boolean)fileItem.isFormField());
        Assertions.assertEquals((Object)"... contents of file1.txt ...", (Object)fileItem.getString());
        Assertions.assertEquals((Object)"text/plain", (Object)fileItem.getContentType());
        Assertions.assertEquals((Object)"file1.txt", (Object)fileItem.getName());
    }

    @Test
    void testEmptyFile() throws IOException {
        List fileItems = this.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"\"\r\n\r\n\r\n-----1234--\r\n");
        Assertions.assertEquals((int)1, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        Assertions.assertFalse((boolean)file.isFormField());
        Assertions.assertEquals((Object)"", (Object)file.getString());
        Assertions.assertEquals((Object)"", (Object)file.getName());
    }

    @Test
    void testFileNameCaseSensitivity() throws IOException {
        List fileItems = this.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"FiLe\"; filename=\"FOO.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n");
        Assertions.assertEquals((int)1, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"FiLe", (Object)file.getFieldName());
        Assertions.assertEquals((Object)"FOO.tab", (Object)file.getName());
    }

    @Test
    public void testFileUpload() throws IOException {
        List fileItems = this.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assertions.assertEquals((int)4, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"file", (Object)file.getFieldName());
        Assertions.assertFalse((boolean)file.isFormField());
        Assertions.assertEquals((Object)"This is the content of the file\n", (Object)file.getString());
        Assertions.assertEquals((Object)"text/whatever", (Object)file.getContentType());
        Assertions.assertEquals((Object)"foo.tab", (Object)file.getName());
        FileItem field = (FileItem)fileItems.get(1);
        Assertions.assertEquals((Object)"field", (Object)field.getFieldName());
        Assertions.assertTrue((boolean)field.isFormField());
        Assertions.assertEquals((Object)"fieldValue", (Object)field.getString());
        FileItem multi0 = (FileItem)fileItems.get(2);
        Assertions.assertEquals((Object)"multi", (Object)multi0.getFieldName());
        Assertions.assertTrue((boolean)multi0.isFormField());
        Assertions.assertEquals((Object)"value1", (Object)multi0.getString());
        FileItem multi1 = (FileItem)fileItems.get(3);
        Assertions.assertEquals((Object)"multi", (Object)multi1.getFieldName());
        Assertions.assertTrue((boolean)multi1.isFormField());
        Assertions.assertEquals((Object)"value2", (Object)multi1.getString());
    }

    @Test
    void testFileUpload130() throws IOException {
        String[] headerNames = new String[]{"SomeHeader", "OtherHeader", "YetAnotherHeader", "WhatAHeader"};
        String[] headerValues = new String[]{"present", "Is there", "Here", "Is That"};
        List fileItems = this.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n" + headerNames[0] + ": " + headerValues[0] + "\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; \r\n\tname=\"field\"\r\n" + headerNames[1] + ": " + headerValues[1] + "\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data;\r\n     name=\"multi\"\r\n" + headerNames[2] + ": " + headerValues[2] + "\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n" + headerNames[3] + ": " + headerValues[3] + "\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assertions.assertEquals((int)4, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        this.assertHeaders(headerNames, headerValues, file, 0);
        FileItem field = (FileItem)fileItems.get(1);
        this.assertHeaders(headerNames, headerValues, field, 1);
        FileItem multi0 = (FileItem)fileItems.get(2);
        this.assertHeaders(headerNames, headerValues, multi0, 2);
        FileItem multi1 = (FileItem)fileItems.get(3);
        this.assertHeaders(headerNames, headerValues, multi1, 3);
    }

    @Test
    void testFILEUPLOAD62() throws IOException {
        String contentType = "multipart/form-data; boundary=AaB03x";
        String request = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--";
        List fileItems = this.parseUpload(this.upload, "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--".getBytes(StandardCharsets.US_ASCII), "multipart/form-data; boundary=AaB03x");
        Assertions.assertEquals((int)3, (int)fileItems.size());
        FileItem item0 = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"field1", (Object)item0.getFieldName());
        Assertions.assertNull((Object)item0.getName());
        Assertions.assertEquals((Object)"Joe Blow", (Object)new String(item0.get()));
        FileItem item1 = (FileItem)fileItems.get(1);
        Assertions.assertEquals((Object)"pics", (Object)item1.getFieldName());
        Assertions.assertEquals((Object)"file1.txt", (Object)item1.getName());
        Assertions.assertEquals((Object)"... contents of file1.txt ...", (Object)new String(item1.get()));
        FileItem item2 = (FileItem)fileItems.get(2);
        Assertions.assertEquals((Object)"pics", (Object)item2.getFieldName());
        Assertions.assertEquals((Object)"file2.gif", (Object)item2.getName());
        Assertions.assertEquals((Object)"...contents of file2.gif...", (Object)new String(item2.get()));
    }

    @Test
    void testFoldedHeaders() throws IOException {
        List fileItems = this.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; \r\n\tname=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data;\r\n     name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assertions.assertEquals((int)4, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"file", (Object)file.getFieldName());
        Assertions.assertFalse((boolean)file.isFormField());
        Assertions.assertEquals((Object)"This is the content of the file\n", (Object)file.getString());
        Assertions.assertEquals((Object)"text/whatever", (Object)file.getContentType());
        Assertions.assertEquals((Object)"foo.tab", (Object)file.getName());
        FileItem field = (FileItem)fileItems.get(1);
        Assertions.assertEquals((Object)"field", (Object)field.getFieldName());
        Assertions.assertTrue((boolean)field.isFormField());
        Assertions.assertEquals((Object)"fieldValue", (Object)field.getString());
        FileItem multi0 = (FileItem)fileItems.get(2);
        Assertions.assertEquals((Object)"multi", (Object)multi0.getFieldName());
        Assertions.assertTrue((boolean)multi0.isFormField());
        Assertions.assertEquals((Object)"value1", (Object)multi0.getString());
        FileItem multi1 = (FileItem)fileItems.get(3);
        Assertions.assertEquals((Object)"multi", (Object)multi1.getFieldName());
        Assertions.assertTrue((boolean)multi1.isFormField());
        Assertions.assertEquals((Object)"value2", (Object)multi1.getString());
    }

    @Test
    void testIE5MacBug() throws IOException {
        List fileItems = this.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"field1\"\r\n\r\nfieldValue\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.x\"\r\n\r\n42\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.y\"\r\n\r\n21\r\n-----1234\r\nContent-Disposition: form-data; name=\"field2\"\r\n\r\nfieldValue2\r\n-----1234--\r\n");
        Assertions.assertEquals((int)4, (int)fileItems.size());
        FileItem field1 = (FileItem)fileItems.get(0);
        Assertions.assertEquals((Object)"field1", (Object)field1.getFieldName());
        Assertions.assertTrue((boolean)field1.isFormField());
        Assertions.assertEquals((Object)"fieldValue", (Object)field1.getString());
        FileItem submitX = (FileItem)fileItems.get(1);
        Assertions.assertEquals((Object)"submitName.x", (Object)submitX.getFieldName());
        Assertions.assertTrue((boolean)submitX.isFormField());
        Assertions.assertEquals((Object)"42", (Object)submitX.getString());
        FileItem submitY = (FileItem)fileItems.get(2);
        Assertions.assertEquals((Object)"submitName.y", (Object)submitY.getFieldName());
        Assertions.assertTrue((boolean)submitY.isFormField());
        Assertions.assertEquals((Object)"21", (Object)submitY.getString());
        FileItem field2 = (FileItem)fileItems.get(3);
        Assertions.assertEquals((Object)"field2", (Object)field2.getFieldName());
        Assertions.assertTrue((boolean)field2.isFormField());
        Assertions.assertEquals((Object)"fieldValue2", (Object)field2.getString());
    }

    @Test
    void testMultipleRelated() throws Exception {
        String soapEnvelope = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\r\n  <soap:Header></soap:Header>\r\n  <soap:Body>\r\n    <ns1:Test xmlns:ns1=\"http://www.test.org/some-test-namespace\">\r\n      <ns1:Attachment>\r\n        <xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"ref-to-attachment%40some.domain.org\"/>\r\n      </ns1:Attachment>\r\n    </ns1:Test>\r\n  </soap:Body>\r\n</soap:Envelope>";
        String text = "-----1234\r\ncontent-type: application/xop+xml; type=\"application/soap+xml\"\r\n\r\n<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\r\n  <soap:Header></soap:Header>\r\n  <soap:Body>\r\n    <ns1:Test xmlns:ns1=\"http://www.test.org/some-test-namespace\">\r\n      <ns1:Attachment>\r\n        <xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"ref-to-attachment%40some.domain.org\"/>\r\n      </ns1:Attachment>\r\n    </ns1:Test>\r\n  </soap:Body>\r\n</soap:Envelope>\r\n-----1234\r\nContent-type: text/plain\r\ncontent-id: <ref-to-attachment@some.domain.org>\r\n\r\nsome text/plain content\r\n-----1234--\r\n";
        byte[] bytes = "-----1234\r\ncontent-type: application/xop+xml; type=\"application/soap+xml\"\r\n\r\n<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\r\n  <soap:Header></soap:Header>\r\n  <soap:Body>\r\n    <ns1:Test xmlns:ns1=\"http://www.test.org/some-test-namespace\">\r\n      <ns1:Attachment>\r\n        <xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"ref-to-attachment%40some.domain.org\"/>\r\n      </ns1:Attachment>\r\n    </ns1:Test>\r\n  </soap:Body>\r\n</soap:Envelope>\r\n-----1234\r\nContent-type: text/plain\r\ncontent-id: <ref-to-attachment@some.domain.org>\r\n\r\nsome text/plain content\r\n-----1234--\r\n".getBytes(StandardCharsets.US_ASCII);
        List fileItems = this.parseUpload(this.upload, bytes, "multipart/related; boundary=---1234; type=\"application/xop+xml\"; start-info=\"application/soap+xml\"");
        Assertions.assertEquals((int)2, (int)fileItems.size());
        FileItem part1 = (FileItem)fileItems.get(0);
        Assertions.assertNull((Object)part1.getFieldName());
        Assertions.assertFalse((boolean)part1.isFormField());
        Assertions.assertEquals((Object)"<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\r\n  <soap:Header></soap:Header>\r\n  <soap:Body>\r\n    <ns1:Test xmlns:ns1=\"http://www.test.org/some-test-namespace\">\r\n      <ns1:Attachment>\r\n        <xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"ref-to-attachment%40some.domain.org\"/>\r\n      </ns1:Attachment>\r\n    </ns1:Test>\r\n  </soap:Body>\r\n</soap:Envelope>", (Object)part1.getString());
        FileItem part2 = (FileItem)fileItems.get(1);
        Assertions.assertNull((Object)part2.getFieldName());
        Assertions.assertFalse((boolean)part2.isFormField());
        Assertions.assertEquals((Object)"some text/plain content", (Object)part2.getString());
        Assertions.assertEquals((Object)"text/plain", (Object)part2.getContentType());
        Assertions.assertNull((Object)part2.getName());
    }
}

