/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.HomeDirectoryLocationStrategy;
import org.apache.commons.lang3.SystemProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

public class TestHomeDirectoryLocationStrategy {
    private static final String FILE_NAME = "test.tst";
    private static final String BASE_PATH = "sub";
    @TempDir
    public File tempFolder;
    private FileSystem fileSystem;

    @BeforeEach
    public void setUp() throws Exception {
        this.fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
    }

    private HomeDirectoryLocationStrategy setUpStrategy(boolean withBasePath) {
        return new HomeDirectoryLocationStrategy(this.tempFolder.getAbsolutePath(), withBasePath);
    }

    @Test
    public void testInitDefaults() {
        HomeDirectoryLocationStrategy strategy = new HomeDirectoryLocationStrategy();
        Assertions.assertEquals((Object)SystemProperties.getUserHome(), (Object)strategy.getHomeDirectory());
        Assertions.assertFalse((boolean)strategy.isEvaluateBasePath());
    }

    @Test
    public void testLocateFailedWithBasePath() throws IOException {
        TempDirUtils.newFile(FILE_NAME, this.tempFolder);
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(true);
        Assertions.assertNull((Object)strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testLocateSuccessIgnoreBasePath() throws IOException {
        File file = TempDirUtils.newFile(FILE_NAME, this.tempFolder);
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(false);
        URL url = strategy.locate(this.fileSystem, locator);
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile());
    }

    @Test
    public void testLocateSuccessInSubFolder() throws IOException {
        File sub = TempDirUtils.newFolder(BASE_PATH, this.tempFolder);
        File file = new File(sub, FILE_NAME);
        Assertions.assertTrue((boolean)file.createNewFile());
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(true);
        URL url = strategy.locate(this.fileSystem, locator);
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile());
    }

    @Test
    public void testLocateSuccessNoBasePath() throws IOException {
        File file = TempDirUtils.newFile(FILE_NAME, this.tempFolder);
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(true);
        URL url = strategy.locate(this.fileSystem, locator);
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile());
    }

    @Test
    public void testNoFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(true);
        Assertions.assertNull((Object)strategy.locate(this.fileSystem, locator));
    }
}

