/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.DynamicCombinedConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.XMLPropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderEventListenerImpl;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.CopyObjectDefaultHandler;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedBuilderProperties;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.PropertiesBuilderParametersImpl;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.builder.XMLBuilderProperties;
import org.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.ConfigurationBuilderProvider;
import org.apache.commons.configuration2.builder.combined.ConfigurationDeclaration;
import org.apache.commons.configuration2.builder.fluent.CombinedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingControllerSupport;
import org.apache.commons.configuration2.resolver.CatalogResolver;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCombinedConfigurationBuilder {
    private static final File TEST_FILE = ConfigurationAssert.getTestFile("testDigesterConfiguration.xml");
    private static final String TEST_SUB_XML = "test.xml";
    private static final String BUILDER_NAME = "subBuilderName";
    private static final String MULTI_FILE_PROPERTY = "Id";
    protected Parameters parameters;
    protected CombinedConfigurationBuilder builder;

    private static void checkCombinedConfigAttrs(CombinedConfiguration cc) {
        ListDelimiterHandler handler = cc.getListDelimiterHandler();
        Assertions.assertInstanceOf(DefaultListDelimiterHandler.class, (Object)handler);
        Assertions.assertEquals((char)',', (char)((DefaultListDelimiterHandler)handler).getDelimiter());
    }

    protected static BasicConfigurationBuilder<? extends BaseHierarchicalConfiguration> createDefinitionBuilder(BaseHierarchicalConfiguration defConfig) {
        return new ConstantConfigurationBuilder(defConfig);
    }

    protected static BaseHierarchicalConfiguration createDefinitionConfig(String tag, Map<String, Object> attrs) {
        BaseHierarchicalConfiguration defConfig = new BaseHierarchicalConfiguration();
        String prefix = "override." + tag;
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            defConfig.addProperty(prefix + "[@" + e.getKey() + "]", e.getValue());
        }
        return defConfig;
    }

    private static XMLBuilderParameters prepareParamsForInheritanceTest(Parameters params) {
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setPropertyDelimiter("/").create();
        DefaultExpressionEngine engine = new DefaultExpressionEngine(symbols);
        DefaultListDelimiterHandler listDelimiterHandler = new DefaultListDelimiterHandler(',');
        return (XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)params.xml().setExpressionEngine((ExpressionEngine)engine)).setListDelimiterHandler((ListDelimiterHandler)listDelimiterHandler)).setFile(TEST_FILE);
    }

    private static void switchToMultiFile(String key) {
        System.setProperty(MULTI_FILE_PROPERTY, key);
    }

    private CombinedConfiguration checkConfiguration() throws ConfigurationException {
        CombinedConfiguration compositeConfiguration = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertEquals((int)3, (int)compositeConfiguration.getNumberOfConfigurations());
        Assertions.assertEquals(PropertiesConfiguration.class, (Object)compositeConfiguration.getConfiguration(0).getClass());
        Assertions.assertEquals(XMLPropertiesConfiguration.class, (Object)compositeConfiguration.getConfiguration(1).getClass());
        Assertions.assertEquals(XMLConfiguration.class, (Object)compositeConfiguration.getConfiguration(2).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)compositeConfiguration.getConfiguration(0);
        Assertions.assertNotNull((Object)pc);
        this.checkProperties((Configuration)compositeConfiguration);
        return compositeConfiguration;
    }

    private void checkFileSystem(File fsFile) throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(fsFile)});
        this.builder.getConfiguration();
        FileBasedConfigurationBuilder xmlBuilder = (FileBasedConfigurationBuilder)this.builder.getNamedBuilder("xml");
        Assertions.assertInstanceOf(FileSystemTestImpl.class, (Object)xmlBuilder.getFileHandler().getFileSystem());
    }

    private void checkMultiFile(String key, CombinedConfiguration config, int rows) {
        TestCombinedConfigurationBuilder.switchToMultiFile(key);
        Assertions.assertEquals((int)rows, (int)config.getInt("rowsPerPage"));
    }

    private void checkProperties(Configuration compositeConfiguration) {
        Assertions.assertTrue((boolean)compositeConfiguration.getBoolean("test.boolean"));
        Assertions.assertEquals((Object)"I'm complex!", (Object)compositeConfiguration.getProperty("element2.subelement.subsubelement"));
        Assertions.assertEquals((Object)"value1", (Object)compositeConfiguration.getProperty("key1"));
    }

    private CombinedConfiguration createMultiFileConfig(String fileName) throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile(fileName);
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(testFile)});
        CombinedConfiguration config = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertInstanceOf(DynamicCombinedConfiguration.class, (Object)config);
        return config;
    }

    protected FileBasedBuilderParameters createParameters() {
        return this.parameters.fileBased();
    }

    private BasicConfigurationBuilder<? extends HierarchicalConfiguration<ImmutableNode>> prepareSubBuilderTest(Map<String, Object> attrs) {
        attrs.put("fileName", TEST_SUB_XML);
        attrs.put("config-name", BUILDER_NAME);
        BaseHierarchicalConfiguration defConfig = TestCombinedConfigurationBuilder.createDefinitionConfig("xml", attrs);
        BasicConfigurationBuilder<? extends BaseHierarchicalConfiguration> defBuilder = TestCombinedConfigurationBuilder.createDefinitionBuilder(defConfig);
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilder(defBuilder)});
        return defBuilder;
    }

    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.apache.commons.configuration2.MockInitialContextFactory");
        System.setProperty("test_file_xml", TEST_SUB_XML);
        System.setProperty("test_file_combine", "testcombine1.xml");
        this.parameters = new Parameters();
        this.builder = new CombinedConfigurationBuilder();
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.getProperties().remove(MULTI_FILE_PROPERTY);
    }

    @Test
    public void testBasePathForChildConfigurations() throws ConfigurationException {
        BaseHierarchicalConfiguration defConfig = new BaseHierarchicalConfiguration();
        defConfig.addProperty("properties[@fileName]", (Object)"test.properties");
        File deepDir = new File(ConfigurationAssert.TEST_DIR, "config/deep");
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setBasePath(deepDir.getAbsolutePath()).setDefinitionBuilder((ConfigurationBuilder)new ConstantConfigurationBuilder(defConfig))});
        CombinedConfiguration config = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertEquals((Object)"somevalue", (Object)config.getString("somekey"));
    }

    @Test
    public void testBuilderNames() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        this.builder.getConfiguration();
        Set names = this.builder.builderNames();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("props", "xml")), (Object)names);
    }

    @Test
    public void testBuilderNamesBeforeConfigurationAccess() {
        Assertions.assertEquals(Collections.emptySet(), (Object)this.builder.builderNames());
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        Assertions.assertEquals(Collections.emptySet(), (Object)this.builder.builderNames());
    }

    @Test
    public void testBuilderNamesManipulate() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        this.builder.getConfiguration();
        Set names = this.builder.builderNames();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> names.add(BUILDER_NAME));
    }

    @Test
    public void testChildBuildersAreInitializedOnlyOnce() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        this.builder.getConfiguration();
        this.builder.resetResult();
        this.builder.getConfiguration();
        Collection childBuilders = this.builder.getChildBuilders();
        Assertions.assertEquals((int)3, (int)childBuilders.size());
    }

    @Test
    public void testCombinedConfigurationAttributes() throws ConfigurationException {
        File initFile = ConfigurationAssert.getTestFile("testCCResultInitialization.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(initFile)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        TestCombinedConfigurationBuilder.checkCombinedConfigAttrs(cc);
        CombinedConfiguration cc2 = (CombinedConfiguration)cc.getConfiguration(CombinedConfigurationBuilder.ADDITIONAL_NAME);
        TestCombinedConfigurationBuilder.checkCombinedConfigAttrs(cc2);
    }

    @Test
    public void testCombinedConfigurationListNodes() throws ConfigurationException {
        File initFile = ConfigurationAssert.getTestFile("testCCResultInitialization.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(initFile)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Set listNodes = cc.getNodeCombiner().getListNodes();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("table", "list")), (Object)listNodes);
        CombinedConfiguration cca = (CombinedConfiguration)cc.getConfiguration(CombinedConfigurationBuilder.ADDITIONAL_NAME);
        listNodes = cca.getNodeCombiner().getListNodes();
        Assertions.assertEquals(Collections.emptySet(), (Object)listNodes);
    }

    @Test
    public void testCombinedConfigurationNoAdditional() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertNull((Object)cc.getConfiguration(CombinedConfigurationBuilder.ADDITIONAL_NAME));
    }

    @Test
    public void testConcurrentReadAccessWithoutSynchronizer() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        CombinedConfiguration config = (CombinedConfiguration)this.builder.getConfiguration();
        int threadCount = 32;
        CountDownLatch startLatch = new CountDownLatch(1);
        ReadThread[] threads = new ReadThread[32];
        for (int i = 0; i < 32; ++i) {
            threads[i] = new ReadThread(config, startLatch);
            threads[i].start();
        }
        startLatch.countDown();
        for (ReadThread t : threads) {
            t.verify();
        }
    }

    @Test
    public void testConfigurationBuilderProvider() throws ConfigurationException {
        BaseHierarchicalConfiguration defConfig = new BaseHierarchicalConfiguration();
        defConfig.addProperty("override.configuration[@fileName]", (Object)TEST_FILE.getAbsolutePath());
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilder((ConfigurationBuilder)new ConstantConfigurationBuilder(defConfig))});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)cc.getNumberOfConfigurations());
        this.checkProperties((Configuration)cc);
    }

    @Test
    public void testConfigurationBuilderProviderInheritBasePath() throws ConfigurationException {
        File envFile = ConfigurationAssert.getTestFile("testCCEnvProperties.xml");
        String basePath = ConfigurationAssert.OUT_DIR.getAbsolutePath();
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setBasePath(basePath).setDefinitionBuilderParameters((BuilderParameters)this.createParameters().setFile(envFile))});
        this.builder.getConfiguration();
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        this.builder.initChildBuilderParameters((BuilderParameters)params);
        Assertions.assertEquals((Object)basePath, (Object)params.getBasePath());
    }

    @Test
    public void testConfigurationBuilderProviderInheritBasicProperties() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testCCCombinedChildBuilder.xml");
        DefaultListDelimiterHandler listHandler = new DefaultListDelimiterHandler('*');
        ConfigurationDecoder decoder = (ConfigurationDecoder)Mockito.mock(ConfigurationDecoder.class);
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilderParameters((BuilderParameters)new XMLBuilderParametersImpl().setFile(testFile)).setListDelimiterHandler((ListDelimiterHandler)listHandler).setConfigurationDecoder(decoder)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        CombinedConfiguration cc2 = (CombinedConfiguration)cc.getConfiguration("subcc");
        Assertions.assertFalse((boolean)cc2.isThrowExceptionOnMissing());
        Assertions.assertEquals((Object)listHandler, (Object)cc2.getListDelimiterHandler());
        Assertions.assertEquals((Object)decoder, (Object)cc2.getConfigurationDecoder());
    }

    @Test
    public void testConfigurationBuilderProviderInheritCustomProviders() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(ConfigurationAssert.getTestFile("testCCCustomProvider.xml"))});
        this.builder.getConfiguration();
        CombinedBuilderParametersImpl ccparams = new CombinedBuilderParametersImpl();
        this.builder.initChildBuilderParameters((BuilderParameters)ccparams);
        Assertions.assertNotNull((Object)ccparams.providerForTag("test"));
    }

    @Test
    public void testConfigurationBuilderProviderInheritEventListeners() throws ConfigurationException {
        EventListener l1 = (EventListener)Mockito.mock(EventListener.class);
        EventListener l2 = (EventListener)Mockito.mock(EventListener.class);
        File testFile = ConfigurationAssert.getTestFile("testCCCombinedChildBuilder.xml");
        this.builder.configure(new BuilderParameters[]{new XMLBuilderParametersImpl().setFile(testFile)});
        this.builder.addEventListener(Event.ANY, l1);
        this.builder.addEventListener(ConfigurationEvent.ANY, l2);
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        CombinedConfiguration cc2 = (CombinedConfiguration)cc.getConfiguration("subcc");
        Collection listeners = cc2.getEventListeners(ConfigurationEvent.ANY);
        Assertions.assertTrue((boolean)listeners.contains(l1));
        Assertions.assertTrue((boolean)listeners.contains(l2));
        Collection eventListeners = cc2.getEventListeners(Event.ANY);
        Assertions.assertEquals((int)1, (int)eventListeners.size());
        Assertions.assertTrue((boolean)eventListeners.contains(l1));
    }

    @Test
    public void testConfigureEntityResolverWithProperties() throws ConfigurationException {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("header.entity-resolver[@config-class]", (Object)EntityResolverWithPropertiesTestImpl.class.getName());
        XMLBuilderParametersImpl xmlParams = new XMLBuilderParametersImpl();
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        String baseDir = "target";
        xmlParams.setBasePath("target");
        xmlParams.setFileSystem(fs);
        this.builder.configureEntityResolver((HierarchicalConfiguration)config, xmlParams);
        EntityResolverWithPropertiesTestImpl resolver = (EntityResolverWithPropertiesTestImpl)((Object)xmlParams.getEntityResolver());
        Assertions.assertSame((Object)fs, (Object)resolver.getFileSystem());
        Assertions.assertSame((Object)"target", (Object)resolver.getBaseDir());
    }

    @Test
    public void testConfigureResult() {
        CombinedConfigurationBuilder configuredBuilder = this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        Assertions.assertSame((Object)this.builder, (Object)configuredBuilder);
    }

    @Test
    public void testCustomBuilderProvider() throws ConfigurationException {
        String tagName = "myTestTag";
        BaseHierarchicalConfiguration dataConf = new BaseHierarchicalConfiguration();
        dataConf.addProperty("myTestTag", (Object)Boolean.TRUE);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("config-name", BUILDER_NAME);
        attrs.put("config-at", "tests");
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilder(TestCombinedConfigurationBuilder.createDefinitionBuilder(TestCombinedConfigurationBuilder.createDefinitionConfig("myTestTag", attrs))).registerProvider("myTestTag", decl -> new ConstantConfigurationBuilder(dataConf))});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertEquals((Object)dataConf, (Object)cc.getConfiguration(BUILDER_NAME));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)cc.getProperty("tests.myTestTag"));
    }

    @Test
    public void testCustomEntityResolver() throws ConfigurationException {
        File resolverFile = ConfigurationAssert.getTestFile("testCCEntityResolver.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(resolverFile)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        XMLConfiguration xmlConf = (XMLConfiguration)cc.getConfiguration("xml");
        EntityResolverWithPropertiesTestImpl resolver = (EntityResolverWithPropertiesTestImpl)((Object)xmlConf.getEntityResolver());
        Assertions.assertFalse((boolean)resolver.getInterpolator().getLookups().isEmpty());
    }

    @Test
    public void testCustomFileSystem() throws ConfigurationException {
        this.checkFileSystem(ConfigurationAssert.getTestFile("testCCFileSystem.xml"));
    }

    @Test
    public void testCustomFileSystemForSubConfig() throws ConfigurationException {
        this.checkFileSystem(ConfigurationAssert.getTestFile("testCCFileSystemSubConfig.xml"));
    }

    @Test
    public void testCustomLookup() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testCCLookup.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(testFile)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertTrue((boolean)cc.getInterpolator().getLookups().containsKey("test"));
        Configuration xmlConf = cc.getConfiguration("xml");
        Assertions.assertTrue((boolean)xmlConf.getInterpolator().getLookups().containsKey("test"));
    }

    @Test
    public void testCustomResultConfiguration() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testCCResultClass.xml");
        DefaultListDelimiterHandler listHandler = new DefaultListDelimiterHandler('.');
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilderParameters((BuilderParameters)new XMLBuilderParametersImpl().setFile(testFile)).setListDelimiterHandler((ListDelimiterHandler)listHandler).setThrowExceptionOnMissing(false)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertInstanceOf(CombinedConfigurationTestImpl.class, (Object)cc);
        Assertions.assertTrue((boolean)cc.isThrowExceptionOnMissing());
        Assertions.assertEquals((Object)listHandler, (Object)cc.getListDelimiterHandler());
    }

    @Test
    public void testDefaultBasePathFromDefinitionBuilder() throws ConfigurationException, IOException {
        String testFile = "testCCSystemProperties.xml";
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilderParameters((BuilderParameters)((FileBasedBuilderParameters)this.createParameters().setBasePath(ConfigurationAssert.TEST_DIR.getAbsolutePath())).setFileName("testCCSystemProperties.xml"))});
        this.builder.getConfiguration();
        XMLBuilderParametersImpl xmlParams = new XMLBuilderParametersImpl();
        this.builder.initChildBuilderParameters((BuilderParameters)xmlParams);
        File basePathFile = FileLocatorUtils.fileFromURL((URL)new URL(xmlParams.getFileHandler().getBasePath()));
        Assertions.assertEquals((Object)ConfigurationAssert.getTestFile("testCCSystemProperties.xml").getAbsoluteFile(), (Object)basePathFile);
    }

    @Test
    public void testDefaultBasePathInParameters() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testCCSystemProperties.xml");
        String basePath = ConfigurationAssert.OUT_DIR.getAbsolutePath();
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setBasePath(basePath).setDefinitionBuilderParameters((BuilderParameters)this.createParameters().setFile(testFile))});
        this.builder.getConfiguration();
        XMLBuilderParametersImpl xmlParams = new XMLBuilderParametersImpl();
        this.builder.initChildBuilderParameters((BuilderParameters)xmlParams);
        Assertions.assertEquals((Object)basePath, (Object)xmlParams.getFileHandler().getBasePath());
    }

    @Test
    public void testEnvironmentProperties() throws ConfigurationException {
        File envFile = ConfigurationAssert.getTestFile("testCCEnvProperties.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(envFile)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertFalse((boolean)cc.isEmpty());
        cc.setInterpolator(null);
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            Assertions.assertEquals((Object)e.getValue(), (Object)cc.getString(e.getKey()), (String)("Wrong value for property: " + e.getKey()));
        }
    }

    @Test
    public void testGetChildBuilders() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        this.builder.getConfiguration();
        Collection childBuilders = this.builder.getChildBuilders();
        Assertions.assertEquals((int)3, (int)childBuilders.size());
    }

    @Test
    public void testGetNamedBuilder() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        this.builder.getConfiguration();
        ConfigurationBuilder propBuilder = this.builder.getNamedBuilder("props");
        Assertions.assertInstanceOf(FileBasedConfigurationBuilder.class, (Object)propBuilder);
        Assertions.assertInstanceOf(PropertiesConfiguration.class, (Object)propBuilder.getConfiguration());
    }

    @Test
    public void testGetNamedBuilderBeforeConfigurationAccess() {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        Assertions.assertThrows(ConfigurationException.class, () -> this.builder.getNamedBuilder("nonExistingBuilder"));
    }

    @Test
    public void testGetNamedBuilderUnknown() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        this.builder.getConfiguration();
        Assertions.assertThrows(ConfigurationException.class, () -> this.builder.getNamedBuilder("nonExistingBuilder"));
    }

    @Test
    public void testInheritProperties() throws ConfigurationException {
        Parameters params = new Parameters();
        XMLBuilderParameters xmlParams = TestCombinedConfigurationBuilder.prepareParamsForInheritanceTest(params);
        this.builder.configure(new BuilderParameters[]{xmlParams});
        CombinedConfiguration config = (CombinedConfiguration)this.builder.getConfiguration();
        List list = config.getList(String.class, "test/mixed/array");
        Assertions.assertTrue((list.size() > 2 ? 1 : 0) != 0);
        String[] stringArray = config.getStringArray("test/mixed/array");
        Assertions.assertTrue((stringArray.length > 2 ? 1 : 0) != 0);
        XMLConfiguration xmlConfig = (XMLConfiguration)config.getConfiguration("xml");
        list = xmlConfig.getList(String.class, "split/list1");
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testINIConfiguration() throws ConfigurationException {
        File multiFile = ConfigurationAssert.getTestFile("testDigesterConfiguration3.xml");
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilderParameters((BuilderParameters)this.createParameters().setFile(multiFile))});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertEquals((Object)"yes", (Object)cc.getString("testini.loaded"));
    }

    @Test
    public void testInitChildBuilderParametersDefaultChildProperties() throws ConfigurationException {
        Long defRefresh = 60000L;
        Long xmlRefresh = 30000L;
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)((CombinedBuilderParameters)((CombinedBuilderParameters)this.parameters.combined().setDefinitionBuilderParameters((BuilderParameters)this.parameters.fileBased().setFile(TEST_FILE))).registerChildDefaultsHandler(FileBasedBuilderProperties.class, (DefaultParametersHandler)new CopyObjectDefaultHandler((BuilderParameters)new FileBasedBuilderParametersImpl().setReloadingRefreshDelay(defRefresh).setThrowExceptionOnMissing(true)))).registerChildDefaultsHandler(XMLBuilderProperties.class, (DefaultParametersHandler)new CopyObjectDefaultHandler((BuilderParameters)new XMLBuilderParametersImpl().setValidating(false).setExpressionEngine((ExpressionEngine)new XPathExpressionEngine()).setReloadingRefreshDelay(xmlRefresh)))});
        this.builder.getConfiguration();
        XMLBuilderParametersImpl params = new XMLBuilderParametersImpl();
        this.builder.initChildBuilderParameters((BuilderParameters)params);
        Assertions.assertInstanceOf(XPathExpressionEngine.class, params.getParameters().get("expressionEngine"));
        Assertions.assertEquals((Object)Boolean.FALSE, params.getParameters().get("validating"));
        Assertions.assertEquals((Long)xmlRefresh, (Long)params.getReloadingRefreshDelay());
        Assertions.assertEquals((Object)Boolean.TRUE, params.getParameters().get("throwExceptionOnMissing"));
        PropertiesBuilderParametersImpl params2 = new PropertiesBuilderParametersImpl();
        this.builder.initChildBuilderParameters((BuilderParameters)params2);
        Assertions.assertEquals((Long)defRefresh, (Long)params2.getReloadingRefreshDelay());
    }

    @Test
    public void testInterpolationOverMultipleSources() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testInterpolationBuilder.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(testFile)});
        CombinedConfiguration combConfig = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertEquals((Object)"abc-product", (Object)combConfig.getString("products.product.desc"));
        XMLConfiguration xmlConfig = (XMLConfiguration)combConfig.getConfiguration("test");
        Assertions.assertEquals((Object)"abc-product", (Object)xmlConfig.getString("products/product/desc"));
        HierarchicalConfiguration subConfig = xmlConfig.configurationAt("products/product[@name='abc']", true);
        Assertions.assertEquals((Object)"abc-product", (Object)subConfig.getString("desc"));
    }

    @Test
    public void testJndiConfiguration() throws ConfigurationException {
        File multiFile = ConfigurationAssert.getTestFile("testDigesterConfiguration3.xml");
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilderParameters((BuilderParameters)this.createParameters().setFile(multiFile))});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertTrue((boolean)cc.getBoolean("test.onlyinjndi"));
    }

    @Test
    public void testLoadAdditional() throws ConfigurationException {
        File additonalFile = ConfigurationAssert.getTestFile("testDigesterConfiguration2.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(additonalFile)});
        CombinedConfiguration compositeConfiguration = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertEquals((int)2, (int)compositeConfiguration.getNumberOfConfigurations());
        Object prop = compositeConfiguration.getProperty("tables.table.name");
        Collection collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)3, (int)collection.size());
        Assertions.assertEquals((Object)"users", (Object)compositeConfiguration.getProperty("tables.table(0).name"));
        Assertions.assertEquals((Object)"documents", (Object)compositeConfiguration.getProperty("tables.table(1).name"));
        Assertions.assertEquals((Object)"tasks", (Object)compositeConfiguration.getProperty("tables.table(2).name"));
        prop = compositeConfiguration.getProperty("tables.table.fields.field.name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)17, (int)collection.size());
        Assertions.assertEquals((Object)"smtp.mydomain.org", (Object)compositeConfiguration.getString("mail.host.smtp"));
        Assertions.assertEquals((Object)"pop3.mydomain.org", (Object)compositeConfiguration.getString("mail.host.pop"));
        Assertions.assertEquals((Object)"masterOfPost", (Object)compositeConfiguration.getString("mail.account.user"));
        Assertions.assertEquals((Object)"topsecret", (Object)compositeConfiguration.getString("mail.account.psswd"));
        Assertions.assertEquals((Object)"enhanced factory", (Object)compositeConfiguration.getString("test.configuration"));
    }

    @Test
    public void testLoadConfiguration() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        this.checkConfiguration();
    }

    @Test
    public void testLoadOptional() throws Exception {
        File optionalFile = ConfigurationAssert.getTestFile("testDigesterOptionalConfiguration.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(optionalFile)});
        Configuration config = (Configuration)this.builder.getConfiguration();
        Assertions.assertTrue((boolean)config.getBoolean("test.boolean"));
        Assertions.assertEquals((Object)"value", (Object)config.getProperty("element"));
    }

    @Test
    public void testLoadOptionalForceCreate() throws ConfigurationException {
        String name = "optionalConfig";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("fileName", "nonExisting.xml");
        attrs.put("config-name", "optionalConfig");
        attrs.put("config-optional", Boolean.TRUE);
        attrs.put("config-forceCreate", Boolean.TRUE);
        BaseHierarchicalConfiguration defConfig = TestCombinedConfigurationBuilder.createDefinitionConfig("xml", attrs);
        BasicConfigurationBuilder<? extends BaseHierarchicalConfiguration> defBuilder = TestCombinedConfigurationBuilder.createDefinitionBuilder(defConfig);
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilder(defBuilder)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)cc.getNumberOfConfigurations());
        Assertions.assertInstanceOf(XMLConfiguration.class, (Object)cc.getConfiguration("optionalConfig"));
    }

    @Test
    public void testLoadOptionalWithException() {
        File optionalExFile = ConfigurationAssert.getTestFile("testDigesterOptionalConfigurationEx.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(optionalExFile)});
        Assertions.assertThrows(ConfigurationException.class, () -> ((CombinedConfigurationBuilder)this.builder).getConfiguration());
    }

    @Test
    public void testMultiTenentConfiguration() throws ConfigurationException {
        CombinedConfiguration config = this.createMultiFileConfig("testCCMultiTenent.xml");
        this.checkMultiFile("1001", config, 15);
        this.checkMultiFile("1002", config, 25);
        this.checkMultiFile("1003", config, 35);
        this.checkMultiFile("1004", config, 50);
    }

    @Test
    public void testMultiTenentConfigurationProperties() throws ConfigurationException {
        CombinedConfiguration config = this.createMultiFileConfig("testCCMultiTenent.xml");
        TestCombinedConfigurationBuilder.switchToMultiFile("1001");
        HierarchicalConfiguration multiConf = (HierarchicalConfiguration)config.getConfiguration("clientConfig");
        Assertions.assertInstanceOf(XPathExpressionEngine.class, (Object)multiConf.getExpressionEngine());
        Assertions.assertEquals((Object)"#808080", (Object)config.getString("colors.background"));
        Assertions.assertEquals((Object)"#000000", (Object)multiConf.getString("colors/text"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiTenentConfigurationReloading() throws ConfigurationException, InterruptedException {
        CombinedConfiguration config = this.createMultiFileConfig("testCCMultiTenentReloading.xml");
        File outFile = ConfigurationAssert.getOutFile("MultiFileReloadingTest.xml");
        TestCombinedConfigurationBuilder.switchToMultiFile(outFile.getAbsolutePath());
        XMLConfiguration reloadConfig = new XMLConfiguration();
        FileHandler handler = new FileHandler((FileBased)reloadConfig);
        handler.setFile(outFile);
        String key = "test.reload";
        reloadConfig.setProperty("test.reload", (Object)"no");
        handler.save();
        try {
            boolean changeDetected;
            Assertions.assertEquals((Object)"no", (Object)config.getString("test.reload"));
            ConfigurationBuilder childBuilder = this.builder.getNamedBuilder("clientConfig");
            ReloadingControllerSupport reloadingControllerSupport = (ReloadingControllerSupport)Assertions.assertInstanceOf(ReloadingControllerSupport.class, (Object)childBuilder);
            ReloadingController ctrl = reloadingControllerSupport.getReloadingController();
            ctrl.checkForReloading(null);
            BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
            childBuilder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
            reloadConfig.setProperty("test.reload", (Object)"yes");
            handler.save();
            int attempts = 10;
            do {
                if (changeDetected = ctrl.checkForReloading(null)) continue;
                Thread.sleep(1000L);
                handler.save(outFile);
            } while (!changeDetected && --attempts > 0);
            Assertions.assertTrue((boolean)changeDetected);
            Assertions.assertEquals((Object)"yes", (Object)((CombinedConfiguration)this.builder.getConfiguration()).getString("test.reload"));
            Object event = listener.nextEvent(ConfigurationBuilderEvent.RESET);
            listener.assertNoMoreEvents();
            BasicConfigurationBuilder multiBuilder = (BasicConfigurationBuilder)event.getSource();
            childBuilder.removeEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
            multiBuilder.resetResult();
            listener.assertNoMoreEvents();
        }
        finally {
            Assertions.assertTrue((boolean)outFile.delete());
        }
    }

    @Test
    public void testNoDefinitionBuilder() {
        Assertions.assertThrows(ConfigurationException.class, () -> ((CombinedConfigurationBuilder)this.builder).getConfiguration());
    }

    @Test
    public void testProviderInDefinitionConfig() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(ConfigurationAssert.getTestFile("testCCCustomProvider.xml"))});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertTrue((boolean)cc.getBoolean("testKey"));
    }

    @Test
    public void testReactOnSubBuilderChange() throws ConfigurationException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.prepareSubBuilderTest(attrs);
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        BasicConfigurationBuilder subBuilder = (BasicConfigurationBuilder)this.builder.getNamedBuilder(BUILDER_NAME);
        subBuilder.reset();
        Assertions.assertNotSame((Object)cc, (Object)this.builder.getConfiguration());
    }

    @Test
    public void testReloadingBuilder() throws ConfigurationException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("config-reload", Boolean.TRUE);
        this.prepareSubBuilderTest(attrs);
        this.builder.getConfiguration();
        Assertions.assertInstanceOf(ReloadingFileBasedConfigurationBuilder.class, (Object)this.builder.getNamedBuilder(BUILDER_NAME));
    }

    @Test
    public void testRemoveSubBuilderListener() throws ConfigurationException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.prepareSubBuilderTest(attrs);
        this.builder.getConfiguration();
        BasicConfigurationBuilder subBuilder = (BasicConfigurationBuilder)this.builder.getNamedBuilder(BUILDER_NAME);
        this.builder.reset();
        this.prepareSubBuilderTest(attrs);
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        BasicConfigurationBuilder subBuilder2 = (BasicConfigurationBuilder)this.builder.getNamedBuilder(BUILDER_NAME);
        Assertions.assertNotSame((Object)subBuilder, (Object)subBuilder2);
        subBuilder.reset();
        Assertions.assertSame((Object)cc, (Object)this.builder.getConfiguration());
    }

    @Test
    public void testResetBuilder() throws ConfigurationException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        BasicConfigurationBuilder<? extends HierarchicalConfiguration<ImmutableNode>> defBuilder = this.prepareSubBuilderTest(attrs);
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        ConfigurationBuilder subBuilder = this.builder.getNamedBuilder(BUILDER_NAME);
        defBuilder.reset();
        CombinedConfiguration cc2 = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertNotSame((Object)cc, (Object)cc2);
        ConfigurationBuilder subBuilder2 = this.builder.getNamedBuilder(BUILDER_NAME);
        Assertions.assertNotSame((Object)subBuilder, (Object)subBuilder2);
    }

    @Test
    public void testRootNodeInitializedAfterCreation() throws ConfigurationException {
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(TEST_FILE)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertNotNull((Object)cc.getNodeModel().getNodeHandler().getRootNode());
    }

    @Test
    public void testSuppressChildBuilderPropertyInheritance() throws ConfigurationException {
        Parameters params = new Parameters();
        CombinedBuilderParameters combinedParams = (CombinedBuilderParameters)params.combined().setInheritSettings(false);
        this.builder.configure(new BuilderParameters[]{combinedParams, TestCombinedConfigurationBuilder.prepareParamsForInheritanceTest(params)});
        CombinedConfiguration config = (CombinedConfiguration)this.builder.getConfiguration();
        XMLConfiguration xmlConfig = (XMLConfiguration)config.getConfiguration("xml");
        List list = xmlConfig.getList(String.class, "split.list1");
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testSystemProperties() throws ConfigurationException {
        File systemFile = ConfigurationAssert.getTestFile("testCCSystemProperties.xml");
        this.builder.configure(new BuilderParameters[]{(BuilderParameters)this.createParameters().setFile(systemFile)});
        CombinedConfiguration cc = (CombinedConfiguration)this.builder.getConfiguration();
        Assertions.assertTrue((boolean)cc.containsKey("user.name"));
        Assertions.assertEquals((Object)"value1", (Object)System.getProperty("key1"));
    }

    private static final class ConstantConfigurationBuilder
    extends BasicConfigurationBuilder<BaseHierarchicalConfiguration> {
        private final BaseHierarchicalConfiguration configuration;

        public ConstantConfigurationBuilder(BaseHierarchicalConfiguration conf) {
            super(BaseHierarchicalConfiguration.class);
            this.configuration = conf;
        }

        public BaseHierarchicalConfiguration getConfiguration() throws ConfigurationException {
            return this.configuration;
        }
    }

    public static class FileSystemTestImpl
    extends DefaultFileSystem {
    }

    private static final class ReadThread
    extends Thread {
        private final CombinedConfiguration config;
        private final CountDownLatch startLatch;
        private Boolean value;

        public ReadThread(CombinedConfiguration cc, CountDownLatch latch) {
            this.config = cc;
            this.startLatch = latch;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.value = this.config.getBoolean("configuration.loaded");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void verify() {
            try {
                this.join();
            }
            catch (InterruptedException iex) {
                Assertions.fail((String)("Waiting was interrupted: " + iex));
            }
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.value);
        }
    }

    public static class EntityResolverWithPropertiesTestImpl
    extends CatalogResolver {
        private String baseDirectory;
        private FileSystem fileSystem;
        private ConfigurationInterpolator interpolator;

        public String getBaseDir() {
            return this.baseDirectory;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public ConfigurationInterpolator getInterpolator() {
            return this.interpolator;
        }

        public void setBaseDir(String baseDir) {
            super.setBaseDir(baseDir);
            this.baseDirectory = baseDir;
        }

        public void setFileSystem(FileSystem fileSystem) {
            super.setFileSystem(fileSystem);
            this.fileSystem = fileSystem;
        }

        public void setInterpolator(ConfigurationInterpolator interpolator) {
            super.setInterpolator(interpolator);
            this.interpolator = interpolator;
        }
    }

    public static class CombinedConfigurationTestImpl
    extends CombinedConfiguration {
    }

    public static class TestLookup
    implements Lookup {
        private final Map<String, String> map = new HashMap<String, String>();

        public TestLookup() {
            this.map.put("test_file_xml", TestCombinedConfigurationBuilder.TEST_SUB_XML);
            this.map.put("test_file_combine", "testcombine1.xml");
            this.map.put("test_key", "test.value");
        }

        public String lookup(String key) {
            return this.map.get(key);
        }
    }

    public static class BuilderProviderTestImpl
    implements ConfigurationBuilderProvider {
        private String propertyKey;

        public ConfigurationBuilder<? extends Configuration> getConfigurationBuilder(ConfigurationDeclaration decl) throws ConfigurationException {
            BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
            config.addProperty(this.getPropertyKey(), (Object)Boolean.TRUE);
            return new ConstantConfigurationBuilder(config);
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public void setPropertyKey(String propertyKey) {
            this.propertyKey = propertyKey;
        }
    }
}

