/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.interpol;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import org.apache.commons.configuration2.interpol.Lookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestInterpolatorSpecification {
    private static final String PREFIX1 = "p1";
    private static final String PREFIX2 = "p2";
    private InterpolatorSpecification.Builder builder;

    private static void checkDefaultLookups(InterpolatorSpecification spec, Lookup defLook1, Lookup defLook2) {
        Assertions.assertEquals((int)2, (int)spec.getDefaultLookups().size());
        Assertions.assertTrue((boolean)spec.getDefaultLookups().containsAll(Arrays.asList(defLook1, defLook2)));
    }

    private static void checkPrefixLookups(InterpolatorSpecification spec, Lookup prefLook1, Lookup prefLook2) {
        Assertions.assertEquals((int)2, (int)spec.getPrefixLookups().size());
        Assertions.assertSame((Object)prefLook1, spec.getPrefixLookups().get(PREFIX1));
        Assertions.assertSame((Object)prefLook2, spec.getPrefixLookups().get(PREFIX2));
    }

    private static Lookup createLookup() {
        return (Lookup)Mockito.mock(Lookup.class);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.builder = new InterpolatorSpecification.Builder();
    }

    @Test
    public void testBuilderReuse() {
        this.builder.withDefaultLookup(TestInterpolatorSpecification.createLookup()).withInterpolator((ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class)).withPrefixLookup("test", TestInterpolatorSpecification.createLookup()).withParentInterpolator((ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class)).withStringConverter(obj -> "test").create();
        Lookup prefLook1 = TestInterpolatorSpecification.createLookup();
        Lookup prefLook2 = TestInterpolatorSpecification.createLookup();
        Lookup defLook1 = TestInterpolatorSpecification.createLookup();
        Lookup defLook2 = TestInterpolatorSpecification.createLookup();
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        Function<Object, String> stringConverter = Objects::toString;
        InterpolatorSpecification spec = this.builder.withPrefixLookup(PREFIX1, prefLook1).withPrefixLookup(PREFIX2, prefLook2).withDefaultLookups(Arrays.asList(defLook1, defLook2)).withParentInterpolator(parent).withStringConverter(stringConverter).create();
        Assertions.assertNull((Object)spec.getInterpolator());
        Assertions.assertSame((Object)parent, (Object)spec.getParentInterpolator());
        Assertions.assertSame(stringConverter, (Object)spec.getStringConverter());
        TestInterpolatorSpecification.checkPrefixLookups(spec, prefLook1, prefLook2);
        TestInterpolatorSpecification.checkDefaultLookups(spec, defLook1, defLook2);
    }

    @Test
    public void testCreateInstance() {
        Lookup prefLook1 = TestInterpolatorSpecification.createLookup();
        Lookup prefLook2 = TestInterpolatorSpecification.createLookup();
        Lookup defLook1 = TestInterpolatorSpecification.createLookup();
        Lookup defLook2 = TestInterpolatorSpecification.createLookup();
        ConfigurationInterpolator interpolator = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        Function<Object, String> stringConverter = Objects::toString;
        InterpolatorSpecification spec = this.builder.withPrefixLookup(PREFIX1, prefLook1).withDefaultLookup(defLook1).withPrefixLookup(PREFIX2, prefLook2).withParentInterpolator(parent).withDefaultLookup(defLook2).withInterpolator(interpolator).withStringConverter(stringConverter).create();
        Assertions.assertSame((Object)interpolator, (Object)spec.getInterpolator());
        Assertions.assertSame((Object)parent, (Object)spec.getParentInterpolator());
        Assertions.assertSame(stringConverter, (Object)spec.getStringConverter());
        TestInterpolatorSpecification.checkPrefixLookups(spec, prefLook1, prefLook2);
        TestInterpolatorSpecification.checkDefaultLookups(spec, defLook1, defLook2);
    }

    @Test
    public void testCreateInstanceCollections() {
        Lookup prefLook1 = TestInterpolatorSpecification.createLookup();
        Lookup prefLook2 = TestInterpolatorSpecification.createLookup();
        Lookup defLook1 = TestInterpolatorSpecification.createLookup();
        Lookup defLook2 = TestInterpolatorSpecification.createLookup();
        HashMap<String, Lookup> prefixLookups = new HashMap<String, Lookup>();
        prefixLookups.put(PREFIX1, prefLook1);
        prefixLookups.put(PREFIX2, prefLook2);
        InterpolatorSpecification spec = this.builder.withPrefixLookups(prefixLookups).withDefaultLookups(Arrays.asList(defLook1, defLook2)).create();
        TestInterpolatorSpecification.checkPrefixLookups(spec, prefLook1, prefLook2);
        TestInterpolatorSpecification.checkDefaultLookups(spec, defLook1, defLook2);
    }

    @Test
    public void testGetDefaultLookupsModify() {
        InterpolatorSpecification spec = this.builder.withDefaultLookup(TestInterpolatorSpecification.createLookup()).create();
        Collection lookups = spec.getDefaultLookups();
        Lookup lookup = TestInterpolatorSpecification.createLookup();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> lookups.add(lookup));
    }

    @Test
    public void testGetPrefixLookupsModify() {
        InterpolatorSpecification spec = this.builder.withPrefixLookup(PREFIX1, TestInterpolatorSpecification.createLookup()).create();
        Lookup lookup = TestInterpolatorSpecification.createLookup();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> spec.getPrefixLookups().put(PREFIX1, lookup));
    }

    @Test
    public void testWithDefaultLookupNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.builder.withDefaultLookup(null));
    }

    @Test
    public void testWithDefaultLookupsNull() {
        InterpolatorSpecification spec = this.builder.withDefaultLookups(null).create();
        Assertions.assertTrue((boolean)spec.getDefaultLookups().isEmpty());
    }

    @Test
    public void testWithPrefixLookupNoLookup() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.builder.withPrefixLookup(PREFIX1, null));
    }

    @Test
    public void testWithPrefixLookupNoPrefix() {
        Lookup lookup = TestInterpolatorSpecification.createLookup();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.builder.withPrefixLookup(null, lookup));
    }

    @Test
    public void testWithPrefixLookupsNull() {
        InterpolatorSpecification spec = this.builder.withPrefixLookups(null).create();
        Assertions.assertTrue((boolean)spec.getPrefixLookups().isEmpty());
    }
}

