/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.StringEncoderComparator;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringEncoderComparatorTest {
    StringEncoderComparatorTest() {
    }

    @Test
    void testComparatorWithDoubleMetaphone() throws Exception {
        StringEncoderComparator sCompare = new StringEncoderComparator((StringEncoder)new DoubleMetaphone());
        String[] testArray = new String[]{"Jordan", "Sosa", "Prior", "Pryor"};
        List<String> testList = Arrays.asList(testArray);
        String[] controlArray = new String[]{"Jordan", "Prior", "Pryor", "Sosa"};
        testList.sort((Comparator<String>)sCompare);
        String[] resultArray = testList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        for (int i = 0; i < resultArray.length; ++i) {
            Assertions.assertEquals((Object)controlArray[i], (Object)resultArray[i], (String)("Result Array not Equal to Control Array at index: " + i));
        }
    }

    @Test
    void testComparatorWithDoubleMetaphoneAndInvalidInput() throws Exception {
        StringEncoderComparator sCompare = new StringEncoderComparator((StringEncoder)new DoubleMetaphone());
        int compare = sCompare.compare((Object)3.0, (Object)3L);
        Assertions.assertEquals((int)0, (int)compare, (String)"Trying to compare objects that make no sense to the underlying encoder should return a zero compare code");
    }

    @Test
    void testComparatorWithSoundex() throws Exception {
        StringEncoderComparator sCompare = new StringEncoderComparator((StringEncoder)new Soundex());
        Assertions.assertEquals((int)0, (int)sCompare.compare((Object)"O'Brien", (Object)"O'Brian"), (String)"O'Brien and O'Brian didn't come out with the same Soundex, something must be wrong here");
    }
}

