package org.apache.cayenne.testdo.inheritance_flat.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.inheritance_flat.Group;
import org.apache.cayenne.testdo.inheritance_flat.Role;

/**
 * Class _Role was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Role extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<Role> SELF = PropertyFactory.createSelf(Role.class);

    public static final String ID_PK_COLUMN = "id";

    public static final NumericProperty<Long> ID = PropertyFactory.createNumeric("id", Long.class);
    public static final StringProperty<String> NAME = PropertyFactory.createString("name", String.class);
    public static final NumericProperty<Integer> TYPE = PropertyFactory.createNumeric("type", Integer.class);
    public static final ListProperty<Group> ROLE_GROUPS = PropertyFactory.createList("roleGroups", Group.class);

    protected long id;
    protected String name;
    protected int type;

    protected Object roleGroups;

    public void setId(long id) {
        beforePropertyWrite("id", this.id, id);
        this.id = id;
    }

    public long getId() {
        beforePropertyRead("id");
        return this.id;
    }

    public void setName(String name) {
        beforePropertyWrite("name", this.name, name);
        this.name = name;
    }

    public String getName() {
        beforePropertyRead("name");
        return this.name;
    }

    public void setType(int type) {
        beforePropertyWrite("type", this.type, type);
        this.type = type;
    }

    public int getType() {
        beforePropertyRead("type");
        return this.type;
    }

    public void addToRoleGroups(Group obj) {
        addToManyTarget("roleGroups", obj, true);
    }

    public void removeFromRoleGroups(Group obj) {
        removeToManyTarget("roleGroups", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Group> getRoleGroups() {
        return (List<Group>)readProperty("roleGroups");
    }

    protected abstract void onPostPersist();

    protected abstract void onPostUpdate();

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "id":
                return this.id;
            case "name":
                return this.name;
            case "type":
                return this.type;
            case "roleGroups":
                return this.roleGroups;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "id":
                this.id = val == null ? 0 : (long)val;
                break;
            case "name":
                this.name = (String)val;
                break;
            case "type":
                this.type = val == null ? 0 : (int)val;
                break;
            case "roleGroups":
                this.roleGroups = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeLong(this.id);
        out.writeObject(this.name);
        out.writeInt(this.type);
        out.writeObject(this.roleGroups);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.id = in.readLong();
        this.name = (String)in.readObject();
        this.type = in.readInt();
        this.roleGroups = in.readObject();
    }

}
