/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/

package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

abstract class MergerDictionary<T> {

    private Map<String, T> dictionary = new HashMap<>();

    MergerDictionary() {
    }

    void init() {
        for(T entity : getAll()) {
            String name = getName(entity).toUpperCase();
            dictionary.put(name, entity);
        }
    }

    T getByName(String name) {
        return dictionary.get(name);
    }

    void remove(String name) {
        dictionary.remove(name);
    }

    Map<String, T> getDictionary() {
        return dictionary;
    }

    abstract String getName(T entity);
    abstract Collection<T> getAll();
}
