/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.di.Inject;

public class DefaultValueObjectTypeRegistry
implements ValueObjectTypeRegistry {
    final Map<String, ValueObjectType> typeCache = new ConcurrentHashMap<String, ValueObjectType>();

    public DefaultValueObjectTypeRegistry(@Inject List<ValueObjectType<?, ?>> valueObjectTypeList) {
        this.buildTypeCache(valueObjectTypeList);
    }

    private void buildTypeCache(List<ValueObjectType<?, ?>> valueObjectTypeList) {
        for (ValueObjectType<?, ?> valueObjectType : valueObjectTypeList) {
            this.typeCache.put(valueObjectType.getValueType().getName(), valueObjectType);
        }
    }

    @Override
    public <T> ValueObjectType<T, ?> getValueType(Class<? extends T> valueClass) {
        return this.typeCache.get(valueClass.getName());
    }
}

