/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.parser.ASTAdd;
import org.apache.cayenne.exp.parser.ASTDivide;
import org.apache.cayenne.exp.parser.ASTMultiply;
import org.apache.cayenne.exp.parser.ASTNegate;
import org.apache.cayenne.exp.parser.ASTSubtract;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.ComparableProperty;
import org.apache.cayenne.exp.property.PropertyFactory;

public class NumericProperty<E extends Number>
extends BaseProperty<E>
implements ComparableProperty<E> {
    protected NumericProperty(String name, Expression expression, Class<E> type) {
        super(name, expression, type);
    }

    public NumericProperty<E> avg() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.avgExp(this.getExpression()), this.getType());
    }

    public NumericProperty<E> sum() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.sumExp(this.getExpression()), this.getType());
    }

    @Override
    public NumericProperty<E> max() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.maxExp(this.getExpression()), this.getType());
    }

    @Override
    public NumericProperty<E> min() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.minExp(this.getExpression()), this.getType());
    }

    public NumericProperty<E> mod(Number number) {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.modExp(this.getExpression(), number), this.getType());
    }

    public NumericProperty<E> mod(NumericProperty<?> number) {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.modExp(this.getExpression(), number.getExpression()), this.getType());
    }

    public NumericProperty<E> abs() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.absExp(this.getExpression()), this.getType());
    }

    public NumericProperty<E> sqrt() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.sqrtExp(this.getExpression()), this.getType());
    }

    public NumericProperty<E> add(E value) {
        return PropertyFactory.createNumeric(new ASTAdd(this.getExpression(), value), this.getType());
    }

    public NumericProperty<E> add(NumericProperty<?> value) {
        return PropertyFactory.createNumeric(new ASTAdd(this.getExpression(), value.getExpression()), this.getType());
    }

    public NumericProperty<E> sub(E value) {
        return PropertyFactory.createNumeric(new ASTSubtract(this.getExpression(), value), this.getType());
    }

    public NumericProperty<E> sub(NumericProperty<?> value) {
        return PropertyFactory.createNumeric(new ASTSubtract(this.getExpression(), value.getExpression()), this.getType());
    }

    public NumericProperty<E> div(E value) {
        return PropertyFactory.createNumeric(new ASTDivide(this.getExpression(), value), this.getType());
    }

    public NumericProperty<E> div(NumericProperty<?> value) {
        return PropertyFactory.createNumeric(new ASTDivide(this.getExpression(), value.getExpression()), this.getType());
    }

    public NumericProperty<E> mul(E value) {
        return PropertyFactory.createNumeric(new ASTMultiply(this.getExpression(), value), this.getType());
    }

    public NumericProperty<E> mul(NumericProperty<?> value) {
        return PropertyFactory.createNumeric(new ASTMultiply(this.getExpression(), value.getExpression()), this.getType());
    }

    public NumericProperty<E> neg() {
        return PropertyFactory.createNumeric(new ASTNegate(this.getExpression()), this.getType());
    }

    @Override
    public NumericProperty<E> alias(String alias) {
        return PropertyFactory.createNumeric(alias, this.getExpression(), this.getType());
    }

    @Override
    public NumericProperty<E> enclosing() {
        return PropertyFactory.createNumeric(ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getType());
    }
}

