/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import io.vertx.core.Future;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.function.Predicate;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFileSystem {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ExecutorPools executorPools;
    protected final FileSystem fs;
    protected final InstancesMetadata instancesMetadata;
    protected final CassandraInputValidator validator;

    public BaseFileSystem(FileSystem fileSystem, InstancesMetadata instancesMetadata, CassandraInputValidator validator, ExecutorPools executorPools) {
        this.fs = fileSystem;
        this.instancesMetadata = instancesMetadata;
        this.validator = validator;
        this.executorPools = executorPools;
    }

    protected Future<List<String>> dataDirectories(String host) {
        List<String> dataDirs = this.instancesMetadata.instanceFromHost(host).dataDirs();
        if (dataDirs == null || dataDirs.isEmpty()) {
            String errMsg = String.format("No data directories are available for host '%s'", host);
            this.logger.error(errMsg);
            return Future.failedFuture((Throwable)new NoSuchFileException(errMsg));
        }
        return Future.succeededFuture(dataDirs);
    }

    public Future<String> isValidFilename(String filename) {
        return this.isValidOfType(filename, FileProps::isRegularFile);
    }

    public Future<String> isValidDirectory(String path) {
        return this.isValidOfType(path, FileProps::isDirectory);
    }

    public Future<String> ensureDirectoryExists(String path) {
        return this.fs.mkdirs(path).compose(v -> Future.succeededFuture((Object)path));
    }

    protected Future<String> isValidOfType(String filename, Predicate<FileProps> predicate) {
        return this.fs.exists(filename).compose(exists -> {
            if (!exists.booleanValue()) {
                String errMsg = "File '" + filename + "' does not exist";
                return Future.failedFuture((Throwable)new NoSuchFileException(errMsg));
            }
            return this.fs.props(filename).compose(fileProps -> {
                if (fileProps == null || !predicate.test((FileProps)fileProps)) {
                    String errMsg = "File '" + filename + "' does not exist";
                    return Future.failedFuture((Throwable)new NoSuchFileException(errMsg));
                }
                return Future.succeededFuture((Object)filename);
            });
        });
    }
}

