/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.server;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.ext.web.Router;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerVerticle.class);
    protected final SidecarConfiguration sidecarConfiguration;
    protected final Router router;
    private final HttpServerOptions options;
    private List<HttpServer> deployedServers;

    public ServerVerticle(SidecarConfiguration sidecarConfiguration, Router router, HttpServerOptions options) {
        this.sidecarConfiguration = sidecarConfiguration;
        this.router = router;
        this.options = options;
    }

    public void start(Promise<Void> startPromise) {
        ServiceConfiguration serviceConf = this.sidecarConfiguration.serviceConfiguration();
        List<SocketAddress> listenSocketAddresses = serviceConf.listenSocketAddresses();
        LOGGER.info("Deploying Cassandra Sidecar server verticle on socket addresses={}", listenSocketAddresses);
        List futures = listenSocketAddresses.stream().map(socketAddress -> this.vertx.createHttpServer(this.options).requestHandler((Handler)this.router).listen(socketAddress)).collect(Collectors.toList());
        Future.all(futures).onSuccess(startedServerFuture -> {
            this.deployedServers = new ArrayList<HttpServer>(startedServerFuture.list());
            LOGGER.info("Successfully deployed Cassandra Sidecar server verticle on socket addresses={}", (Object)listenSocketAddresses);
            startPromise.complete();
        }).onFailure(cause -> {
            LOGGER.error("Failed to deploy Cassandra Sidecar verticle failed on socket addresses={}", (Object)listenSocketAddresses, cause);
            startPromise.fail(cause);
        });
    }

    Future<CompositeFuture> updateSSLOptions(SSLOptions options) {
        List<HttpServer> deployedServers = this.deployedServers;
        if (deployedServers == null || deployedServers.isEmpty()) {
            return Future.failedFuture((String)"No servers are running");
        }
        return Future.all(deployedServers.stream().map(server -> server.updateSSLOptions(options)).collect(Collectors.toList()));
    }

    void updateTrafficShapingOptions(TrafficShapingOptions options) {
        List<HttpServer> deployedServers = this.deployedServers;
        if (deployedServers == null || deployedServers.isEmpty()) {
            throw new IllegalStateException("No servers are running");
        }
        deployedServers.forEach(server -> {
            try {
                server.updateTrafficShapingOptions(options);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Unable to update traffic shaping options because the server was not configured to use traffic shaping during startup")) {
                    LOGGER.warn("Unable to update traffic shaping options for server={}", server, (Object)ex);
                }
                throw ex;
            }
        });
    }

    @VisibleForTesting
    int actualPort() {
        if (this.deployedServers != null && !this.deployedServers.isEmpty()) {
            return this.deployedServers.get(0).actualPort();
        }
        throw new IllegalStateException("No deployed server. Maybe server failed to deploy due to port conflict");
    }
}

