/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.sidecar.common.utils.HttpRange;
import org.apache.cassandra.sidecar.common.utils.Preconditions;

public class HttpRangesIterator
implements Iterator<HttpRange> {
    private final long totalBytes;
    private final int rangeSize;
    private long offset = 0L;

    public HttpRangesIterator(long totalBytes, int rangeSize) {
        Preconditions.checkArgument((totalBytes > 0L ? 1 : 0) != 0, (String)"totalBytes must be positive");
        Preconditions.checkArgument((rangeSize > 0 ? 1 : 0) != 0, (String)"rangeSize must be positive");
        this.totalBytes = totalBytes;
        this.rangeSize = rangeSize;
    }

    @Override
    public boolean hasNext() {
        return this.offset < this.totalBytes;
    }

    @Override
    public HttpRange next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more HttpRanges");
        }
        long end = Math.min(this.offset + (long)this.rangeSize, this.totalBytes) - 1L;
        HttpRange range = HttpRange.of((long)this.offset, (long)end);
        this.offset = end + 1L;
        return range;
    }
}

