/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.instance;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class InstanceHealthMetrics {
    public static final String DOMAIN = "Sidecar.CassInstance.Health";
    protected final MetricRegistry metricRegistry;
    public final NamedMetric<DefaultSettableGauge<Integer>> jmxDown;
    public final NamedMetric<DefaultSettableGauge<Integer>> nativeDown;

    public InstanceHealthMetrics(MetricRegistry registry) {
        this.metricRegistry = Objects.requireNonNull(registry, "Metric registry can not be null");
        this.jmxDown = NamedMetric.builder(name -> (DefaultSettableGauge)registry.gauge(name, () -> new DefaultSettableGauge((Object)0))).withDomain(DOMAIN).withName("JmxDown").build();
        this.nativeDown = NamedMetric.builder(name -> (DefaultSettableGauge)registry.gauge(name, () -> new DefaultSettableGauge((Object)0))).withDomain(DOMAIN).withName("NativeDown").build();
    }
}

