/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Inject;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.data.OperationalJobStatus;
import org.apache.cassandra.sidecar.common.response.ListOperationalJobsResponse;
import org.apache.cassandra.sidecar.common.response.OperationalJobResponse;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.job.OperationalJobManager;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

public class ListOperationalJobsHandler
extends AbstractHandler<Void>
implements AccessProtected {
    private final OperationalJobManager jobManager;

    @Inject
    public ListOperationalJobsHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator, OperationalJobManager jobManager) {
        super(metadataFetcher, executorPools, validator);
        this.jobManager = jobManager;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.READ_OPERATIONAL_JOB.toAuthorization());
    }

    @Override
    protected Void extractParamsOrThrow(RoutingContext context) {
        return null;
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Void request) {
        ListOperationalJobsResponse listResponse = new ListOperationalJobsResponse();
        this.jobManager.allInflightJobs().stream().map(job -> new OperationalJobResponse(job.jobId(), OperationalJobStatus.RUNNING, job.name(), null)).forEach(arg_0 -> ((ListOperationalJobsResponse)listResponse).addJob(arg_0));
        context.json((Object)listResponse);
    }
}

