/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.coordination.ExecuteOnClusterLeaseholderOnly;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.NotNull;

public class ConfigsSchema
extends TableSchema
implements ExecuteOnClusterLeaseholderOnly {
    private static final String CONFIGS_TABLE_NAME = "configs";
    private final SchemaKeyspaceConfiguration keyspaceConfig;
    private PreparedStatement selectConfig;
    private PreparedStatement insertConfig;
    private PreparedStatement insertConfigIfNotExist;
    private PreparedStatement deleteConfig;

    public ConfigsSchema(ServiceConfiguration configuration) {
        this.keyspaceConfig = configuration.schemaKeyspaceConfiguration();
    }

    protected String keyspaceName() {
        return this.keyspaceConfig.keyspace();
    }

    protected void prepareStatements(@NotNull Session session) {
        this.selectConfig = this.prepare(this.selectConfig, session, CqlLiterals.selectConfig(this.keyspaceConfig));
        this.insertConfig = this.prepare(this.insertConfig, session, CqlLiterals.insertConfig(this.keyspaceConfig));
        this.insertConfigIfNotExist = this.prepare(this.insertConfigIfNotExist, session, CqlLiterals.insertConfigIfNotExist(this.keyspaceConfig));
        this.deleteConfig = this.prepare(this.deleteConfig, session, CqlLiterals.deleteConfig(this.keyspaceConfig));
    }

    protected String tableName() {
        return CONFIGS_TABLE_NAME;
    }

    protected boolean exists(@NotNull Metadata metadata) {
        KeyspaceMetadata ksMetadata = metadata.getKeyspace(this.keyspaceConfig.keyspace());
        if (ksMetadata == null) {
            return false;
        }
        return ksMetadata.getTable(CONFIGS_TABLE_NAME) != null;
    }

    protected String createSchemaStatement() {
        return String.format("CREATE TABLE IF NOT EXISTS %s.%s ( service text, config map<text, text>, PRIMARY KEY (service))", this.keyspaceConfig.keyspace(), CONFIGS_TABLE_NAME);
    }

    public PreparedStatement selectConfig() {
        return this.selectConfig;
    }

    public PreparedStatement insertConfig() {
        return this.insertConfig;
    }

    public PreparedStatement insertConfigIfNotExists() {
        return this.insertConfigIfNotExist;
    }

    public PreparedStatement deleteConfig() {
        return this.deleteConfig;
    }

    private static class CqlLiterals {
        private CqlLiterals() {
        }

        static String selectConfig(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("SELECT config from %s.%s WHERE service=?", config);
        }

        static String insertConfig(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("INSERT INTO %s.%s (service, config) VALUES (?, ?)", config);
        }

        static String insertConfigIfNotExist(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.insertConfig(config) + " IF NOT EXISTS";
        }

        static String deleteConfig(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("DELETE FROM %s.%s WHERE service=?", config);
        }

        private static String withTable(String format, SchemaKeyspaceConfiguration config) {
            return String.format(format, config.keyspace(), ConfigsSchema.CONFIGS_TABLE_NAME);
        }
    }
}

