/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.RestoreJobConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreJobConfigurationImpl
implements RestoreJobConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreJobConfigurationImpl.class);
    private static final SecondBoundConfiguration MIN_RESTORE_JOB_TABLES_TTL = SecondBoundConfiguration.parse((String)"14d");
    private static final MillisecondBoundConfiguration DEFAULT_JOB_DISCOVERY_ACTIVE_LOOP_DELAY = MillisecondBoundConfiguration.parse((String)"5m");
    private static final MillisecondBoundConfiguration DEFAULT_JOB_DISCOVERY_IDLE_LOOP_DELAY = MillisecondBoundConfiguration.parse((String)"10m");
    private static final int DEFAULT_JOB_DISCOVERY_MINIMUM_RECENCY_DAYS = 5;
    private static final int DEFAULT_PROCESS_MAX_CONCURRENCY = 20;
    private static final SecondBoundConfiguration DEFAULT_RESTORE_JOB_TABLES_TTL = SecondBoundConfiguration.parse((String)"90d");
    private static final SecondBoundConfiguration DEFAULT_RESTORE_JOB_SLOW_TASK_THRESHOLD = SecondBoundConfiguration.parse((String)"10m");
    private static final SecondBoundConfiguration DEFAULT_RESTORE_JOB_SLOW_TASK_REPORT_DELAY = SecondBoundConfiguration.parse((String)"1m");
    public static final MillisecondBoundConfiguration DEFAULT_RING_TOPOLOGY_REFRESH_DELAY = MillisecondBoundConfiguration.parse((String)"1m");
    protected MillisecondBoundConfiguration jobDiscoveryActiveLoopDelay;
    protected MillisecondBoundConfiguration jobDiscoveryIdleLoopDelay;
    @JsonProperty(value="job_discovery_minimum_recency_days")
    protected final int jobDiscoveryMinimumRecencyDays;
    @JsonProperty(value="slice_process_max_concurrency")
    protected final int processMaxConcurrency;
    protected SecondBoundConfiguration restoreJobTablesTtl;
    protected SecondBoundConfiguration slowTaskThreshold;
    protected SecondBoundConfiguration slowTaskReportDelay;
    private MillisecondBoundConfiguration ringTopologyRefreshDelay;

    protected RestoreJobConfigurationImpl() {
        this(RestoreJobConfigurationImpl.builder());
    }

    protected RestoreJobConfigurationImpl(Builder builder) {
        this.jobDiscoveryActiveLoopDelay = builder.jobDiscoveryActiveLoopDelay;
        this.jobDiscoveryIdleLoopDelay = builder.jobDiscoveryIdleLoopDelay;
        this.jobDiscoveryMinimumRecencyDays = builder.jobDiscoveryMinimumRecencyDays;
        this.processMaxConcurrency = builder.processMaxConcurrency;
        this.restoreJobTablesTtl = builder.restoreJobTablesTtl;
        this.slowTaskThreshold = builder.slowTaskThreshold;
        this.slowTaskReportDelay = builder.slowTaskReportDelay;
        this.ringTopologyRefreshDelay = builder.ringTopologyRefreshDelay;
        this.validate();
    }

    private void validate() {
        if (this.restoreJobTablesTtl.compareTo((DurationSpec)MIN_RESTORE_JOB_TABLES_TTL) < 0) {
            throw new IllegalArgumentException("restoreJobTablesTtl cannot be less than " + MIN_RESTORE_JOB_TABLES_TTL);
        }
        long ttl = this.restoreJobTablesTtl().toSeconds();
        if (TimeUnit.DAYS.toSeconds(this.jobDiscoveryMinimumRecencyDays()) >= ttl) {
            throw new IllegalArgumentException("JobDiscoveryMinimumRecencyDays (in seconds) cannot be greater than " + ttl);
        }
    }

    @Override
    @JsonProperty(value="job_discovery_active_loop_delay")
    public MillisecondBoundConfiguration jobDiscoveryActiveLoopDelay() {
        return this.jobDiscoveryActiveLoopDelay;
    }

    @JsonProperty(value="job_discovery_active_loop_delay")
    public void setJobDiscoveryActiveLoopDelay(MillisecondBoundConfiguration jobDiscoveryActiveLoopDelay) {
        this.jobDiscoveryActiveLoopDelay = jobDiscoveryActiveLoopDelay;
    }

    @JsonProperty(value="job_discovery_active_loop_delay_millis")
    @Deprecated
    public void setJobDiscoveryActiveLoopDelayMillis(long jobDiscoveryActiveLoopDelayMillis) {
        LOGGER.warn("'job_discovery_active_loop_delay_millis' is deprecated, use 'job_discovery_active_loop_delay' instead");
        this.setJobDiscoveryActiveLoopDelay(new MillisecondBoundConfiguration(jobDiscoveryActiveLoopDelayMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="job_discovery_idle_loop_delay")
    public MillisecondBoundConfiguration jobDiscoveryIdleLoopDelay() {
        return this.jobDiscoveryIdleLoopDelay;
    }

    @JsonProperty(value="job_discovery_idle_loop_delay")
    public void setJobDiscoveryIdleLoopDelay(MillisecondBoundConfiguration jobDiscoveryIdleLoopDelay) {
        this.jobDiscoveryIdleLoopDelay = jobDiscoveryIdleLoopDelay;
    }

    @JsonProperty(value="job_discovery_idle_loop_delay_millis")
    @Deprecated
    public void setJobDiscoveryIdleLoopDelayMillis(long jobDiscoveryIdleLoopDelayMillis) {
        LOGGER.warn("'job_discovery_idle_loop_delay_millis' is deprecated, use 'job_discovery_idle_loop_delay' instead");
        this.setJobDiscoveryIdleLoopDelay(new MillisecondBoundConfiguration(jobDiscoveryIdleLoopDelayMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="job_discovery_minimum_recency_days")
    public int jobDiscoveryMinimumRecencyDays() {
        return this.jobDiscoveryMinimumRecencyDays;
    }

    @Override
    @JsonProperty(value="slice_process_max_concurrency")
    public int processMaxConcurrency() {
        return this.processMaxConcurrency;
    }

    @Override
    @JsonProperty(value="restore_job_tables_ttl")
    public SecondBoundConfiguration restoreJobTablesTtl() {
        return this.restoreJobTablesTtl;
    }

    @JsonProperty(value="restore_job_tables_ttl")
    public void setRestoreJobTablesTtl(SecondBoundConfiguration restoreJobTablesTtl) {
        this.restoreJobTablesTtl = restoreJobTablesTtl;
    }

    @JsonProperty(value="restore_job_tables_ttl_seconds")
    @Deprecated
    public void setRestoreJobTablesTtlSeconds(long restoreJobTablesTtlSeconds) {
        LOGGER.warn("'restore_job_tables_ttl_seconds' is deprecated, use 'restore_job_tables_ttl' instead");
        this.setRestoreJobTablesTtl(new SecondBoundConfiguration(restoreJobTablesTtlSeconds, TimeUnit.SECONDS));
    }

    @Override
    @JsonProperty(value="slow_task_threshold")
    public SecondBoundConfiguration slowTaskThreshold() {
        return this.slowTaskThreshold;
    }

    @JsonProperty(value="slow_task_threshold")
    public void setSlowTaskThreshold(SecondBoundConfiguration slowTaskThreshold) {
        this.slowTaskThreshold = slowTaskThreshold;
    }

    @JsonProperty(value="slow_task_threshold_seconds")
    @Deprecated
    public void setSlowTaskThresholdSeconds(long slowTaskThresholdSeconds) {
        LOGGER.warn("'slow_task_threshold_seconds' is deprecated, use 'slow_task_threshold' instead");
        this.setSlowTaskThreshold(new SecondBoundConfiguration(slowTaskThresholdSeconds, TimeUnit.SECONDS));
    }

    @Override
    @JsonProperty(value="slow_task_report_delay")
    public SecondBoundConfiguration slowTaskReportDelay() {
        return this.slowTaskReportDelay;
    }

    @JsonProperty(value="slow_task_report_delay")
    public void setSlowTaskReportDelay(SecondBoundConfiguration slowTaskReportDelay) {
        this.slowTaskReportDelay = slowTaskReportDelay;
    }

    @JsonProperty(value="slow_task_report_delay_seconds")
    @Deprecated
    public void setSlowTaskReportDelaySeconds(long slowTaskReportDelaySeconds) {
        LOGGER.warn("'slow_task_report_delay_seconds' is deprecated, use 'slow_task_report_delay' instead");
        this.setSlowTaskReportDelay(new SecondBoundConfiguration(slowTaskReportDelaySeconds, TimeUnit.SECONDS));
    }

    @Override
    @JsonProperty(value="ring_topology_refresh_delay")
    public MillisecondBoundConfiguration ringTopologyRefreshDelay() {
        return this.ringTopologyRefreshDelay;
    }

    @JsonProperty(value="ring_topology_refresh_delay")
    public void setRingTopologyRefreshDelay(MillisecondBoundConfiguration ringTopologyRefreshDelay) {
        this.ringTopologyRefreshDelay = ringTopologyRefreshDelay;
    }

    @JsonProperty(value="ring_topology_refresh_delay_millis")
    @Deprecated
    public void setRingTopologyRefreshDelayMillis(long ringTopologyRefreshDelayMillis) {
        LOGGER.warn("'ring_topology_refresh_delay_millis' is deprecated, use 'ring_topology_refresh_delay' instead");
        this.setRingTopologyRefreshDelay(new MillisecondBoundConfiguration(ringTopologyRefreshDelayMillis, TimeUnit.MILLISECONDS));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements DataObjectBuilder<Builder, RestoreJobConfigurationImpl> {
        private SecondBoundConfiguration slowTaskThreshold = DEFAULT_RESTORE_JOB_SLOW_TASK_THRESHOLD;
        private SecondBoundConfiguration slowTaskReportDelay = DEFAULT_RESTORE_JOB_SLOW_TASK_REPORT_DELAY;
        private MillisecondBoundConfiguration jobDiscoveryActiveLoopDelay = DEFAULT_JOB_DISCOVERY_ACTIVE_LOOP_DELAY;
        private MillisecondBoundConfiguration jobDiscoveryIdleLoopDelay = DEFAULT_JOB_DISCOVERY_IDLE_LOOP_DELAY;
        private int jobDiscoveryMinimumRecencyDays = 5;
        private int processMaxConcurrency = 20;
        private SecondBoundConfiguration restoreJobTablesTtl = DEFAULT_RESTORE_JOB_TABLES_TTL;
        private MillisecondBoundConfiguration ringTopologyRefreshDelay = DEFAULT_RING_TOPOLOGY_REFRESH_DELAY;

        protected Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder jobDiscoveryActiveLoopDelay(MillisecondBoundConfiguration jobDiscoveryActiveLoopDelay) {
            return (Builder)this.update(b -> {
                b.jobDiscoveryActiveLoopDelay = jobDiscoveryActiveLoopDelay;
            });
        }

        public Builder jobDiscoveryIdleLoopDelay(MillisecondBoundConfiguration jobDiscoveryIdleLoopDelay) {
            return (Builder)this.update(b -> {
                b.jobDiscoveryIdleLoopDelay = jobDiscoveryIdleLoopDelay;
            });
        }

        public Builder jobDiscoveryMinimumRecencyDays(int jobDiscoveryMinimumRecencyDays) {
            return (Builder)this.update(b -> {
                b.jobDiscoveryMinimumRecencyDays = jobDiscoveryMinimumRecencyDays;
            });
        }

        public Builder processMaxConcurrency(int processMaxConcurrency) {
            return (Builder)this.update(b -> {
                b.processMaxConcurrency = processMaxConcurrency;
            });
        }

        public Builder restoreJobTablesTtl(SecondBoundConfiguration restoreJobTablesTtl) {
            return (Builder)this.update(b -> {
                b.restoreJobTablesTtl = restoreJobTablesTtl;
            });
        }

        public Builder slowTaskThreshold(SecondBoundConfiguration slowTaskThreshold) {
            return (Builder)this.update(b -> {
                b.slowTaskThreshold = slowTaskThreshold;
            });
        }

        public Builder slowTaskReportDelay(SecondBoundConfiguration slowTaskReportDelay) {
            return (Builder)this.update(b -> {
                b.slowTaskReportDelay = slowTaskReportDelay;
            });
        }

        public Builder ringTopologyRefreshDelay(MillisecondBoundConfiguration ringTopologyRefreshDelay) {
            return (Builder)this.update(b -> {
                b.ringTopologyRefreshDelay = ringTopologyRefreshDelay;
            });
        }

        public RestoreJobConfigurationImpl build() {
            return new RestoreJobConfigurationImpl(this);
        }
    }
}

