/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.internal;

import java.time.Duration;
import java.util.function.Predicate;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.LegacyRetryStrategy;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.RefreshRetryTokenRequest;
import software.amazon.awssdk.retries.internal.BaseRetryStrategy;
import software.amazon.awssdk.retries.internal.DefaultRetryToken;
import software.amazon.awssdk.retries.internal.circuitbreaker.TokenBucketStore;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultLegacyRetryStrategy
extends BaseRetryStrategy
implements LegacyRetryStrategy {
    private static final Logger LOG = Logger.loggerFor(LegacyRetryStrategy.class);
    private final BackoffStrategy throttlingBackoffStrategy;
    private final int throttlingExceptionCost;
    private final Predicate<Throwable> treatAsThrottling;

    DefaultLegacyRetryStrategy(Builder builder) {
        super(LOG, builder);
        this.throttlingExceptionCost = (Integer)Validate.paramNotNull((Object)builder.throttlingExceptionCost, (String)"throttlingExceptionCost");
        this.throttlingBackoffStrategy = (BackoffStrategy)Validate.paramNotNull((Object)builder.throttlingBackoffStrategy, (String)"throttlingBackoffStrategy");
        this.treatAsThrottling = (Predicate)Validate.paramNotNull((Object)builder.treatAsThrottling, (String)"treatAsThrottling");
    }

    @Override
    protected Duration computeBackoff(RefreshRetryTokenRequest request, DefaultRetryToken token) {
        Duration backoff = this.treatAsThrottling.test(request.failure()) ? this.throttlingBackoffStrategy.computeDelay(token.attempt()) : this.backoffStrategy.computeDelay(token.attempt());
        Duration suggested = request.suggestedDelay().orElse(Duration.ZERO);
        return DefaultLegacyRetryStrategy.maxOf(suggested, backoff);
    }

    @Override
    protected int exceptionCost(RefreshRetryTokenRequest request) {
        if (this.circuitBreakerEnabled) {
            if (this.treatAsThrottling.test(request.failure())) {
                return this.throttlingExceptionCost;
            }
            return this.exceptionCost;
        }
        return 0;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseRetryStrategy.Builder
    implements LegacyRetryStrategy.Builder {
        private BackoffStrategy throttlingBackoffStrategy;
        private Integer throttlingExceptionCost;
        private Predicate<Throwable> treatAsThrottling;

        Builder() {
        }

        Builder(DefaultLegacyRetryStrategy strategy) {
            super(strategy);
            this.throttlingBackoffStrategy = strategy.throttlingBackoffStrategy;
            this.treatAsThrottling = strategy.treatAsThrottling;
            this.throttlingExceptionCost = strategy.throttlingExceptionCost;
        }

        public Builder retryOnException(Predicate<Throwable> shouldRetry) {
            this.setRetryOnException(shouldRetry);
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.setMaxAttempts(maxAttempts);
            return this;
        }

        public Builder backoffStrategy(BackoffStrategy backoffStrategy) {
            this.setBackoffStrategy(backoffStrategy);
            return this;
        }

        @Override
        public Builder throttlingBackoffStrategy(BackoffStrategy throttlingBackoffStrategy) {
            this.throttlingBackoffStrategy = throttlingBackoffStrategy;
            return this;
        }

        @Override
        public Builder circuitBreakerEnabled(Boolean circuitBreakerEnabled) {
            this.setCircuitBreakerEnabled(circuitBreakerEnabled);
            return this;
        }

        @Override
        public Builder treatAsThrottling(Predicate<Throwable> treatAsThrottling) {
            this.treatAsThrottling = treatAsThrottling;
            return this;
        }

        public Builder tokenBucketExceptionCost(int exceptionCost) {
            this.setTokenBucketExceptionCost(exceptionCost);
            return this;
        }

        public Builder tokenBucketThrottlingExceptionCost(int throttlingExceptionCost) {
            this.throttlingExceptionCost = throttlingExceptionCost;
            return this;
        }

        public Builder tokenBucketStore(TokenBucketStore tokenBucketStore) {
            this.setTokenBucketStore(tokenBucketStore);
            return this;
        }

        @Override
        public LegacyRetryStrategy build() {
            return new DefaultLegacyRetryStrategy(this);
        }
    }
}

