/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.bytecomparable;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public interface ByteComparable {
    public static final ByteComparable EMPTY = version -> ByteSource.EMPTY;

    public ByteSource asComparableBytes(Version var1);

    default public String byteComparableAsString(Version version) {
        StringBuilder builder = new StringBuilder();
        ByteSource stream = this.asComparableBytes(version);
        if (stream == null) {
            return "null";
        }
        int b = stream.next();
        while (b != -1) {
            builder.append(Integer.toHexString(b >> 4 & 0xF)).append(Integer.toHexString(b & 0xF));
            b = stream.next();
        }
        return builder.toString();
    }

    public static ByteComparable of(String s) {
        return v -> ByteSource.of(s, v);
    }

    public static ByteComparable of(long value) {
        return v -> ByteSource.of(value);
    }

    public static ByteComparable of(int value) {
        return v -> ByteSource.of(value);
    }

    public static ByteComparable fixedLength(ByteBuffer bytes) {
        return v -> ByteSource.fixedLength(bytes);
    }

    public static ByteComparable fixedLength(byte[] bytes) {
        return v -> ByteSource.fixedLength(bytes);
    }

    public static ByteComparable fixedLength(byte[] bytes, int offset, int len) {
        return v -> ByteSource.fixedLength(bytes, offset, len);
    }

    public static ByteComparable separatorPrefix(ByteComparable prevMax, ByteComparable currMin) {
        return version -> ByteSource.separatorPrefix(prevMax.asComparableBytes(version), currMin.asComparableBytes(version));
    }

    public static ByteComparable separatorGt(ByteComparable prevMax, ByteComparable currMin) {
        return version -> ByteSource.separatorGt(prevMax.asComparableBytes(version), currMin.asComparableBytes(version));
    }

    public static ByteComparable cut(ByteComparable src, int cutoff) {
        return version -> ByteSource.cut(src.asComparableBytes(version), cutoff);
    }

    public static int length(ByteComparable src, Version version) {
        int l = 0;
        ByteSource s = src.asComparableBytes(version);
        while (s.next() != -1) {
            ++l;
        }
        return l;
    }

    public static int compare(ByteComparable bytes1, ByteComparable bytes2, Version version) {
        int b1;
        ByteSource s1 = bytes1.asComparableBytes(version);
        ByteSource s2 = bytes2.asComparableBytes(version);
        if (s1 == null || s2 == null) {
            return Boolean.compare(s1 != null, s2 != null);
        }
        do {
            int b2;
            int cmp;
            if ((cmp = Integer.compare(b1 = s1.next(), b2 = s2.next())) == 0) continue;
            return cmp;
        } while (b1 != -1);
        return 0;
    }

    public static int diffPoint(ByteComparable bytes1, ByteComparable bytes2, Version version) {
        int b;
        ByteSource s1 = bytes1.asComparableBytes(version);
        ByteSource s2 = bytes2.asComparableBytes(version);
        int pos = 1;
        while ((b = s1.next()) == s2.next() && b != -1) {
            ++pos;
        }
        return pos;
    }

    public static enum Version {
        LEGACY,
        OSS50;

    }
}

