/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.cassandra.cql3.functions.types.CodecRegistry;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.transport.ProtocolVersion;

public final class JavaDriverUtils {
    private static final CodecRegistry codecRegistry = new CodecRegistry();
    private static final MethodHandle methodParseOne;

    public static TypeCodec<Object> codecFor(AbstractType<?> abstractType) {
        return JavaDriverUtils.codecFor(JavaDriverUtils.driverType(abstractType));
    }

    public static TypeCodec<Object> codecFor(DataType dataType) {
        return codecRegistry.codecFor(dataType);
    }

    public static DataType driverType(AbstractType<?> abstractType) {
        try {
            return methodParseOne.invoke(abstractType.toString(), ProtocolVersion.CURRENT, codecRegistry);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("cannot parse driver type " + abstractType, e);
        }
    }

    private JavaDriverUtils() {
    }

    static {
        try {
            Class<?> cls = Class.forName("org.apache.cassandra.cql3.functions.types.DataTypeClassNameParser");
            Method m = cls.getDeclaredMethod("parseOne", String.class, ProtocolVersion.class, CodecRegistry.class);
            m.setAccessible(true);
            methodParseOne = MethodHandles.lookup().unreflect(m);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

