/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.index.sai.disk.io.BufferedChecksumIndexInput;
import org.apache.cassandra.index.sai.disk.io.IndexInputReader;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;

public class IndexFileUtils {
    @VisibleForTesting
    public static final SequentialWriterOption DEFAULT_WRITER_OPTION = SequentialWriterOption.newBuilder().trickleFsync(DatabaseDescriptor.getTrickleFsync()).trickleFsyncByteInterval(DatabaseDescriptor.getTrickleFsyncIntervalInKiB() * 1024).bufferType(BufferType.OFF_HEAP).finishOnClose(true).build();
    public static final IndexFileUtils instance = new IndexFileUtils(DEFAULT_WRITER_OPTION);
    private static final Supplier<Checksum> CHECKSUM_FACTORY = CRC32C::new;
    private final SequentialWriterOption writerOption;

    @VisibleForTesting
    protected IndexFileUtils(SequentialWriterOption writerOption) {
        this.writerOption = writerOption;
    }

    public IndexOutputWriter openOutput(File file) {
        assert (this.writerOption.finishOnClose()) : "IndexOutputWriter relies on close() to sync with disk.";
        return new IndexOutputWriter(new ChecksummingWriter(file, this.writerOption));
    }

    public IndexOutputWriter openOutput(File file, boolean append) throws IOException {
        assert (this.writerOption.finishOnClose()) : "IndexOutputWriter relies on close() to sync with disk.";
        IndexOutputWriter indexOutputWriter = new IndexOutputWriter(new ChecksummingWriter(file, this.writerOption));
        if (append) {
            indexOutputWriter.skipBytes(file.length());
        }
        return indexOutputWriter;
    }

    public IndexInput openInput(FileHandle handle) {
        return IndexInputReader.create(handle);
    }

    public IndexInput openBlockingInput(File file) {
        FileHandle fileHandle = new FileHandle.Builder(file).complete();
        RandomAccessReader randomReader = fileHandle.createReader();
        return IndexInputReader.create(randomReader, fileHandle::close);
    }

    public static ChecksumIndexInput getBufferedChecksumIndexInput(IndexInput indexInput) {
        return new BufferedChecksumIndexInput(indexInput, CHECKSUM_FACTORY.get());
    }

    static class ChecksummingWriter
    extends SequentialWriter {
        private final Checksum checksum = CHECKSUM_FACTORY.get();

        ChecksummingWriter(File file, SequentialWriterOption writerOption) {
            super(file, writerOption);
        }

        public long getChecksum() throws IOException {
            this.flush();
            return this.checksum.getValue();
        }

        @Override
        protected void flushData() {
            ByteBuffer toAppend = this.buffer.duplicate().flip();
            super.flushData();
            this.checksum.update(toAppend);
        }
    }
}

