/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Objects;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Slice;

public class RangeTombstone {
    private final Slice slice;
    private final DeletionTime deletion;

    public RangeTombstone(Slice slice, DeletionTime deletion) {
        this.slice = slice;
        this.deletion = deletion;
    }

    public Slice deletedSlice() {
        return this.slice;
    }

    public DeletionTime deletionTime() {
        return this.deletion;
    }

    public String toString(ClusteringComparator comparator) {
        return this.slice.toString(comparator) + "@" + this.deletion;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RangeTombstone)) {
            return false;
        }
        RangeTombstone that = (RangeTombstone)other;
        return this.deletedSlice().equals(that.deletedSlice()) && this.deletionTime().equals(that.deletionTime());
    }

    public int hashCode() {
        return Objects.hash(this.deletedSlice(), this.deletionTime());
    }
}

