/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.utils.concurrent.Accumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseResolver {
    protected static final Logger logger = LoggerFactory.getLogger(ResponseResolver.class);
    protected final Keyspace keyspace;
    protected final ReadCommand command;
    protected final ConsistencyLevel consistency;
    protected final Accumulator<MessageIn<ReadResponse>> responses;

    public ResponseResolver(Keyspace keyspace, ReadCommand command, ConsistencyLevel consistency, int maxResponseCount) {
        this.keyspace = keyspace;
        this.command = command;
        this.consistency = consistency;
        this.responses = new Accumulator(maxResponseCount);
    }

    public abstract PartitionIterator getData();

    public abstract PartitionIterator resolve() throws DigestMismatchException;

    public abstract void compareResponses() throws DigestMismatchException;

    public abstract boolean isDataPresent();

    public void preprocess(MessageIn<ReadResponse> message) {
        this.responses.add(message);
    }

    public Iterable<MessageIn<ReadResponse>> getMessages() {
        return this.responses;
    }
}

