/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.context.CounterContext;

public abstract class Conflicts {
    private Conflicts() {
    }

    public static Resolution resolveRegular(long leftTimestamp, boolean leftLive, int leftLocalDeletionTime, ByteBuffer leftValue, long rightTimestamp, boolean rightLive, int rightLocalDeletionTime, ByteBuffer rightValue) {
        if (leftTimestamp != rightTimestamp) {
            return leftTimestamp < rightTimestamp ? Resolution.RIGHT_WINS : Resolution.LEFT_WINS;
        }
        if (leftLive != rightLive) {
            return leftLive ? Resolution.RIGHT_WINS : Resolution.LEFT_WINS;
        }
        int c = leftValue.compareTo(rightValue);
        if (c < 0) {
            return Resolution.RIGHT_WINS;
        }
        if (c > 0) {
            return Resolution.LEFT_WINS;
        }
        return leftLocalDeletionTime < rightLocalDeletionTime ? Resolution.RIGHT_WINS : Resolution.LEFT_WINS;
    }

    public static Resolution resolveCounter(long leftTimestamp, boolean leftLive, ByteBuffer leftValue, long rightTimestamp, boolean rightLive, ByteBuffer rightValue) {
        if (!leftLive) {
            return rightLive || leftTimestamp > rightTimestamp ? Resolution.LEFT_WINS : Resolution.RIGHT_WINS;
        }
        if (!rightLive) {
            return Resolution.RIGHT_WINS;
        }
        return Resolution.MERGE;
    }

    public static ByteBuffer mergeCounterValues(ByteBuffer left, ByteBuffer right) {
        return CounterContext.instance().merge(left, right);
    }

    public static enum Resolution {
        LEFT_WINS,
        MERGE,
        RIGHT_WINS;

    }
}

