/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.pipespec.integration.template.spec.EphemeralContainersBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.Env;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.EnvFrom;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.Lifecycle;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.LivenessProbe;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.Ports;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.ReadinessProbe;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.ResizePolicy;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.Resources;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.SecurityContext;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.StartupProbe;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.VolumeDevices;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.VolumeMounts;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"args", "command", "env", "envFrom", "image", "imagePullPolicy", "lifecycle", "livenessProbe", "name", "ports", "readinessProbe", "resizePolicy", "resources", "restartPolicy", "securityContext", "startupProbe", "stdin", "stdinOnce", "targetContainerName", "terminationMessagePath", "terminationMessagePolicy", "tty", "volumeDevices", "volumeMounts", "workingDir"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class EphemeralContainers
implements Editable<EphemeralContainersBuilder>,
KubernetesResource {
    @JsonProperty(value="args")
    @JsonPropertyDescription(value="Arguments to the entrypoint.\nThe image's CMD is used if this is not provided.\nVariable references $(VAR_NAME) are expanded using the container's environment. If a variable\ncannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced\nto a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will\nproduce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless\nof whether the variable exists or not. Cannot be updated.\nMore info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> args;
    @JsonProperty(value="command")
    @JsonPropertyDescription(value="Entrypoint array. Not executed within a shell.\nThe image's ENTRYPOINT is used if this is not provided.\nVariable references $(VAR_NAME) are expanded using the container's environment. If a variable\ncannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced\nto a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will\nproduce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless\nof whether the variable exists or not. Cannot be updated.\nMore info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> command;
    @JsonProperty(value="env")
    @JsonPropertyDescription(value="List of environment variables to set in the container.\nCannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Env> env;
    @JsonProperty(value="envFrom")
    @JsonPropertyDescription(value="List of sources to populate environment variables in the container.\nThe keys defined within a source must be a C_IDENTIFIER. All invalid keys\nwill be reported as an event when the container is starting. When a key exists in multiple\nsources, the value associated with the last source will take precedence.\nValues defined by an Env with a duplicate key will take precedence.\nCannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<EnvFrom> envFrom;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="Container image name.\nMore info: https://kubernetes.io/docs/concepts/containers/images")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="imagePullPolicy")
    @JsonPropertyDescription(value="Image pull policy.\nOne of Always, Never, IfNotPresent.\nDefaults to Always if :latest tag is specified, or IfNotPresent otherwise.\nCannot be updated.\nMore info: https://kubernetes.io/docs/concepts/containers/images#updating-images")
    @JsonSetter(nulls=Nulls.SKIP)
    private String imagePullPolicy;
    @JsonProperty(value="lifecycle")
    @JsonPropertyDescription(value="Lifecycle is not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Lifecycle lifecycle;
    @JsonProperty(value="livenessProbe")
    @JsonPropertyDescription(value="Probes are not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private LivenessProbe livenessProbe;
    @JsonProperty(value="name")
    @Required
    @JsonPropertyDescription(value="Name of the ephemeral container specified as a DNS_LABEL.\nThis name must be unique among all containers, init containers and ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="ports")
    @JsonPropertyDescription(value="Ports are not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Ports> ports;
    @JsonProperty(value="readinessProbe")
    @JsonPropertyDescription(value="Probes are not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ReadinessProbe readinessProbe;
    @JsonProperty(value="resizePolicy")
    @JsonPropertyDescription(value="Resources resize policy for the container.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<ResizePolicy> resizePolicy;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources\nalready allocated to the pod.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Resources resources;
    @JsonProperty(value="restartPolicy")
    @JsonPropertyDescription(value="Restart policy for the container to manage the restart behavior of each\ncontainer within a pod.\nThis may only be set for init containers. You cannot set this field on\nephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String restartPolicy;
    @JsonProperty(value="securityContext")
    @JsonPropertyDescription(value="Optional: SecurityContext defines the security options the ephemeral container should be run with.\nIf set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecurityContext securityContext;
    @JsonProperty(value="startupProbe")
    @JsonPropertyDescription(value="Probes are not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private StartupProbe startupProbe;
    @JsonProperty(value="stdin")
    @JsonPropertyDescription(value="Whether this container should allocate a buffer for stdin in the container runtime. If this\nis not set, reads from stdin in the container will always result in EOF.\nDefault is false.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean stdin;
    @JsonProperty(value="stdinOnce")
    @JsonPropertyDescription(value="Whether the container runtime should close the stdin channel after it has been opened by\na single attach. When stdin is true the stdin stream will remain open across multiple attach\nsessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the\nfirst client attaches to stdin, and then remains open and accepts data until the client disconnects,\nat which time stdin is closed and remains closed until the container is restarted. If this\nflag is false, a container processes that reads from stdin will never receive an EOF.\nDefault is false")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean stdinOnce;
    @JsonProperty(value="targetContainerName")
    @JsonPropertyDescription(value="If set, the name of the container from PodSpec that this ephemeral container targets.\nThe ephemeral container will be run in the namespaces (IPC, PID, etc) of this container.\nIf not set then the ephemeral container uses the namespaces configured in the Pod spec.\n\n\nThe container runtime must implement support for this feature. If the runtime does not\nsupport namespace targeting then the result of setting this field is undefined.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String targetContainerName;
    @JsonProperty(value="terminationMessagePath")
    @JsonPropertyDescription(value="Optional: Path at which the file to which the container's termination message\nwill be written is mounted into the container's filesystem.\nMessage written is intended to be brief final status, such as an assertion failure message.\nWill be truncated by the node if greater than 4096 bytes. The total message length across\nall containers will be limited to 12kb.\nDefaults to /dev/termination-log.\nCannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String terminationMessagePath;
    @JsonProperty(value="terminationMessagePolicy")
    @JsonPropertyDescription(value="Indicate how the termination message should be populated. File will use the contents of\nterminationMessagePath to populate the container status message on both success and failure.\nFallbackToLogsOnError will use the last chunk of container log output if the termination\nmessage file is empty and the container exited with an error.\nThe log output is limited to 2048 bytes or 80 lines, whichever is smaller.\nDefaults to File.\nCannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String terminationMessagePolicy;
    @JsonProperty(value="tty")
    @JsonPropertyDescription(value="Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.\nDefault is false.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean tty;
    @JsonProperty(value="volumeDevices")
    @JsonPropertyDescription(value="volumeDevices is the list of block devices to be used by the container.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<VolumeDevices> volumeDevices;
    @JsonProperty(value="volumeMounts")
    @JsonPropertyDescription(value="Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers.\nCannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<VolumeMounts> volumeMounts;
    @JsonProperty(value="workingDir")
    @JsonPropertyDescription(value="Container's working directory.\nIf not specified, the container runtime's default will be used, which\nmight be configured in the container image.\nCannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String workingDir;

    public EphemeralContainersBuilder edit() {
        return new EphemeralContainersBuilder(this);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public List<Env> getEnv() {
        return this.env;
    }

    public void setEnv(List<Env> env) {
        this.env = env;
    }

    public List<EnvFrom> getEnvFrom() {
        return this.envFrom;
    }

    public void setEnvFrom(List<EnvFrom> envFrom) {
        this.envFrom = envFrom;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public LivenessProbe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(LivenessProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Ports> getPorts() {
        return this.ports;
    }

    public void setPorts(List<Ports> ports) {
        this.ports = ports;
    }

    public ReadinessProbe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(ReadinessProbe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    public List<ResizePolicy> getResizePolicy() {
        return this.resizePolicy;
    }

    public void setResizePolicy(List<ResizePolicy> resizePolicy) {
        this.resizePolicy = resizePolicy;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public StartupProbe getStartupProbe() {
        return this.startupProbe;
    }

    public void setStartupProbe(StartupProbe startupProbe) {
        this.startupProbe = startupProbe;
    }

    public Boolean getStdin() {
        return this.stdin;
    }

    public void setStdin(Boolean stdin) {
        this.stdin = stdin;
    }

    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public void setStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
    }

    public String getTargetContainerName() {
        return this.targetContainerName;
    }

    public void setTargetContainerName(String targetContainerName) {
        this.targetContainerName = targetContainerName;
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public void setTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public void setTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
    }

    public Boolean getTty() {
        return this.tty;
    }

    public void setTty(Boolean tty) {
        this.tty = tty;
    }

    public List<VolumeDevices> getVolumeDevices() {
        return this.volumeDevices;
    }

    public void setVolumeDevices(List<VolumeDevices> volumeDevices) {
        this.volumeDevices = volumeDevices;
    }

    public List<VolumeMounts> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<VolumeMounts> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String toString() {
        return "EphemeralContainers(args=" + this.getArgs() + ", command=" + this.getCommand() + ", env=" + this.getEnv() + ", envFrom=" + this.getEnvFrom() + ", image=" + this.getImage() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", lifecycle=" + this.getLifecycle() + ", livenessProbe=" + this.getLivenessProbe() + ", name=" + this.getName() + ", ports=" + this.getPorts() + ", readinessProbe=" + this.getReadinessProbe() + ", resizePolicy=" + this.getResizePolicy() + ", resources=" + this.getResources() + ", restartPolicy=" + this.getRestartPolicy() + ", securityContext=" + this.getSecurityContext() + ", startupProbe=" + this.getStartupProbe() + ", stdin=" + this.getStdin() + ", stdinOnce=" + this.getStdinOnce() + ", targetContainerName=" + this.getTargetContainerName() + ", terminationMessagePath=" + this.getTerminationMessagePath() + ", terminationMessagePolicy=" + this.getTerminationMessagePolicy() + ", tty=" + this.getTty() + ", volumeDevices=" + this.getVolumeDevices() + ", volumeMounts=" + this.getVolumeMounts() + ", workingDir=" + this.getWorkingDir() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EphemeralContainers)) {
            return false;
        }
        EphemeralContainers other = (EphemeralContainers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$stdin = this.getStdin();
        Boolean other$stdin = other.getStdin();
        if (this$stdin == null ? other$stdin != null : !((Object)this$stdin).equals(other$stdin)) {
            return false;
        }
        Boolean this$stdinOnce = this.getStdinOnce();
        Boolean other$stdinOnce = other.getStdinOnce();
        if (this$stdinOnce == null ? other$stdinOnce != null : !((Object)this$stdinOnce).equals(other$stdinOnce)) {
            return false;
        }
        Boolean this$tty = this.getTty();
        Boolean other$tty = other.getTty();
        if (this$tty == null ? other$tty != null : !((Object)this$tty).equals(other$tty)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        List<String> this$command = this.getCommand();
        List<String> other$command = other.getCommand();
        if (this$command == null ? other$command != null : !((Object)this$command).equals(other$command)) {
            return false;
        }
        List<Env> this$env = this.getEnv();
        List<Env> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        List<EnvFrom> this$envFrom = this.getEnvFrom();
        List<EnvFrom> other$envFrom = other.getEnvFrom();
        if (this$envFrom == null ? other$envFrom != null : !((Object)this$envFrom).equals(other$envFrom)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)this$lifecycle).equals(other$lifecycle)) {
            return false;
        }
        LivenessProbe this$livenessProbe = this.getLivenessProbe();
        LivenessProbe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Ports> this$ports = this.getPorts();
        List<Ports> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        ReadinessProbe this$readinessProbe = this.getReadinessProbe();
        ReadinessProbe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        List<ResizePolicy> this$resizePolicy = this.getResizePolicy();
        List<ResizePolicy> other$resizePolicy = other.getResizePolicy();
        if (this$resizePolicy == null ? other$resizePolicy != null : !((Object)this$resizePolicy).equals(other$resizePolicy)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$restartPolicy = this.getRestartPolicy();
        String other$restartPolicy = other.getRestartPolicy();
        if (this$restartPolicy == null ? other$restartPolicy != null : !this$restartPolicy.equals(other$restartPolicy)) {
            return false;
        }
        SecurityContext this$securityContext = this.getSecurityContext();
        SecurityContext other$securityContext = other.getSecurityContext();
        if (this$securityContext == null ? other$securityContext != null : !((Object)this$securityContext).equals(other$securityContext)) {
            return false;
        }
        StartupProbe this$startupProbe = this.getStartupProbe();
        StartupProbe other$startupProbe = other.getStartupProbe();
        if (this$startupProbe == null ? other$startupProbe != null : !((Object)this$startupProbe).equals(other$startupProbe)) {
            return false;
        }
        String this$targetContainerName = this.getTargetContainerName();
        String other$targetContainerName = other.getTargetContainerName();
        if (this$targetContainerName == null ? other$targetContainerName != null : !this$targetContainerName.equals(other$targetContainerName)) {
            return false;
        }
        String this$terminationMessagePath = this.getTerminationMessagePath();
        String other$terminationMessagePath = other.getTerminationMessagePath();
        if (this$terminationMessagePath == null ? other$terminationMessagePath != null : !this$terminationMessagePath.equals(other$terminationMessagePath)) {
            return false;
        }
        String this$terminationMessagePolicy = this.getTerminationMessagePolicy();
        String other$terminationMessagePolicy = other.getTerminationMessagePolicy();
        if (this$terminationMessagePolicy == null ? other$terminationMessagePolicy != null : !this$terminationMessagePolicy.equals(other$terminationMessagePolicy)) {
            return false;
        }
        List<VolumeDevices> this$volumeDevices = this.getVolumeDevices();
        List<VolumeDevices> other$volumeDevices = other.getVolumeDevices();
        if (this$volumeDevices == null ? other$volumeDevices != null : !((Object)this$volumeDevices).equals(other$volumeDevices)) {
            return false;
        }
        List<VolumeMounts> this$volumeMounts = this.getVolumeMounts();
        List<VolumeMounts> other$volumeMounts = other.getVolumeMounts();
        if (this$volumeMounts == null ? other$volumeMounts != null : !((Object)this$volumeMounts).equals(other$volumeMounts)) {
            return false;
        }
        String this$workingDir = this.getWorkingDir();
        String other$workingDir = other.getWorkingDir();
        return !(this$workingDir == null ? other$workingDir != null : !this$workingDir.equals(other$workingDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EphemeralContainers;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $stdin = this.getStdin();
        result = result * 59 + ($stdin == null ? 43 : ((Object)$stdin).hashCode());
        Boolean $stdinOnce = this.getStdinOnce();
        result = result * 59 + ($stdinOnce == null ? 43 : ((Object)$stdinOnce).hashCode());
        Boolean $tty = this.getTty();
        result = result * 59 + ($tty == null ? 43 : ((Object)$tty).hashCode());
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        List<String> $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
        List<Env> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        List<EnvFrom> $envFrom = this.getEnvFrom();
        result = result * 59 + ($envFrom == null ? 43 : ((Object)$envFrom).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)$lifecycle).hashCode());
        LivenessProbe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Ports> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        ReadinessProbe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        List<ResizePolicy> $resizePolicy = this.getResizePolicy();
        result = result * 59 + ($resizePolicy == null ? 43 : ((Object)$resizePolicy).hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $restartPolicy = this.getRestartPolicy();
        result = result * 59 + ($restartPolicy == null ? 43 : $restartPolicy.hashCode());
        SecurityContext $securityContext = this.getSecurityContext();
        result = result * 59 + ($securityContext == null ? 43 : ((Object)$securityContext).hashCode());
        StartupProbe $startupProbe = this.getStartupProbe();
        result = result * 59 + ($startupProbe == null ? 43 : ((Object)$startupProbe).hashCode());
        String $targetContainerName = this.getTargetContainerName();
        result = result * 59 + ($targetContainerName == null ? 43 : $targetContainerName.hashCode());
        String $terminationMessagePath = this.getTerminationMessagePath();
        result = result * 59 + ($terminationMessagePath == null ? 43 : $terminationMessagePath.hashCode());
        String $terminationMessagePolicy = this.getTerminationMessagePolicy();
        result = result * 59 + ($terminationMessagePolicy == null ? 43 : $terminationMessagePolicy.hashCode());
        List<VolumeDevices> $volumeDevices = this.getVolumeDevices();
        result = result * 59 + ($volumeDevices == null ? 43 : ((Object)$volumeDevices).hashCode());
        List<VolumeMounts> $volumeMounts = this.getVolumeMounts();
        result = result * 59 + ($volumeMounts == null ? 43 : ((Object)$volumeMounts).hashCode());
        String $workingDir = this.getWorkingDir();
        result = result * 59 + ($workingDir == null ? 43 : $workingDir.hashCode());
        return result;
    }
}

