# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from buildstream._protos.build.bazel.remote.execution.v2 import remote_execution_pb2 as build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2
from buildstream._protos.google.longrunning import operations_pb2 as google_dot_longrunning_dot_operations__pb2


class ExecutionStub(object):
    """The Remote Execution API is used to execute an
    [Action][build.bazel.remote.execution.v2.Action] on the remote
    workers.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Execute = channel.unary_stream(
                '/build.bazel.remote.execution.v2.Execution/Execute',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ExecuteRequest.SerializeToString,
                response_deserializer=google_dot_longrunning_dot_operations__pb2.Operation.FromString,
                )
        self.WaitExecution = channel.unary_stream(
                '/build.bazel.remote.execution.v2.Execution/WaitExecution',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.WaitExecutionRequest.SerializeToString,
                response_deserializer=google_dot_longrunning_dot_operations__pb2.Operation.FromString,
                )


class ExecutionServicer(object):
    """The Remote Execution API is used to execute an
    [Action][build.bazel.remote.execution.v2.Action] on the remote
    workers.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    def Execute(self, request, context):
        """Execute an action remotely.

        In order to execute an action, the client must first upload all of the
        inputs, the
        [Command][build.bazel.remote.execution.v2.Command] to run, and the
        [Action][build.bazel.remote.execution.v2.Action] into the
        [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
        It then calls `Execute` with an `action_digest` referring to them. The
        server will run the action and eventually return the result.

        The input `Action`'s fields MUST meet the various canonicalization
        requirements specified in the documentation for their types so that it has
        the same digest as other logically equivalent `Action`s. The server MAY
        enforce the requirements and return errors if a non-canonical input is
        received. It MAY also proceed without verifying some or all of the
        requirements, such as for performance reasons. If the server does not
        verify the requirement, then it will treat the `Action` as distinct from
        another logically equivalent action if they hash differently.

        Returns a stream of
        [google.longrunning.Operation][google.longrunning.Operation] messages
        describing the resulting execution, with eventual `response`
        [ExecuteResponse][build.bazel.remote.execution.v2.ExecuteResponse]. The
        `metadata` on the operation is of type
        [ExecuteOperationMetadata][build.bazel.remote.execution.v2.ExecuteOperationMetadata].

        If the client remains connected after the first response is returned after
        the server, then updates are streamed as if the client had called
        [WaitExecution][build.bazel.remote.execution.v2.Execution.WaitExecution]
        until the execution completes or the request reaches an error. The
        operation can also be queried using [Operations
        API][google.longrunning.Operations.GetOperation].

        The server NEED NOT implement other methods or functionality of the
        Operations API.

        Errors discovered during creation of the `Operation` will be reported
        as gRPC Status errors, while errors that occurred while running the
        action will be reported in the `status` field of the `ExecuteResponse`. The
        server MUST NOT set the `error` field of the `Operation` proto.
        The possible errors include:

        * `INVALID_ARGUMENT`: One or more arguments are invalid.
        * `FAILED_PRECONDITION`: One or more errors occurred in setting up the
        action requested, such as a missing input or command or no worker being
        available. The client may be able to fix the errors and retry.
        * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
        the action.
        * `UNAVAILABLE`: Due to a transient condition, such as all workers being
        occupied (and the server does not support a queue), the action could not
        be started. The client should retry.
        * `INTERNAL`: An internal error occurred in the execution engine or the
        worker.
        * `DEADLINE_EXCEEDED`: The execution timed out.
        * `CANCELLED`: The operation was cancelled by the client. This status is
        only possible if the server implements the Operations API CancelOperation
        method, and it was called for the current execution.

        In the case of a missing input or command, the server SHOULD additionally
        send a [PreconditionFailure][google.rpc.PreconditionFailure] error detail
        where, for each requested blob not present in the CAS, there is a
        `Violation` with a `type` of `MISSING` and a `subject` of
        `"blobs/{hash}/{size}"` indicating the digest of the missing blob.

        The server does not need to guarantee that a call to this method leads to
        at most one execution of the action. The server MAY execute the action
        multiple times, potentially in parallel. These redundant executions MAY
        continue to run, even if the operation is completed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def WaitExecution(self, request, context):
        """Wait for an execution operation to complete. When the client initially
        makes the request, the server immediately responds with the current status
        of the execution. The server will leave the request stream open until the
        operation completes, and then respond with the completed operation. The
        server MAY choose to stream additional updates as execution progresses,
        such as to provide an update as to the state of the execution.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ExecutionServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Execute': grpc.unary_stream_rpc_method_handler(
                    servicer.Execute,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ExecuteRequest.FromString,
                    response_serializer=google_dot_longrunning_dot_operations__pb2.Operation.SerializeToString,
            ),
            'WaitExecution': grpc.unary_stream_rpc_method_handler(
                    servicer.WaitExecution,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.WaitExecutionRequest.FromString,
                    response_serializer=google_dot_longrunning_dot_operations__pb2.Operation.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'build.bazel.remote.execution.v2.Execution', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Execution(object):
    """The Remote Execution API is used to execute an
    [Action][build.bazel.remote.execution.v2.Action] on the remote
    workers.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    @staticmethod
    def Execute(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/build.bazel.remote.execution.v2.Execution/Execute',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ExecuteRequest.SerializeToString,
            google_dot_longrunning_dot_operations__pb2.Operation.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def WaitExecution(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/build.bazel.remote.execution.v2.Execution/WaitExecution',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.WaitExecutionRequest.SerializeToString,
            google_dot_longrunning_dot_operations__pb2.Operation.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)


class ActionCacheStub(object):
    """The action cache API is used to query whether a given action has already been
    performed and, if so, retrieve its result. Unlike the
    [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage],
    which addresses blobs by their own content, the action cache addresses the
    [ActionResult][build.bazel.remote.execution.v2.ActionResult] by a
    digest of the encoded [Action][build.bazel.remote.execution.v2.Action]
    which produced them.

    The lifetime of entries in the action cache is implementation-specific, but
    the server SHOULD assume that more recently used entries are more likely to
    be used again.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetActionResult = channel.unary_unary(
                '/build.bazel.remote.execution.v2.ActionCache/GetActionResult',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetActionResultRequest.SerializeToString,
                response_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ActionResult.FromString,
                )
        self.UpdateActionResult = channel.unary_unary(
                '/build.bazel.remote.execution.v2.ActionCache/UpdateActionResult',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.UpdateActionResultRequest.SerializeToString,
                response_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ActionResult.FromString,
                )


class ActionCacheServicer(object):
    """The action cache API is used to query whether a given action has already been
    performed and, if so, retrieve its result. Unlike the
    [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage],
    which addresses blobs by their own content, the action cache addresses the
    [ActionResult][build.bazel.remote.execution.v2.ActionResult] by a
    digest of the encoded [Action][build.bazel.remote.execution.v2.Action]
    which produced them.

    The lifetime of entries in the action cache is implementation-specific, but
    the server SHOULD assume that more recently used entries are more likely to
    be used again.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    def GetActionResult(self, request, context):
        """Retrieve a cached execution result.

        Implementations SHOULD ensure that any blobs referenced from the
        [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
        are available at the time of returning the
        [ActionResult][build.bazel.remote.execution.v2.ActionResult] and will be
        for some period of time afterwards. The lifetimes of the referenced blobs SHOULD be increased
        if necessary and applicable.

        Errors:

        * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateActionResult(self, request, context):
        """Upload a new execution result.

        In order to allow the server to perform access control based on the type of
        action, and to assist with client debugging, the client MUST first upload
        the [Action][build.bazel.remote.execution.v2.Execution] that produced the
        result, along with its
        [Command][build.bazel.remote.execution.v2.Command], into the
        `ContentAddressableStorage`.

        Server implementations MAY modify the
        `UpdateActionResultRequest.action_result` and return an equivalent value.

        Errors:

        * `INVALID_ARGUMENT`: One or more arguments are invalid.
        * `FAILED_PRECONDITION`: One or more errors occurred in updating the
        action result, such as a missing command or action.
        * `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
        entry to the cache.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ActionCacheServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetActionResult': grpc.unary_unary_rpc_method_handler(
                    servicer.GetActionResult,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetActionResultRequest.FromString,
                    response_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ActionResult.SerializeToString,
            ),
            'UpdateActionResult': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateActionResult,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.UpdateActionResultRequest.FromString,
                    response_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ActionResult.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'build.bazel.remote.execution.v2.ActionCache', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ActionCache(object):
    """The action cache API is used to query whether a given action has already been
    performed and, if so, retrieve its result. Unlike the
    [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage],
    which addresses blobs by their own content, the action cache addresses the
    [ActionResult][build.bazel.remote.execution.v2.ActionResult] by a
    digest of the encoded [Action][build.bazel.remote.execution.v2.Action]
    which produced them.

    The lifetime of entries in the action cache is implementation-specific, but
    the server SHOULD assume that more recently used entries are more likely to
    be used again.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    @staticmethod
    def GetActionResult(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/build.bazel.remote.execution.v2.ActionCache/GetActionResult',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetActionResultRequest.SerializeToString,
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ActionResult.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateActionResult(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/build.bazel.remote.execution.v2.ActionCache/UpdateActionResult',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.UpdateActionResultRequest.SerializeToString,
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ActionResult.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)


class ContentAddressableStorageStub(object):
    """The CAS (content-addressable storage) is used to store the inputs to and
    outputs from the execution service. Each piece of content is addressed by the
    digest of its binary data.

    Most of the binary data stored in the CAS is opaque to the execution engine,
    and is only used as a communication medium. In order to build an
    [Action][build.bazel.remote.execution.v2.Action],
    however, the client will need to also upload the
    [Command][build.bazel.remote.execution.v2.Command] and input root
    [Directory][build.bazel.remote.execution.v2.Directory] for the Action.
    The Command and Directory messages must be marshalled to wire format and then
    uploaded under the hash as with any other piece of content. In practice, the
    input root directory is likely to refer to other Directories in its
    hierarchy, which must also each be uploaded on their own.

    For small file uploads the client should group them together and call
    [BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs].

    For large uploads, the client must use the
    [Write method][google.bytestream.ByteStream.Write] of the ByteStream API.

    For uncompressed data, The `WriteRequest.resource_name` is of the following form:
    `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}{/optional_metadata}`

    Where:
    * `instance_name` is an identifier, possibly containing multiple path
    segments, used to distinguish between the various instances on the server,
    in a manner defined by the server. If it is the empty path, the leading
    slash is omitted, so that  the `resource_name` becomes
    `uploads/{uuid}/blobs/{hash}/{size}{/optional_metadata}`.
    To simplify parsing, a path segment cannot equal any of the following
    keywords: `blobs`, `uploads`, `actions`, `actionResults`, `operations`,
    `capabilities` or `compressed-blobs`.
    * `uuid` is a version 4 UUID generated by the client, used to avoid
    collisions between concurrent uploads of the same data. Clients MAY
    reuse the same `uuid` for uploading different blobs.
    * `hash` and `size` refer to the [Digest][build.bazel.remote.execution.v2.Digest]
    of the data being uploaded.
    * `optional_metadata` is implementation specific data, which clients MAY omit.
    Servers MAY ignore this metadata.

    Data can alternatively be uploaded in compressed form, with the following
    `WriteRequest.resource_name` form:
    `{instance_name}/uploads/{uuid}/compressed-blobs/{compressor}/{uncompressed_hash}/{uncompressed_size}{/optional_metadata}`

    Where:
    * `instance_name`, `uuid` and `optional_metadata` are defined as above.
    * `compressor` is a lowercase string form of a `Compressor.Value` enum
    other than `identity`, which is supported by the server and advertised in
    [CacheCapabilities.supported_compressor][build.bazel.remote.execution.v2.CacheCapabilities.supported_compressor].
    * `uncompressed_hash` and `uncompressed_size` refer to the
    [Digest][build.bazel.remote.execution.v2.Digest] of the data being
    uploaded, once uncompressed. Servers MUST verify that these match
    the uploaded data once uncompressed, and MUST return an
    `INVALID_ARGUMENT` error in the case of mismatch.

    Note that when writing compressed blobs, the `WriteRequest.write_offset` in
    the initial request in a stream refers to the offset in the uncompressed form
    of the blob. In subsequent requests, `WriteRequest.write_offset` MUST be the
    sum of the first request's 'WriteRequest.write_offset' and the total size of
    all the compressed data bundles in the previous requests.
    Note that this mixes an uncompressed offset with a compressed byte length,
    which is nonsensical, but it is done to fit the semantics of the existing
    ByteStream protocol.

    Uploads of the same data MAY occur concurrently in any form, compressed or
    uncompressed.

    Clients SHOULD NOT use gRPC-level compression for ByteStream API `Write`
    calls of compressed blobs, since this would compress already-compressed data.

    When attempting an upload, if another client has already completed the upload
    (which may occur in the middle of a single upload if another client uploads
    the same blob concurrently), the request will terminate immediately without
    error, and with a response whose `committed_size` is the value `-1` if this
    is a compressed upload, or with the full size of the uploaded file if this is
    an uncompressed upload (regardless of how much data was transmitted by the
    client). If the client completes the upload but the
    [Digest][build.bazel.remote.execution.v2.Digest] does not match, an
    `INVALID_ARGUMENT` error will be returned. In either case, the client should
    not attempt to retry the upload.

    Small downloads can be grouped and requested in a batch via
    [BatchReadBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs].

    For large downloads, the client must use the
    [Read method][google.bytestream.ByteStream.Read] of the ByteStream API.

    For uncompressed data, The `ReadRequest.resource_name` is of the following form:
    `{instance_name}/blobs/{hash}/{size}`
    Where `instance_name`, `hash` and `size` are defined as for uploads.

    Data can alternatively be downloaded in compressed form, with the following
    `ReadRequest.resource_name` form:
    `{instance_name}/compressed-blobs/{compressor}/{uncompressed_hash}/{uncompressed_size}`

    Where:
    * `instance_name` and `compressor` are defined as for uploads.
    * `uncompressed_hash` and `uncompressed_size` refer to the
    [Digest][build.bazel.remote.execution.v2.Digest] of the data being
    downloaded, once uncompressed. Clients MUST verify that these match
    the downloaded data once uncompressed, and take appropriate steps in
    the case of failure such as retrying a limited number of times or
    surfacing an error to the user.

    When downloading compressed blobs:
    * `ReadRequest.read_offset` refers to the offset in the uncompressed form
    of the blob.
    * Servers MUST return `INVALID_ARGUMENT` if `ReadRequest.read_limit` is
    non-zero.
    * Servers MAY use any compression level they choose, including different
    levels for different blobs (e.g. choosing a level designed for maximum
    speed for data known to be incompressible).
    * Clients SHOULD NOT use gRPC-level compression, since this would compress
    already-compressed data.

    Servers MUST be able to provide data for all recently advertised blobs in
    each of the compression formats that the server supports, as well as in
    uncompressed form.

    The lifetime of entries in the CAS is implementation specific, but it SHOULD
    be long enough to allow for newly-added and recently looked-up entries to be
    used in subsequent calls (e.g. to
    [Execute][build.bazel.remote.execution.v2.Execution.Execute]).

    Servers MUST behave as though empty blobs are always available, even if they
    have not been uploaded. Clients MAY optimize away the uploading or
    downloading of empty blobs.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.FindMissingBlobs = channel.unary_unary(
                '/build.bazel.remote.execution.v2.ContentAddressableStorage/FindMissingBlobs',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.FindMissingBlobsRequest.SerializeToString,
                response_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.FindMissingBlobsResponse.FromString,
                )
        self.BatchUpdateBlobs = channel.unary_unary(
                '/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchUpdateBlobs',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchUpdateBlobsRequest.SerializeToString,
                response_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchUpdateBlobsResponse.FromString,
                )
        self.BatchReadBlobs = channel.unary_unary(
                '/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchReadBlobs',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchReadBlobsRequest.SerializeToString,
                response_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchReadBlobsResponse.FromString,
                )
        self.GetTree = channel.unary_stream(
                '/build.bazel.remote.execution.v2.ContentAddressableStorage/GetTree',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetTreeRequest.SerializeToString,
                response_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetTreeResponse.FromString,
                )


class ContentAddressableStorageServicer(object):
    """The CAS (content-addressable storage) is used to store the inputs to and
    outputs from the execution service. Each piece of content is addressed by the
    digest of its binary data.

    Most of the binary data stored in the CAS is opaque to the execution engine,
    and is only used as a communication medium. In order to build an
    [Action][build.bazel.remote.execution.v2.Action],
    however, the client will need to also upload the
    [Command][build.bazel.remote.execution.v2.Command] and input root
    [Directory][build.bazel.remote.execution.v2.Directory] for the Action.
    The Command and Directory messages must be marshalled to wire format and then
    uploaded under the hash as with any other piece of content. In practice, the
    input root directory is likely to refer to other Directories in its
    hierarchy, which must also each be uploaded on their own.

    For small file uploads the client should group them together and call
    [BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs].

    For large uploads, the client must use the
    [Write method][google.bytestream.ByteStream.Write] of the ByteStream API.

    For uncompressed data, The `WriteRequest.resource_name` is of the following form:
    `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}{/optional_metadata}`

    Where:
    * `instance_name` is an identifier, possibly containing multiple path
    segments, used to distinguish between the various instances on the server,
    in a manner defined by the server. If it is the empty path, the leading
    slash is omitted, so that  the `resource_name` becomes
    `uploads/{uuid}/blobs/{hash}/{size}{/optional_metadata}`.
    To simplify parsing, a path segment cannot equal any of the following
    keywords: `blobs`, `uploads`, `actions`, `actionResults`, `operations`,
    `capabilities` or `compressed-blobs`.
    * `uuid` is a version 4 UUID generated by the client, used to avoid
    collisions between concurrent uploads of the same data. Clients MAY
    reuse the same `uuid` for uploading different blobs.
    * `hash` and `size` refer to the [Digest][build.bazel.remote.execution.v2.Digest]
    of the data being uploaded.
    * `optional_metadata` is implementation specific data, which clients MAY omit.
    Servers MAY ignore this metadata.

    Data can alternatively be uploaded in compressed form, with the following
    `WriteRequest.resource_name` form:
    `{instance_name}/uploads/{uuid}/compressed-blobs/{compressor}/{uncompressed_hash}/{uncompressed_size}{/optional_metadata}`

    Where:
    * `instance_name`, `uuid` and `optional_metadata` are defined as above.
    * `compressor` is a lowercase string form of a `Compressor.Value` enum
    other than `identity`, which is supported by the server and advertised in
    [CacheCapabilities.supported_compressor][build.bazel.remote.execution.v2.CacheCapabilities.supported_compressor].
    * `uncompressed_hash` and `uncompressed_size` refer to the
    [Digest][build.bazel.remote.execution.v2.Digest] of the data being
    uploaded, once uncompressed. Servers MUST verify that these match
    the uploaded data once uncompressed, and MUST return an
    `INVALID_ARGUMENT` error in the case of mismatch.

    Note that when writing compressed blobs, the `WriteRequest.write_offset` in
    the initial request in a stream refers to the offset in the uncompressed form
    of the blob. In subsequent requests, `WriteRequest.write_offset` MUST be the
    sum of the first request's 'WriteRequest.write_offset' and the total size of
    all the compressed data bundles in the previous requests.
    Note that this mixes an uncompressed offset with a compressed byte length,
    which is nonsensical, but it is done to fit the semantics of the existing
    ByteStream protocol.

    Uploads of the same data MAY occur concurrently in any form, compressed or
    uncompressed.

    Clients SHOULD NOT use gRPC-level compression for ByteStream API `Write`
    calls of compressed blobs, since this would compress already-compressed data.

    When attempting an upload, if another client has already completed the upload
    (which may occur in the middle of a single upload if another client uploads
    the same blob concurrently), the request will terminate immediately without
    error, and with a response whose `committed_size` is the value `-1` if this
    is a compressed upload, or with the full size of the uploaded file if this is
    an uncompressed upload (regardless of how much data was transmitted by the
    client). If the client completes the upload but the
    [Digest][build.bazel.remote.execution.v2.Digest] does not match, an
    `INVALID_ARGUMENT` error will be returned. In either case, the client should
    not attempt to retry the upload.

    Small downloads can be grouped and requested in a batch via
    [BatchReadBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs].

    For large downloads, the client must use the
    [Read method][google.bytestream.ByteStream.Read] of the ByteStream API.

    For uncompressed data, The `ReadRequest.resource_name` is of the following form:
    `{instance_name}/blobs/{hash}/{size}`
    Where `instance_name`, `hash` and `size` are defined as for uploads.

    Data can alternatively be downloaded in compressed form, with the following
    `ReadRequest.resource_name` form:
    `{instance_name}/compressed-blobs/{compressor}/{uncompressed_hash}/{uncompressed_size}`

    Where:
    * `instance_name` and `compressor` are defined as for uploads.
    * `uncompressed_hash` and `uncompressed_size` refer to the
    [Digest][build.bazel.remote.execution.v2.Digest] of the data being
    downloaded, once uncompressed. Clients MUST verify that these match
    the downloaded data once uncompressed, and take appropriate steps in
    the case of failure such as retrying a limited number of times or
    surfacing an error to the user.

    When downloading compressed blobs:
    * `ReadRequest.read_offset` refers to the offset in the uncompressed form
    of the blob.
    * Servers MUST return `INVALID_ARGUMENT` if `ReadRequest.read_limit` is
    non-zero.
    * Servers MAY use any compression level they choose, including different
    levels for different blobs (e.g. choosing a level designed for maximum
    speed for data known to be incompressible).
    * Clients SHOULD NOT use gRPC-level compression, since this would compress
    already-compressed data.

    Servers MUST be able to provide data for all recently advertised blobs in
    each of the compression formats that the server supports, as well as in
    uncompressed form.

    The lifetime of entries in the CAS is implementation specific, but it SHOULD
    be long enough to allow for newly-added and recently looked-up entries to be
    used in subsequent calls (e.g. to
    [Execute][build.bazel.remote.execution.v2.Execution.Execute]).

    Servers MUST behave as though empty blobs are always available, even if they
    have not been uploaded. Clients MAY optimize away the uploading or
    downloading of empty blobs.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    def FindMissingBlobs(self, request, context):
        """Determine if blobs are present in the CAS.

        Clients can use this API before uploading blobs to determine which ones are
        already present in the CAS and do not need to be uploaded again.

        Servers SHOULD increase the lifetimes of the referenced blobs if necessary and
        applicable.

        There are no method-specific errors.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def BatchUpdateBlobs(self, request, context):
        """Upload many blobs at once.

        The server may enforce a limit of the combined total size of blobs
        to be uploaded using this API. This limit may be obtained using the
        [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
        Requests exceeding the limit should either be split into smaller
        chunks or uploaded using the
        [ByteStream API][google.bytestream.ByteStream], as appropriate.

        This request is equivalent to calling a Bytestream `Write` request
        on each individual blob, in parallel. The requests may succeed or fail
        independently.

        Errors:

        * `INVALID_ARGUMENT`: The client attempted to upload more than the
        server supported limit.

        Individual requests may return the following errors, additionally:

        * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
        * `INVALID_ARGUMENT`: The
        [Digest][build.bazel.remote.execution.v2.Digest] does not match the
        provided data.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def BatchReadBlobs(self, request, context):
        """Download many blobs at once.

        The server may enforce a limit of the combined total size of blobs
        to be downloaded using this API. This limit may be obtained using the
        [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
        Requests exceeding the limit should either be split into smaller
        chunks or downloaded using the
        [ByteStream API][google.bytestream.ByteStream], as appropriate.

        This request is equivalent to calling a Bytestream `Read` request
        on each individual blob, in parallel. The requests may succeed or fail
        independently.

        Errors:

        * `INVALID_ARGUMENT`: The client attempted to read more than the
        server supported limit.

        Every error on individual read will be returned in the corresponding digest
        status.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTree(self, request, context):
        """Fetch the entire directory tree rooted at a node.

        This request must be targeted at a
        [Directory][build.bazel.remote.execution.v2.Directory] stored in the
        [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
        (CAS). The server will enumerate the `Directory` tree recursively and
        return every node descended from the root.

        The GetTreeRequest.page_token parameter can be used to skip ahead in
        the stream (e.g. when retrying a partially completed and aborted request),
        by setting it to a value taken from GetTreeResponse.next_page_token of the
        last successfully processed GetTreeResponse).

        The exact traversal order is unspecified and, unless retrieving subsequent
        pages from an earlier request, is not guaranteed to be stable across
        multiple invocations of `GetTree`.

        If part of the tree is missing from the CAS, the server will return the
        portion present and omit the rest.

        Errors:

        * `NOT_FOUND`: The requested tree root is not present in the CAS.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ContentAddressableStorageServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'FindMissingBlobs': grpc.unary_unary_rpc_method_handler(
                    servicer.FindMissingBlobs,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.FindMissingBlobsRequest.FromString,
                    response_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.FindMissingBlobsResponse.SerializeToString,
            ),
            'BatchUpdateBlobs': grpc.unary_unary_rpc_method_handler(
                    servicer.BatchUpdateBlobs,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchUpdateBlobsRequest.FromString,
                    response_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchUpdateBlobsResponse.SerializeToString,
            ),
            'BatchReadBlobs': grpc.unary_unary_rpc_method_handler(
                    servicer.BatchReadBlobs,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchReadBlobsRequest.FromString,
                    response_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchReadBlobsResponse.SerializeToString,
            ),
            'GetTree': grpc.unary_stream_rpc_method_handler(
                    servicer.GetTree,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetTreeRequest.FromString,
                    response_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetTreeResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'build.bazel.remote.execution.v2.ContentAddressableStorage', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ContentAddressableStorage(object):
    """The CAS (content-addressable storage) is used to store the inputs to and
    outputs from the execution service. Each piece of content is addressed by the
    digest of its binary data.

    Most of the binary data stored in the CAS is opaque to the execution engine,
    and is only used as a communication medium. In order to build an
    [Action][build.bazel.remote.execution.v2.Action],
    however, the client will need to also upload the
    [Command][build.bazel.remote.execution.v2.Command] and input root
    [Directory][build.bazel.remote.execution.v2.Directory] for the Action.
    The Command and Directory messages must be marshalled to wire format and then
    uploaded under the hash as with any other piece of content. In practice, the
    input root directory is likely to refer to other Directories in its
    hierarchy, which must also each be uploaded on their own.

    For small file uploads the client should group them together and call
    [BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs].

    For large uploads, the client must use the
    [Write method][google.bytestream.ByteStream.Write] of the ByteStream API.

    For uncompressed data, The `WriteRequest.resource_name` is of the following form:
    `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}{/optional_metadata}`

    Where:
    * `instance_name` is an identifier, possibly containing multiple path
    segments, used to distinguish between the various instances on the server,
    in a manner defined by the server. If it is the empty path, the leading
    slash is omitted, so that  the `resource_name` becomes
    `uploads/{uuid}/blobs/{hash}/{size}{/optional_metadata}`.
    To simplify parsing, a path segment cannot equal any of the following
    keywords: `blobs`, `uploads`, `actions`, `actionResults`, `operations`,
    `capabilities` or `compressed-blobs`.
    * `uuid` is a version 4 UUID generated by the client, used to avoid
    collisions between concurrent uploads of the same data. Clients MAY
    reuse the same `uuid` for uploading different blobs.
    * `hash` and `size` refer to the [Digest][build.bazel.remote.execution.v2.Digest]
    of the data being uploaded.
    * `optional_metadata` is implementation specific data, which clients MAY omit.
    Servers MAY ignore this metadata.

    Data can alternatively be uploaded in compressed form, with the following
    `WriteRequest.resource_name` form:
    `{instance_name}/uploads/{uuid}/compressed-blobs/{compressor}/{uncompressed_hash}/{uncompressed_size}{/optional_metadata}`

    Where:
    * `instance_name`, `uuid` and `optional_metadata` are defined as above.
    * `compressor` is a lowercase string form of a `Compressor.Value` enum
    other than `identity`, which is supported by the server and advertised in
    [CacheCapabilities.supported_compressor][build.bazel.remote.execution.v2.CacheCapabilities.supported_compressor].
    * `uncompressed_hash` and `uncompressed_size` refer to the
    [Digest][build.bazel.remote.execution.v2.Digest] of the data being
    uploaded, once uncompressed. Servers MUST verify that these match
    the uploaded data once uncompressed, and MUST return an
    `INVALID_ARGUMENT` error in the case of mismatch.

    Note that when writing compressed blobs, the `WriteRequest.write_offset` in
    the initial request in a stream refers to the offset in the uncompressed form
    of the blob. In subsequent requests, `WriteRequest.write_offset` MUST be the
    sum of the first request's 'WriteRequest.write_offset' and the total size of
    all the compressed data bundles in the previous requests.
    Note that this mixes an uncompressed offset with a compressed byte length,
    which is nonsensical, but it is done to fit the semantics of the existing
    ByteStream protocol.

    Uploads of the same data MAY occur concurrently in any form, compressed or
    uncompressed.

    Clients SHOULD NOT use gRPC-level compression for ByteStream API `Write`
    calls of compressed blobs, since this would compress already-compressed data.

    When attempting an upload, if another client has already completed the upload
    (which may occur in the middle of a single upload if another client uploads
    the same blob concurrently), the request will terminate immediately without
    error, and with a response whose `committed_size` is the value `-1` if this
    is a compressed upload, or with the full size of the uploaded file if this is
    an uncompressed upload (regardless of how much data was transmitted by the
    client). If the client completes the upload but the
    [Digest][build.bazel.remote.execution.v2.Digest] does not match, an
    `INVALID_ARGUMENT` error will be returned. In either case, the client should
    not attempt to retry the upload.

    Small downloads can be grouped and requested in a batch via
    [BatchReadBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs].

    For large downloads, the client must use the
    [Read method][google.bytestream.ByteStream.Read] of the ByteStream API.

    For uncompressed data, The `ReadRequest.resource_name` is of the following form:
    `{instance_name}/blobs/{hash}/{size}`
    Where `instance_name`, `hash` and `size` are defined as for uploads.

    Data can alternatively be downloaded in compressed form, with the following
    `ReadRequest.resource_name` form:
    `{instance_name}/compressed-blobs/{compressor}/{uncompressed_hash}/{uncompressed_size}`

    Where:
    * `instance_name` and `compressor` are defined as for uploads.
    * `uncompressed_hash` and `uncompressed_size` refer to the
    [Digest][build.bazel.remote.execution.v2.Digest] of the data being
    downloaded, once uncompressed. Clients MUST verify that these match
    the downloaded data once uncompressed, and take appropriate steps in
    the case of failure such as retrying a limited number of times or
    surfacing an error to the user.

    When downloading compressed blobs:
    * `ReadRequest.read_offset` refers to the offset in the uncompressed form
    of the blob.
    * Servers MUST return `INVALID_ARGUMENT` if `ReadRequest.read_limit` is
    non-zero.
    * Servers MAY use any compression level they choose, including different
    levels for different blobs (e.g. choosing a level designed for maximum
    speed for data known to be incompressible).
    * Clients SHOULD NOT use gRPC-level compression, since this would compress
    already-compressed data.

    Servers MUST be able to provide data for all recently advertised blobs in
    each of the compression formats that the server supports, as well as in
    uncompressed form.

    The lifetime of entries in the CAS is implementation specific, but it SHOULD
    be long enough to allow for newly-added and recently looked-up entries to be
    used in subsequent calls (e.g. to
    [Execute][build.bazel.remote.execution.v2.Execution.Execute]).

    Servers MUST behave as though empty blobs are always available, even if they
    have not been uploaded. Clients MAY optimize away the uploading or
    downloading of empty blobs.

    As with other services in the Remote Execution API, any call may return an
    error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
    information about when the client should retry the request; clients SHOULD
    respect the information provided.
    """

    @staticmethod
    def FindMissingBlobs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/build.bazel.remote.execution.v2.ContentAddressableStorage/FindMissingBlobs',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.FindMissingBlobsRequest.SerializeToString,
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.FindMissingBlobsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def BatchUpdateBlobs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchUpdateBlobs',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchUpdateBlobsRequest.SerializeToString,
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchUpdateBlobsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def BatchReadBlobs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchReadBlobs',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchReadBlobsRequest.SerializeToString,
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.BatchReadBlobsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTree(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/build.bazel.remote.execution.v2.ContentAddressableStorage/GetTree',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetTreeRequest.SerializeToString,
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetTreeResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)


class CapabilitiesStub(object):
    """The Capabilities service may be used by remote execution clients to query
    various server properties, in order to self-configure or return meaningful
    error messages.

    The query may include a particular `instance_name`, in which case the values
    returned will pertain to that instance.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetCapabilities = channel.unary_unary(
                '/build.bazel.remote.execution.v2.Capabilities/GetCapabilities',
                request_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetCapabilitiesRequest.SerializeToString,
                response_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ServerCapabilities.FromString,
                )


class CapabilitiesServicer(object):
    """The Capabilities service may be used by remote execution clients to query
    various server properties, in order to self-configure or return meaningful
    error messages.

    The query may include a particular `instance_name`, in which case the values
    returned will pertain to that instance.
    """

    def GetCapabilities(self, request, context):
        """GetCapabilities returns the server capabilities configuration of the
        remote endpoint.
        Only the capabilities of the services supported by the endpoint will
        be returned:
        * Execution + CAS + Action Cache endpoints should return both
        CacheCapabilities and ExecutionCapabilities.
        * Execution only endpoints should return ExecutionCapabilities.
        * CAS + Action Cache only endpoints should return CacheCapabilities.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_CapabilitiesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetCapabilities': grpc.unary_unary_rpc_method_handler(
                    servicer.GetCapabilities,
                    request_deserializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetCapabilitiesRequest.FromString,
                    response_serializer=build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ServerCapabilities.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'build.bazel.remote.execution.v2.Capabilities', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Capabilities(object):
    """The Capabilities service may be used by remote execution clients to query
    various server properties, in order to self-configure or return meaningful
    error messages.

    The query may include a particular `instance_name`, in which case the values
    returned will pertain to that instance.
    """

    @staticmethod
    def GetCapabilities(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/build.bazel.remote.execution.v2.Capabilities/GetCapabilities',
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.GetCapabilitiesRequest.SerializeToString,
            build_dot_bazel_dot_remote_dot_execution_dot_v2_dot_remote__execution__pb2.ServerCapabilities.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
