/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.database.serialize.SupportsNullSerializer;
import java.lang.reflect.Array;

public abstract class ArraySerializer
implements SupportsNullSerializer {
    protected abstract Object getArray(int var1);

    protected abstract void setArray(Object var1, int var2, Object var3);

    <T> T convertInternal(Object value, Class primitiveClass, Class boxedClass) {
        if (value == null) {
            return null;
        }
        if (primitiveClass != null && value.getClass().isArray() && value.getClass().getComponentType().equals(primitiveClass)) {
            return (T)value;
        }
        int size = this.isIterableOf(value, boxedClass);
        if (size >= 0) {
            Object array = this.getArray(size);
            int pos = 0;
            for (Object element : (Iterable)value) {
                this.setArray(array, pos++, element);
            }
            return (T)array;
        }
        size = this.isArrayOf(value, boxedClass);
        if (size >= 0) {
            Object array = this.getArray(size);
            for (int i = 0; i < size; ++i) {
                this.setArray(array, i, Array.get(value, i));
            }
            return (T)array;
        }
        return null;
    }

    protected int isIterableOf(Object value, Class boxedClass) {
        if (!(value instanceof Iterable)) {
            return -1;
        }
        Iterable c = (Iterable)value;
        int size = 0;
        for (Object element : c) {
            if (element == null || !element.getClass().equals(boxedClass)) {
                return -1;
            }
            ++size;
        }
        return size;
    }

    protected int isArrayOf(Object value, Class boxedClass) {
        if (!value.getClass().isArray() || !value.getClass().getComponentType().equals(boxedClass)) {
            return -1;
        }
        for (int i = 0; i < Array.getLength(value); ++i) {
            if (Array.get(value, i) == null) {
                return -1;
            }
            assert (Array.get(value, i).getClass().equals(boxedClass));
        }
        return Array.getLength(value);
    }

    protected int getLength(ScanBuffer buffer) {
        long length = VariableLong.readPositive(buffer) - 1L;
        Preconditions.checkArgument((length >= -1L && length <= Integer.MAX_VALUE ? 1 : 0) != 0);
        return (int)length;
    }

    protected void writeLength(WriteBuffer buffer, Object array) {
        if (array == null) {
            VariableLong.writePositive(buffer, 0L);
        } else {
            long length = (long)Array.getLength(array) + 1L;
            assert (length > 0L);
            VariableLong.writePositive(buffer, length);
        }
    }
}

