/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util.time;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.ZeroDuration;
import java.util.concurrent.TimeUnit;

public class Timer {
    private final TimestampProvider times;
    private Timepoint start;
    private Timepoint stop;

    public Timer(TimestampProvider times) {
        this.times = times;
    }

    public Timer start() {
        Preconditions.checkState((null == this.start ? 1 : 0) != 0, (Object)"Timer can only be started once");
        this.start = this.times.getTime();
        return this;
    }

    public long getStartTime(TimeUnit u) {
        Preconditions.checkState((null != this.start ? 1 : 0) != 0, (Object)"Timer never started");
        return this.start.getTimestamp(u);
    }

    public Timepoint getStartTime() {
        Preconditions.checkState((null != this.start ? 1 : 0) != 0, (Object)"Timer never started");
        return this.start;
    }

    public Timer stop() {
        Preconditions.checkState((null != this.start ? 1 : 0) != 0, (Object)"Timer stopped before it was started");
        this.stop = this.times.getTime();
        return this;
    }

    public Duration elapsed() {
        if (null == this.start) {
            return ZeroDuration.INSTANCE;
        }
        Timepoint stopTime = null == this.stop ? this.times.getTime() : this.stop;
        return new StandardDuration(stopTime.getNativeTimestamp() - this.start.getNativeTimestamp(), this.times.getUnit());
    }

    public String toString() {
        TimeUnit u = this.times.getUnit();
        if (this.start == null) {
            return "Initialized";
        }
        if (this.stop == null) {
            return String.format("Started at %d %s", new Object[]{this.start.getNativeTimestamp(), u});
        }
        return String.format("%d %s", new Object[]{this.stop.getNativeTimestamp() - this.start.getNativeTimestamp(), u});
    }
}

