/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.log.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.log.Message;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class AbstractMessage
implements Message {
    private static final int MAX_PAYLOAD_STR_LENGTH = 400;
    private final StaticBuffer content;
    private final Timepoint timestamp;
    private final String senderId;

    protected AbstractMessage(StaticBuffer content, Timepoint timestamp, String senderId) {
        Preconditions.checkArgument((content != null && senderId != null ? 1 : 0) != 0);
        this.content = content;
        this.timestamp = timestamp;
        this.senderId = senderId;
    }

    @Override
    public String getSenderId() {
        return this.senderId;
    }

    public Timepoint getTimestampMicro() {
        return this.timestamp;
    }

    @Override
    public long getTimestamp(TimeUnit unit) {
        return this.timestamp.getTimestamp(unit);
    }

    @Override
    public StaticBuffer getContent() {
        return this.content;
    }

    public String toString() {
        String paystr = this.content.toString();
        if (paystr.length() > 400) {
            paystr = paystr.substring(0, 400) + "...";
        }
        return "Message@" + this.timestamp + ":" + this.senderId + "=" + paystr;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.content).append((Object)this.timestamp).append((Object)this.senderId).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        AbstractMessage msg = (AbstractMessage)other;
        return this.timestamp.equals(msg.timestamp) && this.senderId.equals(msg.senderId) && this.content.equals(msg.content);
    }
}

