/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.util.time.Timer;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ReflectiveConfigOptionLoader {
    INSTANCE;

    private static final String SYS_PROP_NAME = "titan.load.cfg.opts";
    private static final String ENV_VAR_NAME = "TITAN_LOAD_CFG_OPTS";
    private static final Logger log;
    private volatile LoaderConfiguration cfg = new LoaderConfiguration();

    public ReflectiveConfigOptionLoader setUseThreadContextLoader(boolean b) {
        this.cfg = this.cfg.setUseThreadContextLoader(b);
        return this;
    }

    public ReflectiveConfigOptionLoader setUseCallerLoader(boolean b) {
        this.cfg = this.cfg.setUseCallerLoader(b);
        return this;
    }

    public ReflectiveConfigOptionLoader setPreferredClassLoaders(List<ClassLoader> loaders) {
        this.cfg = this.cfg.setPreferredClassLoaders((List<ClassLoader>)ImmutableList.copyOf(loaders));
        return this;
    }

    public ReflectiveConfigOptionLoader setEnabled(boolean enabled) {
        this.cfg = this.cfg.setEnabled(enabled);
        return this;
    }

    public ReflectiveConfigOptionLoader reset() {
        this.cfg = new LoaderConfiguration();
        return this;
    }

    public void loadAll(Class<?> caller) {
        LoaderConfiguration cfg = this.cfg;
        if (!cfg.enabled || cfg.allInit) {
            return;
        }
        this.load(cfg, caller);
        cfg.allInit = true;
    }

    public void loadStandard(Class<?> caller) {
        LoaderConfiguration cfg = this.cfg;
        if (!cfg.enabled || cfg.standardInit || cfg.allInit) {
            return;
        }
        ImmutableList classnames = ImmutableList.of((Object)"com.thinkaurelius.titan.diskstorage.hbase.HBaseStoreManager", (Object)"com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager", (Object)"com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager", (Object)"com.thinkaurelius.titan.diskstorage.cassandra.thrift.CassandraThriftStoreManager", (Object)"com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex", (Object)"com.thinkaurelius.titan.diskstorage.solr.SolrIndex", (Object)"com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLog", (Object)"com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLogManager", (Object)"com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration", (Object)"com.thinkaurelius.titan.graphdb.database.idassigner.placement.SimpleBulkPlacementStrategy", (Object)"com.thinkaurelius.titan.graphdb.database.idassigner.VertexIDAssigner", (Object)"com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEStoreManager", (Object[])new String[0]);
        Timer t = new Timer(Timestamps.MILLI);
        t.start();
        List<ClassLoader> loaders = this.getClassLoaders(cfg, caller);
        boolean foundLoader = false;
        ClassLoader cl = null;
        int loadedClasses = 0;
        block4: for (String c : classnames) {
            if (foundLoader) {
                try {
                    Class.forName(c, true, cl);
                    ++loadedClasses;
                    log.debug("Loaded class {} with selected loader {}", (Object)c, cl);
                }
                catch (Throwable e) {
                    log.debug("Unable to load class {} with selected loader {}", new Object[]{c, cl, e});
                }
                continue;
            }
            Iterator<ClassLoader> iterator = loaders.iterator();
            while (iterator.hasNext()) {
                ClassLoader candidate;
                cl = candidate = iterator.next();
                try {
                    Class.forName(c, true, cl);
                    ++loadedClasses;
                    log.debug("Loaded class {} with loader {}", (Object)c, (Object)cl);
                    log.debug("Located functioning classloader {}; using it for remaining classload attempts", (Object)cl);
                    foundLoader = true;
                    continue block4;
                }
                catch (Throwable e) {
                    log.debug("Unable to load class {} with loader {}", new Object[]{c, cl, e});
                }
            }
        }
        log.info("Loaded and initialized config classes: {} OK out of {} attempts in {}", new Object[]{loadedClasses, classnames.size(), t.elapsed()});
        cfg.standardInit = true;
    }

    private List<ClassLoader> getClassLoaders(LoaderConfiguration cfg, Class<?> caller) {
        ClassLoader c;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)cfg.preferredLoaders);
        for (ClassLoader c2 : cfg.preferredLoaders) {
            log.debug("Added preferred classloader to config option loader chain: {}", (Object)c2);
        }
        if (cfg.useThreadContextLoader) {
            c = Thread.currentThread().getContextClassLoader();
            builder.add((Object)c);
            log.debug("Added thread context classloader to config option loader chain: {}", (Object)c);
        }
        if (cfg.useCallerLoader) {
            c = caller.getClassLoader();
            builder.add((Object)c);
            log.debug("Added caller classloader to config option loader chain: {}", (Object)c);
        }
        return builder.build();
    }

    private synchronized void load(LoaderConfiguration cfg, Class<?> caller) {
        try {
            this.loadAllClassesUnsafe(cfg, caller);
        }
        catch (Throwable t) {
            log.error("Failed to iterate over classpath using Reflections; this usually indicates a broken classpath/classloader", PreInitializeConfigOptions.class, (Object)t);
        }
    }

    private void loadAllClassesUnsafe(LoaderConfiguration cfg, Class<?> caller) {
        int loadCount = 0;
        int errorCount = 0;
        List<ClassLoader> loaderList = this.getClassLoaders(cfg, caller);
        Set<URL> scanUrls = this.forClassLoaders(loaderList);
        Iterator i = scanUrls.iterator();
        while (i.hasNext()) {
            File f = new File(((URL)i.next()).getPath());
            if (!f.exists() || !f.canRead()) {
                log.trace("Skipping nonexistent or unreadable classpath element {}", (Object)f);
                i.remove();
            }
            log.trace("Retaining classpath element {}", (Object)f);
        }
        ConfigurationBuilder rc = new ConfigurationBuilder().setUrls(scanUrls).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)rc);
        for (Class c : reflections.getTypesAnnotatedWith(PreInitializeConfigOptions.class)) {
            try {
                loadCount += this.loadSingleClassUnsafe(c);
            }
            catch (Throwable t) {
                log.warn("Failed to load class {} or its referenced types; this usually indicates a broken classpath/classloader", (Object)c, (Object)t);
                ++errorCount;
            }
        }
        log.debug("Preloaded {} config option(s) via Reflections ({} class(es) with errors)", (Object)loadCount, (Object)errorCount);
    }

    private Set<URL> forClassLoaders(List<ClassLoader> loaders) {
        HashSet result = Sets.newHashSet();
        Iterator<ClassLoader> iterator = loaders.iterator();
        while (iterator.hasNext()) {
            for (ClassLoader classLoader = iterator.next(); classLoader != null; classLoader = classLoader.getParent()) {
                Object[] urls;
                if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
                result.addAll(Sets.newHashSet((Object[])urls));
            }
        }
        return result;
    }

    private int loadSingleClassUnsafe(Class<?> c) {
        int loadCount = 0;
        log.trace("Looking for ConfigOption public static fields on class {}", c);
        for (Field f : c.getDeclaredFields()) {
            boolean pub = Modifier.isPublic(f.getModifiers());
            boolean stat = Modifier.isStatic(f.getModifiers());
            boolean typeMatch = ConfigOption.class.isAssignableFrom(f.getType());
            log.trace("Properties for field \"{}\": public={} static={} assignable={}", new Object[]{f, pub, stat, typeMatch});
            if (!pub || !stat || !typeMatch) continue;
            try {
                Object o = f.get(null);
                Preconditions.checkNotNull((Object)o);
                log.debug("Initialized {}={}", (Object)f, o);
                ++loadCount;
            }
            catch (IllegalArgumentException e) {
                log.warn("ConfigOption initialization error", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn("ConfigOption initialization error", (Throwable)e);
            }
        }
        return loadCount;
    }

    static {
        log = LoggerFactory.getLogger(ReflectiveConfigOptionLoader.class);
    }

    private static class LoaderConfiguration {
        private static final Logger log = LoggerFactory.getLogger(LoaderConfiguration.class);
        private final boolean enabled;
        private final List<ClassLoader> preferredLoaders;
        private final boolean useCallerLoader;
        private final boolean useThreadContextLoader;
        private volatile boolean allInit = false;
        private volatile boolean standardInit = false;

        private LoaderConfiguration(boolean enabled, List<ClassLoader> preferredLoaders, boolean useCallerLoader, boolean useThreadContextLoader) {
            this.enabled = enabled;
            this.preferredLoaders = preferredLoaders;
            this.useCallerLoader = useCallerLoader;
            this.useThreadContextLoader = useThreadContextLoader;
        }

        private LoaderConfiguration() {
            this.enabled = this.getEnabledByDefault();
            this.preferredLoaders = ImmutableList.of((Object)ReflectiveConfigOptionLoader.class.getClassLoader());
            this.useCallerLoader = true;
            this.useThreadContextLoader = true;
        }

        private boolean getEnabledByDefault() {
            List<String> sources = Arrays.asList(System.getProperty(ReflectiveConfigOptionLoader.SYS_PROP_NAME), System.getenv(ReflectiveConfigOptionLoader.ENV_VAR_NAME));
            for (String setting : sources) {
                if (null == setting) continue;
                boolean enabled = setting.equalsIgnoreCase("true");
                log.debug("Option loading enabled={}", (Object)enabled);
                return enabled;
            }
            log.debug("Option loading enabled by default");
            return true;
        }

        LoaderConfiguration setEnabled(boolean b) {
            return new LoaderConfiguration(b, this.preferredLoaders, this.useCallerLoader, this.useThreadContextLoader);
        }

        LoaderConfiguration setPreferredClassLoaders(List<ClassLoader> cl) {
            return new LoaderConfiguration(this.enabled, cl, this.useCallerLoader, this.useThreadContextLoader);
        }

        LoaderConfiguration setUseCallerLoader(boolean b) {
            return new LoaderConfiguration(this.enabled, this.preferredLoaders, b, this.useThreadContextLoader);
        }

        LoaderConfiguration setUseThreadContextLoader(boolean b) {
            return new LoaderConfiguration(this.enabled, this.preferredLoaders, this.useCallerLoader, b);
        }
    }
}

