/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregateStore<V extends Store>
implements Store {
    protected List<V> stores = new ArrayList<V>();

    public AggregateStore(V ... stores) {
        for (V s : stores) {
            this.stores.add(s);
        }
    }

    public List<V> stores() {
        return this.stores;
    }

    public void addStore(V store) {
        this.stores.add(store);
    }

    protected void checkValid() {
        if (0 == this.stores.size()) {
            throw new GeneralException("Error: Aggregate store is empty. There must be at least one store in the aggregate.");
        }
    }

    public V defaultStore() {
        this.checkValid();
        return (V)((Store)this.stores.get(0));
    }

    public Identifiable create() {
        return this.defaultStore().create();
    }

    public void update(Identifiable value) {
        this.checkValid();
        for (Store s : this.stores) {
            if (!s.containsKey((Object)value.getIdentifier())) continue;
            s.update(value);
            return;
        }
        throw new GeneralException("Error: cannot update non-existent object. You must register it first");
    }

    public void register(Identifiable value) {
        for (Store s : this.stores) {
            if (!s.containsKey((Object)value.getIdentifier())) continue;
            return;
        }
        this.defaultStore().register(value);
    }

    public void save(Identifiable value) {
        for (Store s : this.stores) {
            try {
                if (!s.containsKey((Object)value.getIdentifier())) continue;
                s.save(value);
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.defaultStore().save(value);
    }

    public int size() {
        int x = 0;
        for (Store s : this.stores) {
            x += s.size();
        }
        return x;
    }

    public boolean isEmpty() {
        return this.size() != 0;
    }

    public boolean containsKey(Object key) {
        for (Store s : this.stores) {
            if (!s.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        for (Store s : this.stores) {
            if (!s.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        for (Store s : this.stores) {
            try {
                Object obj = s.get(key);
                if (obj == null) continue;
                return obj;
            }
            catch (Throwable t) {
            }
        }
        return null;
    }

    public Object put(Object key, Object value) {
        for (Store s : this.stores) {
            if (!s.containsKey(key)) continue;
            return s.put(key, value);
        }
        return this.defaultStore().put(key, value);
    }

    public Object remove(Object key) {
        Object obj = null;
        for (Store s : this.stores) {
            Object obj2 = s.remove(key);
            if (obj2 == null) continue;
            obj = obj2;
        }
        return obj;
    }

    public void putAll(Map m) {
        for (Object obj : m.keySet()) {
            Identifier identifier = (Identifier)obj;
            this.put(identifier, m.get(identifier));
        }
    }

    public void clear() {
        for (Store s : this.stores) {
            s.clear();
        }
    }

    public Set keySet() {
        HashSet set = new HashSet();
        for (Store s : this.stores) {
            set.addAll(s.keySet());
        }
        return set;
    }

    public Collection values() {
        HashSet set = new HashSet();
        for (Store s : this.stores) {
            set.addAll(s.values());
        }
        return set;
    }

    public Set entrySet() {
        HashSet set = new HashSet();
        for (Store s : this.stores) {
            set.addAll(s.entrySet());
        }
        return set;
    }
}

