/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.tenant.TenantIdKey;

public class TenantCache {
    private static Log log = LogFactory.getLog(TenantCache.class);
    public static final String TENANT_CACHE_MANAGER = "TENANT_CACHE_MANAGER";
    public static final String TENANT_CACHE = "TENANT_CACHE";
    private static TenantCache tenantCache = new TenantCache();

    private TenantCache() {
    }

    public static synchronized TenantCache getInstance() {
        return tenantCache;
    }

    private <T> Cache<TenantIdKey, T> getTenantCache() {
        Cache cache = null;
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(TENANT_CACHE_MANAGER);
        cache = cacheManager.getCache(TENANT_CACHE);
        return cache;
    }

    public <T> void addToCache(TenantIdKey key, T entry) {
        this.clearCacheEntry(key);
        Cache<TenantIdKey, T> cache = this.getTenantCache();
        if (cache != null) {
            cache.put((Object)key, entry);
            log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, added the entry : " + entry + " for the key : " + key + " successfully"));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Error while getting the cache : TENANT_CACHE which is under TENANT_CACHE_MANAGER");
        }
    }

    public <T> T getValueFromCache(TenantIdKey key) {
        Cache<TenantIdKey, T> cache = this.getTenantCache();
        if (cache != null) {
            if (cache.containsKey((Object)key)) {
                Object entry = cache.get((Object)key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, found the entry : " + entry + " for the key : " + key + " successfully"));
                }
                return (T)entry;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, doesn't contain the key : " + key));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Error while getting the cache : TENANT_CACHE which is under TENANT_CACHE_MANAGER");
        }
        return null;
    }

    public void clearCacheEntry(TenantIdKey key) {
        Cache cache = this.getTenantCache();
        if (cache != null) {
            if (cache.containsKey((Object)key)) {
                cache.remove((Object)key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, is removed entry for the key : " + key + " successfully"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, doen't contain the key : " + key));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Error while getting the cache : TENANT_CACHE which is under TENANT_CACHE_MANAGER");
        }
    }

    public void clear() {
        Cache cache = this.getTenantCache();
        if (cache != null) {
            cache.removeAll();
            if (log.isDebugEnabled()) {
                log.debug((Object)"TENANT_CACHE which is under TENANT_CACHE_MANAGER, is cleared successfully");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Error while getting the cache : TENANT_CACHE which is under TENANT_CACHE_MANAGER");
        }
    }
}

