/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.jdbc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.dto.RoleDTO;
import org.wso2.carbon.user.core.jdbc.JDBCRoleContext;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreConstants;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JDBCRealmUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class JDBCUserStoreManager
extends AbstractUserStoreManager {
    protected DataSource jdbcds;
    protected Random random;
    private static Log log = LogFactory.getLog(JDBCUserStoreManager.class);

    private DataSource getJDBCDataSource() throws UserStoreException {
        if (this.jdbcds == null) {
            this.jdbcds = this.loadUserStoreSpacificDataSoruce();
        }
        return this.jdbcds;
    }

    public JDBCUserStoreManager() {
        this.jdbcds = null;
        this.random = new Random();
    }

    public JDBCUserStoreManager(RealmConfiguration realmConfig, int tenantId) throws UserStoreException {
        this.jdbcds = null;
        this.random = new Random();
        this.realmConfig = realmConfig;
        this.tenantId = tenantId;
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        if (realmConfig.getUserStoreProperty("ReadGroups") != null) {
            this.readGroupsEnabled = Boolean.parseBoolean(realmConfig.getUserStoreProperty("ReadGroups"));
        }
        if (realmConfig.getUserStoreProperty("WriteGroups") != null) {
            this.writeGroupsEnabled = Boolean.parseBoolean(realmConfig.getUserStoreProperty("WriteGroups"));
        } else if (!this.isReadOnly()) {
            this.writeGroupsEnabled = true;
        }
        if (realmConfig.getUserStoreProperty("InternalJDBCRolesOnly") != null) {
            boolean internalRolesOnly = Boolean.parseBoolean(realmConfig.getUserStoreProperty("InternalJDBCRolesOnly"));
            if (internalRolesOnly) {
                this.readGroupsEnabled = false;
                this.writeGroupsEnabled = false;
            } else {
                this.readGroupsEnabled = true;
                this.writeGroupsEnabled = true;
            }
        }
        if (this.writeGroupsEnabled) {
            this.readGroupsEnabled = true;
        }
        this.initUserRolesCache();
    }

    public JDBCUserStoreManager(DataSource ds, RealmConfiguration realmConfig, int tenantId, boolean addInitData) throws UserStoreException {
        this(realmConfig, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + System.currentTimeMillis()));
        }
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        this.jdbcds = ds;
        this.dataSource = ds;
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("User Management Data Source is null");
        }
        this.doInitialSetup();
        this.persistDomain();
        if (realmConfig.isPrimary()) {
            this.addInitialAdminData(Boolean.parseBoolean(realmConfig.getAddAdmin()), !this.isInitSetupDone());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended " + System.currentTimeMillis()));
        }
    }

    public JDBCUserStoreManager(DataSource ds, RealmConfiguration realmConfig) throws UserStoreException {
        this(realmConfig, -1234);
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        this.jdbcds = ds;
    }

    public JDBCUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        this(realmConfig, properties, claimManager, profileManager, realm, tenantId, false);
    }

    public JDBCUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId, boolean skipInitData) throws UserStoreException {
        block10: {
            this(realmConfig, tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Started " + System.currentTimeMillis()));
            }
            this.claimManager = claimManager;
            this.userRealm = realm;
            try {
                this.jdbcds = this.loadUserStoreSpacificDataSoruce();
                if (this.jdbcds == null) {
                    this.jdbcds = (DataSource)properties.get("um.datasource");
                }
                if (this.jdbcds == null) {
                    this.jdbcds = DatabaseUtil.getRealmDataSource(realmConfig);
                    properties.put("um.datasource", this.jdbcds);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The jdbcDataSource being used by JDBCUserStoreManager :: " + this.jdbcds.hashCode()));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)"Loading JDBC datasource failed", (Throwable)e);
            }
        }
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("User Management Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        this.persistDomain();
        this.doInitialSetup();
        if (realmConfig.isPrimary()) {
            this.addInitialAdminData(Boolean.parseBoolean(realmConfig.getAddAdmin()), !this.isInitSetupDone());
        }
        this.initUserRolesCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended " + System.currentTimeMillis()));
        }
    }

    @Override
    public String[] doListUsers(String filter, int maxItemLimit) throws UserStoreException {
        Object[] users = new String[]{};
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        if (maxItemLimit == 0) {
            return new String[0];
        }
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        if (filter != null && filter.trim().length() != 0) {
            filter = filter.trim();
            filter = filter.replace("*", "%");
            filter = filter.replace("?", "_");
        } else {
            filter = "%";
        }
        LinkedList<String> lst = new LinkedList<String>();
        dbConnection = this.getDBConnection();
        if (dbConnection == null) {
            throw new UserStoreException("null connection");
        }
        dbConnection.setAutoCommit(false);
        dbConnection.setTransactionIsolation(2);
        sqlStmt = this.realmConfig.getUserStoreProperty("UserFilterSQL");
        prepStmt = dbConnection.prepareStatement(sqlStmt);
        prepStmt.setString(1, filter);
        if (sqlStmt.contains("UM_TENANT_ID")) {
            prepStmt.setInt(2, this.tenantId);
        }
        prepStmt.setMaxRows(maxItemLimit);
        try {
            prepStmt.setQueryTimeout(searchTime);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        try {
            rs = prepStmt.executeQuery();
        }
        catch (SQLException e) {
            log.error((Object)e);
            Object[] objectArray = users;
            DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
            return objectArray;
        }
        try {
            while (rs.next()) {
                String name = rs.getString(1);
                if ("wso2.anonymous.user".equals(name)) continue;
                String domain = this.realmConfig.getUserStoreProperty("DomainName");
                name = UserCoreUtil.addDomainToName(name, domain);
                lst.add(name);
            }
            rs.close();
            if (lst.size() > 0) {
                users = lst.toArray(new String[lst.size()]);
            }
            Arrays.sort(users);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return users;
    }

    @Override
    public boolean doCheckIsUserInRole(String userName, String roleName) throws UserStoreException {
        String[] roles = this.doGetExternalRoleListOfUser(userName, "*");
        if (roles != null) {
            for (String role : roles) {
                if (!role.equalsIgnoreCase(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String[] doGetDisplayNamesForInternalRole(String[] userNames) throws UserStoreException {
        return userNames;
    }

    @Override
    public String[] doGetRoleNames(String filter, int maxItemLimit) throws UserStoreException {
        String[] roles = new String[]{};
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        if (maxItemLimit == 0) {
            return roles;
        }
        try {
            if (filter != null && filter.trim().length() != 0) {
                filter = filter.trim();
                filter = filter.replace("*", "%");
                filter = filter.replace("?", "_");
            } else {
                filter = "%";
            }
            LinkedList<String> lst = new LinkedList<String>();
            dbConnection = this.getDBConnection();
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            dbConnection.setAutoCommit(false);
            dbConnection.setTransactionIsolation(2);
            sqlStmt = this.realmConfig.getUserStoreProperty("GetRoleListSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int count = 0;
            count = (byte)(count + 1);
            prepStmt.setString(count, filter);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                count = (byte)(count + 1);
                prepStmt.setInt(count, this.tenantId);
            }
            this.setPSRestrictions(prepStmt, maxItemLimit);
            try {
                rs = prepStmt.executeQuery();
            }
            catch (SQLException e) {
                log.error((Object)"Error while retrieving roles from JDBC user store", (Throwable)e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String domain = this.realmConfig.getUserStoreProperty("DomainName");
                    name = UserCoreUtil.addDomainToName(name, domain);
                    lst.add(name);
                }
            }
            if (lst.size() > 0) {
                roles = lst.toArray(new String[lst.size()]);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return roles;
    }

    private void setPSRestrictions(PreparedStatement ps, int maxItemLimit) throws SQLException {
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxRoleNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        ps.setMaxRows(maxItemLimit);
        try {
            ps.setQueryTimeout(searchTime);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    @Override
    protected String[] doGetSharedRoleNames(String tenantDomain, String filter, int maxItemLimit) throws UserStoreException {
        ResultSet rs;
        PreparedStatement prepStmt;
        String sqlStmt;
        Connection dbConnection;
        String[] roles;
        block14: {
            roles = new String[]{};
            dbConnection = null;
            sqlStmt = null;
            prepStmt = null;
            rs = null;
            if (maxItemLimit == 0) {
                return roles;
            }
            if (this.isSharedGroupEnabled()) break block14;
            String[] stringArray = roles;
            DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
            return stringArray;
        }
        try {
            if (filter != null && filter.trim().length() != 0) {
                filter = filter.trim();
                filter = filter.replace("*", "%");
                filter = filter.replace("?", "_");
            } else {
                filter = "%";
            }
            LinkedList<String> lst = new LinkedList<String>();
            dbConnection = this.getDBConnection();
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            dbConnection.setAutoCommit(false);
            dbConnection.setTransactionIsolation(2);
            sqlStmt = this.realmConfig.getUserStoreProperty("GetSharedRoleListSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int count = 0;
            count = (byte)(count + 1);
            prepStmt.setString(count, filter);
            this.setPSRestrictions(prepStmt, maxItemLimit);
            try {
                rs = prepStmt.executeQuery();
            }
            catch (SQLException e) {
                log.error((Object)"Error while retrieving roles from JDBC user store", (Throwable)e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    int roleTenantId = rs.getInt(2);
                    String domain = this.realmConfig.getUserStoreProperty("DomainName");
                    name = UserCoreUtil.addDomainToName(name, domain);
                    name = UserCoreUtil.addTenantDomainToEntry(name, String.valueOf(roleTenantId));
                    lst.add(name);
                }
            }
            if (lst.size() > 0) {
                roles = lst.toArray(new String[lst.size()]);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return roles;
    }

    @Override
    public String[] doGetUserListOfRole(String roleName, String filter) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.getUserListOfJDBCRole(roleContext, filter);
    }

    public String[] getUserListOfJDBCRole(RoleContext ctx, String filter) throws UserStoreException {
        String roleName = ctx.getRoleName();
        String[] names = null;
        String sqlStmt = null;
        if (!ctx.isShared()) {
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserListOfRoleSQL");
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for retrieving user roles is null");
            }
            names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, roleName, this.tenantId, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, roleName);
        } else if (ctx.isShared()) {
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserListOfSharedRoleSQL");
            names = this.getStringValuesFromDatabase(sqlStmt, roleName);
        }
        ArrayList<String> userList = new ArrayList<String>();
        String domainName = this.realmConfig.getUserStoreProperty("DomainName");
        if (names != null) {
            for (String user : names) {
                user = UserCoreUtil.addDomainToName(user, domainName);
                userList.add(user);
            }
            names = userList.toArray(new String[userList.size()]);
        }
        log.debug((Object)("Roles are not defined for the role name " + roleName));
        return names;
    }

    @Override
    public boolean doCheckExistingRole(String roleName) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.isExistingJDBCRole(roleContext);
    }

    protected boolean isExistingJDBCRole(RoleContext context) throws UserStoreException {
        String roleName = context.getRoleName();
        String sqlStmt = this.realmConfig.getUserStoreProperty("IsRoleExistingSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for is role existing role null");
        }
        boolean isExisting = sqlStmt.contains("UM_TENANT_ID") ? this.isValueExisting(sqlStmt, null, roleName, ((JDBCRoleContext)context).getTenantId()) : this.isValueExisting(sqlStmt, null, roleName);
        return isExisting;
    }

    @Override
    public String[] getAllProfileNames() throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetProfileNamesSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving profile names is null");
        }
        String[] names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, new Object[0]);
        return names;
    }

    @Override
    public String[] getProfileNames(String userName) throws UserStoreException {
        userName = UserCoreUtil.removeDomainFromName(userName);
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserProfileNamesSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving  is null");
        }
        Object[] names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userName, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, userName);
        if (names.length == 0) {
            names = new String[]{"default"};
        } else {
            Arrays.sort(names);
            if (Arrays.binarySearch(names, "default") < 0) {
                String[] newNames = new String[names.length + 1];
                int i = 0;
                for (i = 0; i < names.length; ++i) {
                    newNames[i] = names[i];
                }
                newNames[i] = "default";
                names = newNames;
            }
        }
        return names;
    }

    @Override
    public int getUserId(String username) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserIDFromUserNameSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving ID is null");
        }
        int id = -1;
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            id = sqlStmt.contains("UM_TENANT_ID") ? DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username, this.tenantId) : DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username);
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return id;
    }

    public String[] getUserNames(int tenantId) throws UserStoreException {
        String[] userNames;
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserNameFromTenantIDSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving user names is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            userNames = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, tenantId);
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return userNames;
    }

    public String getAdminUser() throws UserStoreException {
        String[] users = this.getUserListOfRole(this.realmConfig.getAdminRoleName());
        if (users != null && users.length > 0) {
            return users[0];
        }
        return null;
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantId;
    }

    public Map<String, String> getProperties(Tenant tenant) throws org.wso2.carbon.user.api.UserStoreException {
        return this.getProperties((org.wso2.carbon.user.core.tenant.Tenant)tenant);
    }

    @Override
    public int getTenantId(String username) throws UserStoreException {
        if (this.tenantId != -1234) {
            throw new UserStoreException("Not allowed to perform this operation");
        }
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetTenantIDFromUserNameSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving ID is null");
        }
        int id = -1;
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            id = DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username);
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return id;
    }

    @Override
    public Map<String, String> getUserPropertyValues(String userName, String[] propertyNames, String profileName) throws UserStoreException {
        Object name;
        if (profileName == null) {
            profileName = "default";
        }
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Object[] propertyNamesSorted = (String[])propertyNames.clone();
        Arrays.sort(propertyNamesSorted);
        HashMap<Object, String> map = new HashMap<Object, String>();
        try {
            dbConnection = this.getDBConnection();
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserPropertiesForProfileSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userName);
            prepStmt.setString(2, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(3, this.tenantId);
                prepStmt.setInt(4, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                name = rs.getString(1);
                String value = rs.getString(2);
                if (Arrays.binarySearch(propertyNamesSorted, name) < 0) continue;
                map.put(name, value);
            }
            name = map;
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return name;
    }

    private String[] getStringValuesFromDatabase(String sqlStmt, Object ... params) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execuring Query: " + sqlStmt));
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                log.debug((Object)("Input value: " + param));
            }
        }
        String[] values = new String[]{};
        Connection dbConnection = null;
        Object prepStmt = null;
        ResultSet rs = null;
        try {
            dbConnection = this.getDBConnection();
            values = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, params);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return values;
    }

    private String[] getRoleNamesWithDomain(String sqlStmt, String userName, int tenantId, boolean appendDn) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> roles = new ArrayList<String>();
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int count = 0;
            count = (byte)(count + 1);
            prepStmt.setString(count, userName);
            count = (byte)(count + 1);
            prepStmt.setInt(count, tenantId);
            rs = prepStmt.executeQuery();
            String domain = this.realmConfig.getUserStoreProperty("DomainName");
            while (rs.next()) {
                String name = rs.getString(1);
                int tenant = rs.getInt(2);
                String role = name;
                if (appendDn) {
                    name = UserCoreUtil.addTenantDomainToEntry(name, String.valueOf(tenant));
                }
                roles.add(role);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return roles.toArray(new String[roles.size()]);
    }

    protected Connection getDBConnection() throws SQLException, UserStoreException {
        Connection dbConnection = this.getJDBCDataSource().getConnection();
        dbConnection.setAutoCommit(false);
        dbConnection.setTransactionIsolation(2);
        return dbConnection;
    }

    protected boolean isValueExisting(String sqlStmt, Connection dbConnection, Object ... params) throws UserStoreException {
        boolean bl;
        block7: {
            Object prepStmt = null;
            ResultSet rs = null;
            boolean isExisting = false;
            boolean doClose = false;
            try {
                if (dbConnection == null) {
                    dbConnection = this.getDBConnection();
                    doClose = true;
                }
                if (DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, params) > -1) {
                    isExisting = true;
                }
                bl = isExisting;
                if (!doClose) break block7;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Using sql : " + sqlStmt));
                    throw new UserStoreException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (doClose) {
                        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    }
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        }
        return bl;
    }

    @Override
    public boolean doCheckExistingUser(String userName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("IsUserExistingSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for is user existing null");
        }
        boolean isExisting = false;
        String isUnique = this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenants");
        if ("true".equals(isUnique) && !"wso2.anonymous.user".equals(userName)) {
            String uniquenesSql = this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenantsSQL");
            isExisting = this.isValueExisting(uniquenesSql, null, userName);
            if (log.isDebugEnabled()) {
                log.debug((Object)"The username should be unique across tenants.");
            }
        } else {
            isExisting = sqlStmt.contains("UM_TENANT_ID") ? this.isValueExisting(sqlStmt, null, userName, this.tenantId) : this.isValueExisting(sqlStmt, null, userName);
        }
        return isExisting;
    }

    @Override
    public boolean doAuthenticate(String userName, Object credential) throws UserStoreException {
        boolean isAuthed;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block14: {
            if (!this.checkUserNameValid(userName)) {
                return false;
            }
            if (!this.checkUserPasswordValid(credential)) {
                return false;
            }
            if (UserCoreUtil.isRegistryAnnonymousUser(userName)) {
                log.error((Object)"Anonnymous user trying to login");
                return false;
            }
            dbConnection = null;
            rs = null;
            prepStmt = null;
            String sqlstmt = null;
            String password = (String)credential;
            isAuthed = false;
            try {
                dbConnection = this.getDBConnection();
                dbConnection.setAutoCommit(false);
                sqlstmt = this.realmConfig.getUserStoreProperty("SelectUserSQL");
                if (log.isDebugEnabled()) {
                    log.debug((Object)sqlstmt);
                }
                prepStmt = dbConnection.prepareStatement(sqlstmt);
                prepStmt.setString(1, userName);
                if (sqlstmt.contains("UM_TENANT_ID")) {
                    prepStmt.setInt(2, this.tenantId);
                }
                if (!(rs = prepStmt.executeQuery()).next()) break block14;
                String storedPassword = rs.getString(3);
                String saltValue = null;
                if ("true".equalsIgnoreCase(this.realmConfig.getUserStoreProperty("StoreSaltedPassword"))) {
                    saltValue = rs.getString(4);
                }
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                GregorianCalendar gc = new GregorianCalendar();
                gc.add(10, -24);
                Date date = gc.getTime();
                if (requireChange && changedTime.before(date)) {
                    isAuthed = false;
                } else {
                    password = this.preparePassword(password, saltValue);
                    if (storedPassword != null && storedPassword.equals(password)) {
                        isAuthed = true;
                    }
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Using sql : " + sqlstmt));
                    throw new UserStoreException("Authentication Failure");
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User " + userName + " login attempt. Login success :: " + isAuthed));
        }
        return isAuthed;
    }

    @Override
    public boolean isReadOnly() throws UserStoreException {
        return "true".equalsIgnoreCase(this.realmConfig.getUserStoreProperty("ReadOnly"));
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        this.persistUser(userName, credential, roleList, claims, profileName, requirePasswordChange);
    }

    protected void persistUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        Connection dbConnection = null;
        String password = (String)credential;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt1 = this.realmConfig.getUserStoreProperty("AddUserSQL");
            String saltValue = null;
            if ("true".equalsIgnoreCase((String)this.realmConfig.getUserStoreProperties().get("StoreSaltedPassword"))) {
                byte[] bytes = new byte[16];
                this.random.nextBytes(bytes);
                saltValue = Base64.encode((byte[])bytes);
            }
            password = this.preparePassword(password, saltValue);
            if (sqlStmt1.contains("UM_TENANT_ID") && saltValue == null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, "", requirePasswordChange, new Date(), this.tenantId);
            } else if (sqlStmt1.contains("UM_TENANT_ID") && saltValue != null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, saltValue, requirePasswordChange, new Date(), this.tenantId);
            } else if (!sqlStmt1.contains("UM_TENANT_ID") && saltValue == null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, null, requirePasswordChange, new Date());
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, requirePasswordChange, new Date());
            }
            if (roleList != null && roleList.length > 0) {
                RoleBreakdown breakdown = this.getSharedRoleBreakdown(roleList);
                String[] roles = breakdown.getRoles();
                String[] sharedRoles = breakdown.getSharedRoles();
                Integer[] sharedTenantIds = breakdown.getSharedTenantids();
                String sqlStmt2 = null;
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                if (roles.length > 0) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserSQL-" + type);
                    if (sqlStmt2 == null) {
                        sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserSQL");
                    }
                    if (sqlStmt2.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, roles, this.tenantId, userName, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roles, this.tenantId, userName, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roleList, this.tenantId, userName);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQL");
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt2, sharedRoles, userName, sharedTenantIds, this.tenantId);
                }
            }
            if (claims != null) {
                if (profileName == null) {
                    profileName = "default";
                }
                for (Map.Entry<String, String> entry : claims.entrySet()) {
                    String claimURI = entry.getKey();
                    String propName = this.getClaimAtrribute(claimURI, userName, null);
                    String propValue = entry.getValue();
                    this.addProperty(dbConnection, userName, propName, propValue, profileName);
                }
            }
            dbConnection.commit();
        }
        catch (Throwable e) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                throw new UserStoreException("Error rollbacking add user operation", e1);
            }
            log.error((Object)("Error while persisting user : " + userName));
            throw new UserStoreException("Error while persisting user : " + userName, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doAddRole(String roleName, String[] userList, boolean shared) throws UserStoreException {
        if (shared && this.isSharedGroupEnabled()) {
            this.doAddSharedRole(roleName, userList);
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddRoleSQL");
            if (sqlStmt.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, roleName);
            }
            if (userList != null) {
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                String sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleSQL-" + type);
                if (sqlStmt2 == null) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleSQL");
                }
                if (sqlStmt2.contains("UM_TENANT_ID")) {
                    if ("openedge".equals(type)) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, userList, this.tenantId, roleName, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, userList, this.tenantId, roleName, this.tenantId, this.tenantId);
                    }
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, userList, this.tenantId, roleName);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateRoleName(String roleName, String newRoleName) throws UserStoreException {
        JDBCRoleContext ctx = (JDBCRoleContext)this.createRoleContext(roleName);
        if (this.isExistingRole(newRoleName)) {
            throw new UserStoreException("Role name: " + newRoleName + " in the system. Please pick another role name.");
        }
        String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateRoleNameSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for update role name is null");
        }
        Connection dbConnection = null;
        try {
            roleName = ctx.getRoleName();
            dbConnection = this.getDBConnection();
            if (sqlStmt.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, newRoleName, roleName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Using sql : " + sqlStmt));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public boolean isSharedRole(String roleName, String roleNameBase) {
        return roleNameBase != null && roleNameBase.indexOf("true") > -1;
    }

    private int getTenantIdFromRole(String roleBase) {
        int tenantId = -1234;
        String[] postfix = roleBase.split("~");
        if (postfix.length > 1) {
            try {
                tenantId = Integer.parseInt(postfix[1]);
            }
            catch (NumberFormatException e) {
                log.error((Object)e);
                tenantId = -1234;
            }
        }
        return tenantId;
    }

    @Override
    public boolean isBulkImportSupported() {
        return true;
    }

    @Override
    public RealmConfiguration getRealmConfiguration() {
        return this.realmConfig;
    }

    public RoleDTO[] getRoleNamesWithDomain(boolean noHybridRoles) throws UserStoreException {
        RoleDTO[] secondaryRoleDTOs;
        String[] names = null;
        String domain = this.realmConfig.getUserStoreProperty("DomainName");
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetRoleListSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving role name is null");
        }
        names = this.getStringValuesFromDatabase(sqlStmt, this.tenantId);
        if (this.isReadOnly() && !noHybridRoles) {
            String[] hybrids = this.hybridRoleManager.getHybridRoles("*");
            names = UserCoreUtil.combineArrays(names, hybrids);
        }
        ArrayList<RoleDTO> roleDTOs = new ArrayList<RoleDTO>();
        if (names != null && names.length != 0) {
            roleDTOs.addAll(Arrays.asList(UserCoreUtil.convertRoleNamesToRoleDTO(names, domain)));
        }
        if ((secondaryRoleDTOs = this.getAllSecondaryRoleDTOs()) != null && secondaryRoleDTOs.length != 0) {
            roleDTOs.addAll(Arrays.asList(secondaryRoleDTOs));
        }
        return roleDTOs.toArray(new RoleDTO[roleDTOs.size()]);
    }

    public boolean isMultipleProfilesAllowed() {
        return true;
    }

    @Override
    public void doDeleteRole(String roleName) throws UserStoreException {
        String sqlStmt1 = this.realmConfig.getUserStoreProperty("OnDeleteRoleRemoveUserRoleMappingSQL");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for delete user-role mapping is null");
        }
        String sqlStmt2 = this.realmConfig.getUserStoreProperty("DeleteRoleSQL");
        if (sqlStmt2 == null) {
            throw new UserStoreException("The sql statement for delete role is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (sqlStmt1.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, roleName, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, roleName);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, roleName);
            }
            this.userRealm.getAuthorizationManager().clearRoleAuthorization(roleName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Using sql : " + sqlStmt1));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        String sqlStmt1 = this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserRoleMappingSQL");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for delete user-role mapping is null");
        }
        String sqlStmt2 = this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserAttributeSQL");
        if (sqlStmt2 == null) {
            throw new UserStoreException("The sql statement for delete user attribute is null");
        }
        String sqlStmt3 = this.realmConfig.getUserStoreProperty("DeleteUserSQL");
        if (sqlStmt3 == null) {
            throw new UserStoreException("The sql statement for delete user is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (sqlStmt1.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, userName, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt3, userName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, userName);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt3, userName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Using sql : " + sqlStmt1 + " :: " + sqlStmt2));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        JDBCRoleContext ctx = (JDBCRoleContext)this.createRoleContext(roleName);
        roleName = ctx.getRoleName();
        int roleTenantId = ctx.getTenantId();
        boolean isShared = ctx.isShared();
        String sqlStmt1 = this.realmConfig.getUserStoreProperty(isShared ? "RemoveUserFromSharedRoleSQL" : "RemoveUserFromRoleSQL");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for remove user from role is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt2 = null;
            if (!isShared) {
                sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleSQL-" + type);
                if (sqlStmt2 == null) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddUserToRoleSQL");
                }
            } else {
                sqlStmt2 = this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQL");
            }
            if (sqlStmt2 == null) {
                throw new UserStoreException("The sql statement for add user to role is null");
            }
            if (deletedUsers != null) {
                if (isShared) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roleName, this.tenantId, deletedUsers, this.tenantId, this.tenantId, roleTenantId);
                } else if (sqlStmt1.contains("UM_TENANT_ID")) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUsers, this.tenantId, roleName, this.tenantId, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUsers, this.tenantId, roleName);
                }
            }
            if (newUsers != null) {
                if (isShared) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roleName, roleTenantId, newUsers, this.tenantId, this.tenantId, roleTenantId);
                } else if (sqlStmt1.contains("UM_TENANT_ID")) {
                    if ("openedge".equals(type)) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, newUsers, this.tenantId, roleName, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, this.tenantId, roleName, this.tenantId, this.tenantId);
                    }
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, this.tenantId, roleName);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    private RoleBreakdown getSharedRoleBreakdown(String[] rolesList) {
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<Integer> tenantIds = new ArrayList<Integer>();
        ArrayList<String> sharedRoles = new ArrayList<String>();
        ArrayList<Integer> sharedTenantIds = new ArrayList<Integer>();
        for (String role : rolesList) {
            String[] deletedRoleNames = role.split("/");
            if (deletedRoleNames.length > 1) {
                role = deletedRoleNames[1];
            }
            JDBCRoleContext ctx = (JDBCRoleContext)this.createRoleContext(role);
            role = ctx.getRoleName();
            int roleTenantId = ctx.getTenantId();
            boolean isShared = ctx.isShared();
            if (isShared) {
                sharedRoles.add(role);
                sharedTenantIds.add(roleTenantId);
                continue;
            }
            roles.add(role);
            tenantIds.add(roleTenantId);
        }
        RoleBreakdown breakdown = new RoleBreakdown();
        breakdown.setRoles(roles.toArray(new String[roles.size()]));
        breakdown.setTenantIds(tenantIds.toArray(new Integer[tenantIds.size()]));
        breakdown.setSharedRoles(sharedRoles.toArray(new String[sharedRoles.size()]));
        breakdown.setSharedTenantids(sharedTenantIds.toArray(new Integer[sharedTenantIds.size()]));
        return breakdown;
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        Connection dbConnection = null;
        try {
            Integer[] sharedTenantIds;
            String[] sharedRoles;
            String[] roles;
            RoleBreakdown breakdown;
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt2 = null;
            String[] userNames = userName.split("/");
            if (userNames.length > 1) {
                userName = userNames[1];
            }
            if (deletedRoles != null && deletedRoles.length > 0) {
                breakdown = this.getSharedRoleBreakdown(deletedRoles);
                roles = breakdown.getRoles();
                sharedRoles = breakdown.getSharedRoles();
                sharedTenantIds = breakdown.getSharedTenantids();
                String sqlStmt1 = null;
                if (roles.length > 0) {
                    sqlStmt1 = this.realmConfig.getUserStoreProperty("RemoveRoleFromUserSQL");
                    if (sqlStmt1 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null");
                    }
                    if (sqlStmt1.contains("UM_TENANT_ID")) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roles, this.tenantId, userName, this.tenantId, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roles, this.tenantId, userName);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt1 = this.realmConfig.getUserStoreProperty("RemoveUserFromSharedRoleSQL");
                    if (sqlStmt1 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null");
                    }
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt1, sharedRoles, userName, sharedTenantIds, this.tenantId);
                }
            }
            if (newRoles != null && newRoles.length > 0) {
                breakdown = this.getSharedRoleBreakdown(newRoles);
                roles = breakdown.getRoles();
                sharedRoles = breakdown.getSharedRoles();
                sharedTenantIds = breakdown.getSharedTenantids();
                if (roles.length > 0) {
                    this.realmConfig.getUserStoreProperty("AddRoleToUserSQL-" + type);
                    if (sqlStmt2 == null) {
                        sqlStmt2 = this.realmConfig.getUserStoreProperty("AddRoleToUserSQL");
                    }
                    if (sqlStmt2 == null) {
                        throw new UserStoreException("The sql statement for add user to role is null");
                    }
                    if (sqlStmt2.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, roles, this.tenantId, userName, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roles, this.tenantId, userName, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newRoles, this.tenantId, userName);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt2 = this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQL");
                    if (sqlStmt2 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null");
                    }
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt2, sharedRoles, userName, sharedTenantIds, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        if (claimValue == null) {
            throw new UserStoreException("Cannot set null values.");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String property = this.getClaimAtrribute(claimURI, userName, null);
            String value = this.getProperty(dbConnection, userName, property, profileName);
            if (value == null) {
                this.addProperty(dbConnection, userName, property, claimValue, profileName);
            } else {
                this.updateProperty(dbConnection, userName, property, claimValue, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        if (claims.get("profileConfiguration") == null) {
            claims.put("profileConfiguration", "default");
        }
        try {
            dbConnection = this.getDBConnection();
            for (Map.Entry<String, String> entry : claims.entrySet()) {
                String claimURI = entry.getKey();
                String property = this.getClaimAtrribute(claimURI, userName, null);
                String value = entry.getValue();
                String existingValue = this.getProperty(dbConnection, userName, property, profileName);
                if (existingValue == null) {
                    this.addProperty(dbConnection, userName, property, value, profileName);
                    continue;
                }
                this.updateProperty(dbConnection, userName, property, value, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            String property = null;
            property = "profileConfiguration".equals(claimURI) ? "profileConfiguration" : this.getClaimAtrribute(claimURI, userName, null);
            dbConnection = this.getDBConnection();
            this.deleteProperty(dbConnection, userName, property, profileName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
                catch (org.wso2.carbon.user.api.UserStoreException e2) {
                    throw new UserStoreException(e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            dbConnection = this.getDBConnection();
            for (String claimURI : claims) {
                String property = this.getClaimAtrribute(claimURI, userName, null);
                this.deleteProperty(dbConnection, userName, property, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        this.doUpdateCredentialByAdmin(userName, newCredential);
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        if (!this.checkUserPasswordValid(newCredential)) {
            throw new UserStoreException("Credential not valid. Credential must be a non null string with following format, " + this.realmConfig.getUserStoreProperty("PasswordJavaRegEx"));
        }
        String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPasswordSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for delete user claim value is null");
        }
        String saltValue = null;
        if ("true".equalsIgnoreCase((String)this.realmConfig.getUserStoreProperties().get("StoreSaltedPassword"))) {
            byte[] bytes = new byte[16];
            this.random.nextBytes(bytes);
            saltValue = Base64.encode((byte[])bytes);
        }
        String password = this.preparePassword((String)newCredential, saltValue);
        if (sqlStmt.contains("UM_TENANT_ID") && saltValue == null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, false, new Date(), userName, this.tenantId);
        } else if (sqlStmt.contains("UM_TENANT_ID") && saltValue != null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, saltValue, false, new Date(), userName, this.tenantId);
        } else if (!sqlStmt.contains("UM_TENANT_ID") && saltValue == null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, false, new Date(), userName);
        } else {
            this.updateStringValuesToDatabase(null, sqlStmt, password, saltValue, false, new Date(), userName);
        }
    }

    @Override
    public Date getPasswordExpirationTime(String userName) throws UserStoreException {
        Date date;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block7: {
            dbConnection = null;
            rs = null;
            prepStmt = null;
            String sqlstmt = null;
            date = null;
            try {
                dbConnection = this.getDBConnection();
                dbConnection.setAutoCommit(false);
                sqlstmt = this.realmConfig.getUserStoreProperty("SelectUserSQL");
                if (log.isDebugEnabled()) {
                    log.debug((Object)sqlstmt);
                }
                prepStmt = dbConnection.prepareStatement(sqlstmt);
                prepStmt.setString(1, userName);
                if (sqlstmt.contains("UM_TENANT_ID")) {
                    prepStmt.setInt(2, this.tenantId);
                }
                if (!(rs = prepStmt.executeQuery()).next()) break block7;
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                if (requireChange) {
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(changedTime);
                    gc.add(10, 24);
                    date = gc.getTime();
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Using sql : " + sqlstmt));
                    throw new UserStoreException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return date;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStringValuesToDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt;
        block15: {
            prepStmt = null;
            boolean localConnection = false;
            try {
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = this.getDBConnection();
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        if (param == null) {
                            throw new UserStoreException("Invalid data provided");
                        }
                        if (param instanceof String) {
                            prepStmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (param instanceof Integer) {
                            prepStmt.setInt(i + 1, (Integer)param);
                            continue;
                        }
                        if (param instanceof Date) {
                            prepStmt.setTimestamp(i + 1, new Timestamp(System.currentTimeMillis()));
                            continue;
                        }
                        if (!(param instanceof Boolean)) continue;
                        prepStmt.setBoolean(i + 1, (Boolean)param);
                    }
                }
                int count = prepStmt.executeUpdate();
                if (log.isDebugEnabled()) {
                    if (count == 0) {
                        log.debug((Object)"No rows were updated");
                    }
                    log.debug((Object)("Executed querry is " + sqlStmt + " and number of updated rows :: " + count));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block15;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Using sql : " + sqlStmt));
                    throw new UserStoreException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public void addProperty(Connection dbConnection, String userName, String propertyName, String value, String profileName) throws UserStoreException {
        try {
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertySQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertySQL");
            }
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for add user property sql is null");
            }
            if ("openedge".equals(type)) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, propertyName, value, profileName, this.tenantId, userName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, userName, this.tenantId, propertyName, value, profileName, this.tenantId);
            }
        }
        catch (UserStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    protected void updateProperty(Connection dbConnection, String userName, String propertyName, String value, String profileName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPropertySQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        this.updateStringValuesToDatabase(dbConnection, sqlStmt, value, userName, this.tenantId, propertyName, profileName, this.tenantId);
    }

    protected void deleteProperty(Connection dbConnection, String userName, String propertyName, String profileName) throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("DeleteUserPropertySQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        this.updateStringValuesToDatabase(dbConnection, sqlStmt, userName, this.tenantId, propertyName, profileName, this.tenantId);
    }

    protected String getProperty(Connection dbConnection, String userName, String propertyName, String profileName) throws UserStoreException {
        String string;
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserPropertyForProfileSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String value = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userName);
            prepStmt.setString(2, propertyName);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                value = rs.getString(1);
            }
            string = value;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return string;
    }

    protected String preparePassword(String password, String saltValue) throws UserStoreException {
        try {
            String digsestFunction;
            String digestInput = password;
            if (saltValue != null) {
                digestInput = password + saltValue;
            }
            if ((digsestFunction = (String)this.realmConfig.getUserStoreProperties().get("PasswordDigest")) != null) {
                if (digsestFunction.equals("PLAIN_TEXT")) {
                    return password;
                }
                MessageDigest dgst = MessageDigest.getInstance(digsestFunction);
                byte[] byteValue = dgst.digest(digestInput.getBytes());
                password = Base64.encode((byte[])byteValue);
            }
            return password;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private DataSource loadUserStoreSpacificDataSoruce() throws UserStoreException {
        return DatabaseUtil.createUserStoreDataSource(this.realmConfig);
    }

    @Override
    public Map<String, String> getProperties(org.wso2.carbon.user.core.tenant.Tenant tenant) throws UserStoreException {
        return this.realmConfig.getUserStoreProperties();
    }

    public void addRememberMe(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String[] values = DatabaseUtil.getStringValuesFromDatabase(dbConnection, "SELECT UM_COOKIE_VALUE, UM_CREATED_TIME FROM UM_HYBRID_REMEMBER_ME WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", userName, this.tenantId);
            Date createdTime = Calendar.getInstance().getTime();
            if (values != null && values.length > 0 && values[0].length() > 0) {
                DatabaseUtil.updateDatabase(dbConnection, "UPDATE UM_HYBRID_REMEMBER_ME SET UM_COOKIE_VALUE=?, UM_CREATED_TIME=? WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", token, createdTime, userName, this.tenantId);
            } else {
                DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_HYBRID_REMEMBER_ME (UM_USER_NAME, UM_COOKIE_VALUE, UM_CREATED_TIME, UM_TENANT_ID) VALUES (?,?,?,?)", userName, token, createdTime, this.tenantId);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public boolean isExistingRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        boolean isValid = false;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String value = null;
        Timestamp createdTime = null;
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_COOKIE_VALUE, UM_CREATED_TIME FROM UM_HYBRID_REMEMBER_ME WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, userName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                value = rs.getString(1);
                createdTime = rs.getTimestamp(2);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Using sql : SELECT UM_COOKIE_VALUE, UM_CREATED_TIME FROM UM_HYBRID_REMEMBER_ME WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        if (value != null && createdTime != null) {
            Calendar calendar = Calendar.getInstance();
            Date nowDate = calendar.getTime();
            calendar.setTime(createdTime);
            calendar.add(13, 604800);
            Date expDate = calendar.getTime();
            if (expDate.before(nowDate)) {
                log.debug((Object)"Remember me token has expired !!");
            } else if (value.equals(token)) {
                isValid = true;
            } else {
                log.debug((Object)"Remember me token in DB and token in request are different !!");
                isValid = false;
            }
        }
        return isValid;
    }

    public boolean isValidRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            if (this.isExistingUser(userName)) {
                return this.isExistingRememberMeToken(userName, token);
            }
        }
        catch (Exception e) {
            log.error((Object)("Validating remember me token failed for" + userName));
        }
        return false;
    }

    @Override
    public String[] getUserListFromProperties(String property, String value, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        String[] users = new String[]{};
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            dbConnection = this.getDBConnection();
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserLisForPropertySQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, property);
            prepStmt.setString(2, value);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                list.add(name);
            }
            if (list.size() > 0) {
                users = list.toArray(new String[list.size()]);
            }
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return users;
    }

    @Override
    public String[] doGetExternalRoleListOfUser(String userName, String filter) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting roles of user: " + userName + " with filter: " + filter));
        }
        String sqlStmt = this.realmConfig.getUserStoreProperty("UserRoleSQL");
        ArrayList roles = new ArrayList();
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving user roles is null");
        }
        String[] names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userName, this.tenantId, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, userName);
        if (log.isDebugEnabled()) {
            if (names != null) {
                for (String name : names) {
                    log.debug((Object)("Found role: " + name));
                }
            } else {
                log.debug((Object)("No external role found for the user: " + userName));
            }
        }
        Collections.addAll(roles, names);
        return roles.toArray(new String[roles.size()]);
    }

    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties(JDBCUserStoreConstants.JDBC_UM_MANDATORY_PROPERTIES.toArray(new Property[JDBCUserStoreConstants.JDBC_UM_MANDATORY_PROPERTIES.size()]));
        properties.setOptionalProperties(JDBCUserStoreConstants.JDBC_UM_OPTIONAL_PROPERTIES.toArray(new Property[JDBCUserStoreConstants.JDBC_UM_OPTIONAL_PROPERTIES.size()]));
        properties.setAdvancedProperties(JDBCUserStoreConstants.JDBC_UM_ADVANCED_PROPERTIES.toArray(new Property[JDBCUserStoreConstants.JDBC_UM_ADVANCED_PROPERTIES.size()]));
        return properties;
    }

    protected void doAddSharedRole(String roleName, String[] userList) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddSharedRoleSQL");
            if (sqlStmt.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, true, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, true, roleName);
            }
            if (userList != null) {
                int roleTenantId = CarbonContext.getCurrentContext().getTenantId();
                sqlStmt = this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQL");
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt, roleName, roleTenantId, userList, this.tenantId, this.tenantId, roleTenantId);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    protected String[] doGetSharedRoleListOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for shared roles for user: " + userName + " for teanant: " + tenantDomain));
        }
        if (this.isSharedGroupEnabled()) {
            String sqlStmt = this.realmConfig.getUserStoreProperty("UserSharedRoleSQL");
            String[] sharedNames = this.getRoleNamesWithDomain(sqlStmt, userName, this.tenantId, true);
            return sharedNames;
        }
        return new String[0];
    }

    @Override
    protected RoleContext createRoleContext(String roleName) {
        JDBCRoleContext searchCtx = new JDBCRoleContext();
        String[] roleNameParts = roleName.split("@");
        if (roleNameParts.length > 1 && (roleNameParts[1] == null || roleNameParts[1].equals("null"))) {
            roleNameParts = new String[]{roleNameParts[0]};
        }
        int tenantId = -1;
        if (roleNameParts.length > 1) {
            tenantId = Integer.parseInt(roleNameParts[1]);
            searchCtx.setTenantId(tenantId);
        } else {
            tenantId = this.tenantId;
            searchCtx.setTenantId(tenantId);
        }
        if (tenantId != this.tenantId) {
            searchCtx.setShared(true);
        }
        searchCtx.setRoleName(roleNameParts[0]);
        return searchCtx;
    }

    public class RoleBreakdown {
        private String[] roles;
        private Integer[] tenantIds;
        private String[] sharedRoles;
        private Integer[] sharedTenantids;

        public String[] getRoles() {
            return this.roles;
        }

        public void setRoles(String[] roles) {
            this.roles = roles;
        }

        public Integer[] getTenantIds() {
            return this.tenantIds;
        }

        public void setTenantIds(Integer[] tenantIds) {
            this.tenantIds = tenantIds;
        }

        public String[] getSharedRoles() {
            return this.sharedRoles;
        }

        public void setSharedRoles(String[] sharedRoles) {
            this.sharedRoles = sharedRoles;
        }

        public Integer[] getSharedTenantids() {
            return this.sharedTenantids;
        }

        public void setSharedTenantids(Integer[] sharedTenantids) {
            this.sharedTenantids = sharedTenantids;
        }
    }
}

