/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.ssh.security;

import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.apache.airavata.gfac.core.SecurityContext;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHSecurityContext
implements SecurityContext {
    private static final Logger log = LoggerFactory.getLogger(SSHSecurityContext.class);
    private String username;
    private String privateKeyLoc;
    private String keyPass;
    private SSHClient sshClient;
    private Session session;
    private RemoteCluster remoteCluster;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPrivateKeyLoc() {
        return this.privateKeyLoc;
    }

    public void setPrivateKeyLoc(String privateKeyLoc) {
        this.privateKeyLoc = privateKeyLoc;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                log.warn("Cannot Close SSH Session");
            }
        }
    }

    public Session getSession(String hostAddress) throws IOException {
        try {
            if (this.sshClient == null) {
                this.sshClient = new SSHClient();
            }
            if (this.getSSHClient().isConnected()) {
                return this.getSSHClient().startSession();
            }
            KeyProvider pkey = this.getSSHClient().loadKeys(this.getPrivateKeyLoc(), this.getKeyPass());
            this.getSSHClient().loadKnownHosts();
            this.getSSHClient().connect(hostAddress);
            this.getSSHClient().authPublickey(this.getUsername(), new KeyProvider[]{pkey});
            this.session = this.getSSHClient().startSession();
            return this.session;
        }
        catch (NullPointerException ne) {
            throw new SecurityException("Cannot load security context for SSH", ne);
        }
    }

    public SSHClient getSSHClient() {
        if (this.sshClient == null) {
            this.sshClient = new SSHClient();
        }
        return this.sshClient;
    }

    public void setRemoteCluster(RemoteCluster remoteCluster) {
        this.remoteCluster = remoteCluster;
    }

    public RemoteCluster getRemoteCluster() {
        return this.remoteCluster;
    }
}

