/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import eu.emi.security.authn.x509.CommonX509TrustManager;
import eu.emi.security.authn.x509.X509CertChainValidator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.auth.login.FailedLoginException;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;

public class MyProxyLogon {
    public static final String version = "1.1";
    public static final String VERSION = "VERSION=MYPROXYv2";
    private static final String GETCOMMAND = "COMMAND=0";
    private static final String TRUSTROOTS = "TRUSTED_CERTS=";
    private static final String USERNAME = "USERNAME=";
    private static final String PASSPHRASE = "PASSPHRASE=";
    private static final String LIFETIME = "LIFETIME=";
    private static final String CREDNAME = "CRED_NAME=";
    public static final String RESPONSE = "RESPONSE=";
    private static final String ERROR = "ERROR=";
    private static final String DN = "CN=ignore";
    public final int DEFAULT_KEY_SIZE = 2048;
    private int keySize = 2048;
    private static final String keyAlg = "RSA";
    private State state = State.READY;
    private String host = System.getenv("MYPROXY_SERVER");
    private String username;
    private String credname;
    private char[] passphrase;
    private int port = 7512;
    private int lifetime = 43200;
    private SSLSocket socket;
    private BufferedInputStream socketIn;
    private BufferedOutputStream socketOut;
    private KeyPair keypair;
    private Collection<X509Certificate> certificateChain;
    private String[] trustrootFilenames;
    private String[] trustrootData;
    private KeyManagerFactory keyManagerFactory;
    private TrustManager trustManager;
    static PrivateKey testingPrivateKey;

    public MyProxyLogon() {
        String portString;
        if (this.host == null) {
            this.host = "myproxy.teragrid.org";
        }
        if ((portString = System.getenv("MYPROXY_SERVER_PORT")) != null) {
            this.port = Integer.parseInt(portString);
        }
        this.username = System.getProperty("user.name");
    }

    public void setValidator(X509CertChainValidator validator) {
        CommonX509TrustManager mtm = new CommonX509TrustManager(validator);
        this.setTrustManager((TrustManager)mtm);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setCredentialName(String credname) {
        this.credname = credname;
    }

    public void setPassphrase(char[] passphrase) {
        this.passphrase = passphrase;
    }

    public void setLifetime(int seconds) {
        this.lifetime = seconds;
    }

    public Collection<X509Certificate> getCertificates() {
        return this.certificateChain;
    }

    public PrivateKey getPrivateKey() {
        if (testingPrivateKey != null) {
            return testingPrivateKey;
        }
        return this.keypair.getPrivate();
    }

    public void connect() throws IOException, GeneralSecurityException {
        SSLContext sc = SSLContext.getInstance("SSL");
        if (this.trustManager == null) {
            throw new IllegalStateException("No trust manager has been set!");
        }
        TrustManager[] trustAllCerts = new TrustManager[]{this.trustManager};
        sc.init(this.getKeyManagers(), trustAllCerts, new SecureRandom());
        SSLSocketFactory sf = sc.getSocketFactory();
        this.socket = (SSLSocket)sf.createSocket(this.host, this.port);
        this.socket.startHandshake();
        this.socketIn = new BufferedInputStream(this.socket.getInputStream());
        this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
        this.state = State.CONNECTED;
    }

    public void setKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void disconnect() throws IOException {
        this.socket.close();
        this.socket = null;
        this.socketIn = null;
        this.socketOut = null;
        this.state = State.READY;
    }

    public void logon() throws IOException, GeneralSecurityException {
        if (this.state != State.CONNECTED) {
            this.connect();
        }
        this.socketOut.write(48);
        this.socketOut.flush();
        this.socketOut.write(VERSION.getBytes());
        this.socketOut.write(10);
        this.socketOut.write(GETCOMMAND.getBytes());
        this.socketOut.write(10);
        this.socketOut.write(USERNAME.getBytes());
        this.socketOut.write(this.username.getBytes());
        this.socketOut.write(10);
        this.socketOut.write(PASSPHRASE.getBytes());
        this.socketOut.write(new String(this.passphrase).getBytes());
        this.socketOut.write(10);
        this.socketOut.write(LIFETIME.getBytes());
        this.socketOut.write(Integer.toString(this.lifetime).getBytes());
        this.socketOut.write(10);
        if (this.credname != null) {
            this.socketOut.write(CREDNAME.getBytes());
            this.socketOut.write(this.credname.getBytes());
            this.socketOut.write(10);
        }
        this.socketOut.flush();
        String line = this.readLine(this.socketIn);
        if (line == null) {
            throw new EOFException();
        }
        if (!line.equals(VERSION)) {
            throw new ProtocolException("bad MyProxy protocol VERSION string: " + line);
        }
        line = this.readLine(this.socketIn);
        if (line == null) {
            throw new EOFException();
        }
        if (!line.startsWith(RESPONSE) || line.length() != RESPONSE.length() + 1) {
            throw new ProtocolException("bad MyProxy protocol RESPONSE string: " + line);
        }
        char response = line.charAt(RESPONSE.length());
        if (response == '1') {
            StringBuffer errString = new StringBuffer("MyProxy logon failed");
            while ((line = this.readLine(this.socketIn)) != null) {
                if (!line.startsWith(ERROR)) continue;
                errString.append('\n');
                errString.append(line.substring(ERROR.length()));
            }
            throw new FailedLoginException(errString.toString());
        }
        if (response == '2') {
            throw new ProtocolException("MyProxy authorization RESPONSE not implemented");
        }
        if (response != '0') {
            throw new ProtocolException("unknown MyProxy protocol RESPONSE string: " + line);
        }
        while ((line = this.readLine(this.socketIn)) != null) {
            if (!line.startsWith(TRUSTROOTS)) continue;
            String filenameList = line.substring(TRUSTROOTS.length());
            this.trustrootFilenames = filenameList.split(",");
            this.trustrootData = new String[this.trustrootFilenames.length];
            for (int i = 0; i < this.trustrootFilenames.length; ++i) {
                String lineStart = "FILEDATA_" + this.trustrootFilenames[i] + "=";
                line = this.readLine(this.socketIn);
                if (line == null) {
                    throw new EOFException();
                }
                if (!line.startsWith(lineStart)) {
                    throw new ProtocolException("bad MyProxy protocol RESPONSE: expecting " + lineStart + " but received " + line);
                }
                this.trustrootData[i] = new String(Base64.decode((String)line.substring(lineStart.length())));
            }
        }
        this.state = State.LOGGEDON;
    }

    public void getCredentials() throws IOException, GeneralSecurityException {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(keyAlg);
        keyGenerator.initialize(this.keySize);
        this.keypair = keyGenerator.genKeyPair();
        Security.addProvider((Provider)new BouncyCastleProvider());
        PKCS10CertificationRequest pkcs10 = null;
        try {
            pkcs10 = this.generateCertificationRequest(DN, this.keypair);
        }
        catch (Exception ex) {
            throw new GeneralSecurityException(ex);
        }
        this.getCredentials(pkcs10.getEncoded());
    }

    public X509Certificate getCertificate() {
        if (this.certificateChain == null) {
            return null;
        }
        Iterator<X509Certificate> iter = this.certificateChain.iterator();
        return iter.next();
    }

    private KeyManager[] getKeyManagers() {
        return this.keyManagerFactory != null ? this.keyManagerFactory.getKeyManagers() : null;
    }

    private void getCredentials(byte[] derEncodedCertRequest) throws IOException, GeneralSecurityException {
        if (this.state != State.LOGGEDON) {
            this.logon();
        }
        this.socketOut.write(derEncodedCertRequest);
        this.socketOut.flush();
        int numCertificates = this.socketIn.read();
        if (numCertificates == -1) {
            throw new IOException("Error: connection aborted");
        }
        if (numCertificates == 0 || numCertificates < 0) {
            throw new GeneralSecurityException("Error: bad number of certificates sent by server");
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        this.certificateChain = new ArrayList<X509Certificate>();
        for (int i = 0; i < numCertificates; ++i) {
            X509Certificate c = (X509Certificate)certFactory.generateCertificate(this.socketIn);
            this.certificateChain.add(c);
        }
        this.state = State.DONE;
    }

    private String readLine(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c = is.read();
        while (c > 0 && c != 10) {
            sb.append((char)c);
            c = is.read();
        }
        if (sb.length() > 0) {
            return new String(sb);
        }
        return null;
    }

    private PKCS10CertificationRequest generateCertificationRequest(String dn, KeyPair kp) throws Exception {
        X500Name subject = new X500Name(dn);
        PublicKey pubKey = kp.getPublic();
        PrivateKey privKey = kp.getPrivate();
        AsymmetricKeyParameter pubkeyParam = PublicKeyFactory.createKey((byte[])pubKey.getEncoded());
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)pubkeyParam);
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(subject, publicKeyInfo);
        AlgorithmIdentifier signatureAi = new AlgorithmIdentifier(OIWObjectIdentifiers.sha1WithRSA);
        BcRSAContentSignerBuilder signerBuilder = new BcRSAContentSignerBuilder(signatureAi, AlgorithmIdentifier.getInstance((Object)OIWObjectIdentifiers.idSHA1));
        AsymmetricKeyParameter pkParam = PrivateKeyFactory.createKey((byte[])privKey.getEncoded());
        ContentSigner signer = signerBuilder.build(pkParam);
        return builder.build(signer);
    }

    private static enum State {
        READY,
        CONNECTED,
        LOGGEDON,
        DONE;

    }
}

