/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.util.internal.LinkedTransferQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedWriteHandler
extends SimpleChannelHandler {
    private final Queue<MessageEvent> queue;
    private final boolean consolidateOnFlush;
    private volatile ChannelHandlerContext ctx;

    public BufferedWriteHandler() {
        this(false);
    }

    public BufferedWriteHandler(Queue<MessageEvent> queue) {
        this(queue, false);
    }

    public BufferedWriteHandler(boolean consolidateOnFlush) {
        this(new LinkedTransferQueue<MessageEvent>(), consolidateOnFlush);
    }

    public BufferedWriteHandler(Queue<MessageEvent> queue, boolean consolidateOnFlush) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        this.queue = queue;
        this.consolidateOnFlush = consolidateOnFlush;
    }

    public boolean isConsolidateOnFlush() {
        return this.consolidateOnFlush;
    }

    protected Queue<MessageEvent> getQueue() {
        return this.queue;
    }

    public void flush() {
        this.flush(this.consolidateOnFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean consolidateOnFlush) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        Queue<MessageEvent> queue = this.getQueue();
        if (consolidateOnFlush) {
            if (queue.isEmpty()) {
                return;
            }
            List<MessageEvent> pendingWrites = new ArrayList<MessageEvent>();
            BufferedWriteHandler bufferedWriteHandler = this;
            synchronized (bufferedWriteHandler) {
                MessageEvent e;
                while ((e = queue.poll()) != null) {
                    if (!(e.getMessage() instanceof ChannelBuffer)) {
                        if ((pendingWrites = this.consolidatedWrite(pendingWrites)) == null) {
                            pendingWrites = new ArrayList();
                        }
                        ctx.sendDownstream(e);
                        continue;
                    }
                    pendingWrites.add(e);
                }
                this.consolidatedWrite(pendingWrites);
            }
        }
        BufferedWriteHandler bufferedWriteHandler = this;
        synchronized (bufferedWriteHandler) {
            MessageEvent e;
            while ((e = queue.poll()) != null) {
                ctx.sendDownstream(e);
            }
        }
    }

    private List<MessageEvent> consolidatedWrite(final List<MessageEvent> pendingWrites) {
        int size = pendingWrites.size();
        if (size == 1) {
            this.ctx.sendDownstream(pendingWrites.remove(0));
            return pendingWrites;
        }
        if (size == 0) {
            return pendingWrites;
        }
        ChannelBuffer[] data = new ChannelBuffer[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (ChannelBuffer)pendingWrites.get(i).getMessage();
        }
        ChannelBuffer composite = ChannelBuffers.wrappedBuffer(data);
        ChannelFuture future = Channels.future(this.ctx.getChannel());
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    for (MessageEvent e : pendingWrites) {
                        e.getFuture().setSuccess();
                    }
                } else {
                    Throwable cause = future.getCause();
                    for (MessageEvent e : pendingWrites) {
                        e.getFuture().setFailure(cause);
                    }
                }
            }
        });
        Channels.write(this.ctx, future, composite);
        return null;
    }

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.ctx == null) {
            this.ctx = ctx;
        } else assert (this.ctx == ctx);
        this.getQueue().add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            this.flush(this.consolidateOnFlush);
            Object var4_3 = null;
            ctx.sendDownstream(e);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.sendDownstream(e);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            this.flush(this.consolidateOnFlush);
            Object var4_3 = null;
            ctx.sendDownstream(e);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.sendDownstream(e);
            throw throwable;
        }
    }
}

