/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.data.movement;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.model.data.movement.SecurityProtocol;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class SCPDataMovement
implements TBase<SCPDataMovement, _Fields>,
Serializable,
Cloneable,
Comparable<SCPDataMovement> {
    private static final TStruct STRUCT_DESC = new TStruct("SCPDataMovement");
    private static final TField DATA_MOVEMENT_INTERFACE_ID_FIELD_DESC = new TField("dataMovementInterfaceId", 11, 1);
    private static final TField SECURITY_PROTOCOL_FIELD_DESC = new TField("securityProtocol", 8, 2);
    private static final TField ALTERNATIVE_SCPHOST_NAME_FIELD_DESC = new TField("alternativeSCPHostName", 11, 3);
    private static final TField SSH_PORT_FIELD_DESC = new TField("sshPort", 8, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String dataMovementInterfaceId;
    private SecurityProtocol securityProtocol;
    private String alternativeSCPHostName;
    private int sshPort;
    private static final int __SSHPORT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public SCPDataMovement() {
        this.dataMovementInterfaceId = "DO_NOT_SET_AT_CLIENTS";
        this.sshPort = 22;
    }

    public SCPDataMovement(String dataMovementInterfaceId, SecurityProtocol securityProtocol) {
        this();
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.securityProtocol = securityProtocol;
    }

    public SCPDataMovement(SCPDataMovement other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetDataMovementInterfaceId()) {
            this.dataMovementInterfaceId = other.dataMovementInterfaceId;
        }
        if (other.isSetSecurityProtocol()) {
            this.securityProtocol = other.securityProtocol;
        }
        if (other.isSetAlternativeSCPHostName()) {
            this.alternativeSCPHostName = other.alternativeSCPHostName;
        }
        this.sshPort = other.sshPort;
    }

    public SCPDataMovement deepCopy() {
        return new SCPDataMovement(this);
    }

    public void clear() {
        this.dataMovementInterfaceId = "DO_NOT_SET_AT_CLIENTS";
        this.securityProtocol = null;
        this.alternativeSCPHostName = null;
        this.sshPort = 22;
    }

    public String getDataMovementInterfaceId() {
        return this.dataMovementInterfaceId;
    }

    public void setDataMovementInterfaceId(String dataMovementInterfaceId) {
        this.dataMovementInterfaceId = dataMovementInterfaceId;
    }

    public void unsetDataMovementInterfaceId() {
        this.dataMovementInterfaceId = null;
    }

    public boolean isSetDataMovementInterfaceId() {
        return this.dataMovementInterfaceId != null;
    }

    public void setDataMovementInterfaceIdIsSet(boolean value) {
        if (!value) {
            this.dataMovementInterfaceId = null;
        }
    }

    public SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public void unsetSecurityProtocol() {
        this.securityProtocol = null;
    }

    public boolean isSetSecurityProtocol() {
        return this.securityProtocol != null;
    }

    public void setSecurityProtocolIsSet(boolean value) {
        if (!value) {
            this.securityProtocol = null;
        }
    }

    public String getAlternativeSCPHostName() {
        return this.alternativeSCPHostName;
    }

    public void setAlternativeSCPHostName(String alternativeSCPHostName) {
        this.alternativeSCPHostName = alternativeSCPHostName;
    }

    public void unsetAlternativeSCPHostName() {
        this.alternativeSCPHostName = null;
    }

    public boolean isSetAlternativeSCPHostName() {
        return this.alternativeSCPHostName != null;
    }

    public void setAlternativeSCPHostNameIsSet(boolean value) {
        if (!value) {
            this.alternativeSCPHostName = null;
        }
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
        this.setSshPortIsSet(true);
    }

    public void unsetSshPort() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetSshPort() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setSshPortIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case DATA_MOVEMENT_INTERFACE_ID: {
                if (value == null) {
                    this.unsetDataMovementInterfaceId();
                    break;
                }
                this.setDataMovementInterfaceId((String)value);
                break;
            }
            case SECURITY_PROTOCOL: {
                if (value == null) {
                    this.unsetSecurityProtocol();
                    break;
                }
                this.setSecurityProtocol((SecurityProtocol)((Object)value));
                break;
            }
            case ALTERNATIVE_SCPHOST_NAME: {
                if (value == null) {
                    this.unsetAlternativeSCPHostName();
                    break;
                }
                this.setAlternativeSCPHostName((String)value);
                break;
            }
            case SSH_PORT: {
                if (value == null) {
                    this.unsetSshPort();
                    break;
                }
                this.setSshPort((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DATA_MOVEMENT_INTERFACE_ID: {
                return this.getDataMovementInterfaceId();
            }
            case SECURITY_PROTOCOL: {
                return this.getSecurityProtocol();
            }
            case ALTERNATIVE_SCPHOST_NAME: {
                return this.getAlternativeSCPHostName();
            }
            case SSH_PORT: {
                return this.getSshPort();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DATA_MOVEMENT_INTERFACE_ID: {
                return this.isSetDataMovementInterfaceId();
            }
            case SECURITY_PROTOCOL: {
                return this.isSetSecurityProtocol();
            }
            case ALTERNATIVE_SCPHOST_NAME: {
                return this.isSetAlternativeSCPHostName();
            }
            case SSH_PORT: {
                return this.isSetSshPort();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof SCPDataMovement) {
            return this.equals((SCPDataMovement)that);
        }
        return false;
    }

    public boolean equals(SCPDataMovement that) {
        if (that == null) {
            return false;
        }
        boolean this_present_dataMovementInterfaceId = this.isSetDataMovementInterfaceId();
        boolean that_present_dataMovementInterfaceId = that.isSetDataMovementInterfaceId();
        if (this_present_dataMovementInterfaceId || that_present_dataMovementInterfaceId) {
            if (!this_present_dataMovementInterfaceId || !that_present_dataMovementInterfaceId) {
                return false;
            }
            if (!this.dataMovementInterfaceId.equals(that.dataMovementInterfaceId)) {
                return false;
            }
        }
        boolean this_present_securityProtocol = this.isSetSecurityProtocol();
        boolean that_present_securityProtocol = that.isSetSecurityProtocol();
        if (this_present_securityProtocol || that_present_securityProtocol) {
            if (!this_present_securityProtocol || !that_present_securityProtocol) {
                return false;
            }
            if (!this.securityProtocol.equals((Object)that.securityProtocol)) {
                return false;
            }
        }
        boolean this_present_alternativeSCPHostName = this.isSetAlternativeSCPHostName();
        boolean that_present_alternativeSCPHostName = that.isSetAlternativeSCPHostName();
        if (this_present_alternativeSCPHostName || that_present_alternativeSCPHostName) {
            if (!this_present_alternativeSCPHostName || !that_present_alternativeSCPHostName) {
                return false;
            }
            if (!this.alternativeSCPHostName.equals(that.alternativeSCPHostName)) {
                return false;
            }
        }
        boolean this_present_sshPort = this.isSetSshPort();
        boolean that_present_sshPort = that.isSetSshPort();
        if (this_present_sshPort || that_present_sshPort) {
            if (!this_present_sshPort || !that_present_sshPort) {
                return false;
            }
            if (this.sshPort != that.sshPort) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_dataMovementInterfaceId = this.isSetDataMovementInterfaceId();
        list.add(present_dataMovementInterfaceId);
        if (present_dataMovementInterfaceId) {
            list.add(this.dataMovementInterfaceId);
        }
        boolean present_securityProtocol = this.isSetSecurityProtocol();
        list.add(present_securityProtocol);
        if (present_securityProtocol) {
            list.add(this.securityProtocol.getValue());
        }
        boolean present_alternativeSCPHostName = this.isSetAlternativeSCPHostName();
        list.add(present_alternativeSCPHostName);
        if (present_alternativeSCPHostName) {
            list.add(this.alternativeSCPHostName);
        }
        boolean present_sshPort = this.isSetSshPort();
        list.add(present_sshPort);
        if (present_sshPort) {
            list.add(this.sshPort);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(SCPDataMovement other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetDataMovementInterfaceId()).compareTo(other.isSetDataMovementInterfaceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataMovementInterfaceId() && (lastComparison = TBaseHelper.compareTo((String)this.dataMovementInterfaceId, (String)other.dataMovementInterfaceId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSecurityProtocol()).compareTo(other.isSetSecurityProtocol());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSecurityProtocol() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.securityProtocol), (Comparable)((Object)other.securityProtocol))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAlternativeSCPHostName()).compareTo(other.isSetAlternativeSCPHostName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAlternativeSCPHostName() && (lastComparison = TBaseHelper.compareTo((String)this.alternativeSCPHostName, (String)other.alternativeSCPHostName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSshPort()).compareTo(other.isSetSshPort());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSshPort() && (lastComparison = TBaseHelper.compareTo((int)this.sshPort, (int)other.sshPort)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SCPDataMovement(");
        boolean first = true;
        sb.append("dataMovementInterfaceId:");
        if (this.dataMovementInterfaceId == null) {
            sb.append("null");
        } else {
            sb.append(this.dataMovementInterfaceId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("securityProtocol:");
        if (this.securityProtocol == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.securityProtocol);
        }
        first = false;
        if (this.isSetAlternativeSCPHostName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("alternativeSCPHostName:");
            if (this.alternativeSCPHostName == null) {
                sb.append("null");
            } else {
                sb.append(this.alternativeSCPHostName);
            }
            first = false;
        }
        if (this.isSetSshPort()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sshPort:");
            sb.append(this.sshPort);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDataMovementInterfaceId()) {
            throw new TProtocolException("Required field 'dataMovementInterfaceId' is unset! Struct:" + this.toString());
        }
        if (!this.isSetSecurityProtocol()) {
            throw new TProtocolException("Required field 'securityProtocol' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new SCPDataMovementStandardSchemeFactory());
        schemes.put(TupleScheme.class, new SCPDataMovementTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.ALTERNATIVE_SCPHOST_NAME, _Fields.SSH_PORT};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DATA_MOVEMENT_INTERFACE_ID, new FieldMetaData("dataMovementInterfaceId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SECURITY_PROTOCOL, new FieldMetaData("securityProtocol", 1, (FieldValueMetaData)new EnumMetaData(16, SecurityProtocol.class)));
        tmpMap.put(_Fields.ALTERNATIVE_SCPHOST_NAME, new FieldMetaData("alternativeSCPHostName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SSH_PORT, new FieldMetaData("sshPort", 2, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(SCPDataMovement.class, metaDataMap);
    }

    private static class SCPDataMovementTupleScheme
    extends TupleScheme<SCPDataMovement> {
        private SCPDataMovementTupleScheme() {
        }

        public void write(TProtocol prot, SCPDataMovement struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dataMovementInterfaceId);
            oprot.writeI32(struct.securityProtocol.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetAlternativeSCPHostName()) {
                optionals.set(0);
            }
            if (struct.isSetSshPort()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetAlternativeSCPHostName()) {
                oprot.writeString(struct.alternativeSCPHostName);
            }
            if (struct.isSetSshPort()) {
                oprot.writeI32(struct.sshPort);
            }
        }

        public void read(TProtocol prot, SCPDataMovement struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dataMovementInterfaceId = iprot.readString();
            struct.setDataMovementInterfaceIdIsSet(true);
            struct.securityProtocol = SecurityProtocol.findByValue(iprot.readI32());
            struct.setSecurityProtocolIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.alternativeSCPHostName = iprot.readString();
                struct.setAlternativeSCPHostNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.sshPort = iprot.readI32();
                struct.setSshPortIsSet(true);
            }
        }
    }

    private static class SCPDataMovementTupleSchemeFactory
    implements SchemeFactory {
        private SCPDataMovementTupleSchemeFactory() {
        }

        public SCPDataMovementTupleScheme getScheme() {
            return new SCPDataMovementTupleScheme();
        }
    }

    private static class SCPDataMovementStandardScheme
    extends StandardScheme<SCPDataMovement> {
        private SCPDataMovementStandardScheme() {
        }

        public void read(TProtocol iprot, SCPDataMovement struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.dataMovementInterfaceId = iprot.readString();
                            struct.setDataMovementInterfaceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.securityProtocol = SecurityProtocol.findByValue(iprot.readI32());
                            struct.setSecurityProtocolIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.alternativeSCPHostName = iprot.readString();
                            struct.setAlternativeSCPHostNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.sshPort = iprot.readI32();
                            struct.setSshPortIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, SCPDataMovement struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dataMovementInterfaceId != null) {
                oprot.writeFieldBegin(DATA_MOVEMENT_INTERFACE_ID_FIELD_DESC);
                oprot.writeString(struct.dataMovementInterfaceId);
                oprot.writeFieldEnd();
            }
            if (struct.securityProtocol != null) {
                oprot.writeFieldBegin(SECURITY_PROTOCOL_FIELD_DESC);
                oprot.writeI32(struct.securityProtocol.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.alternativeSCPHostName != null && struct.isSetAlternativeSCPHostName()) {
                oprot.writeFieldBegin(ALTERNATIVE_SCPHOST_NAME_FIELD_DESC);
                oprot.writeString(struct.alternativeSCPHostName);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSshPort()) {
                oprot.writeFieldBegin(SSH_PORT_FIELD_DESC);
                oprot.writeI32(struct.sshPort);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class SCPDataMovementStandardSchemeFactory
    implements SchemeFactory {
        private SCPDataMovementStandardSchemeFactory() {
        }

        public SCPDataMovementStandardScheme getScheme() {
            return new SCPDataMovementStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DATA_MOVEMENT_INTERFACE_ID(1, "dataMovementInterfaceId"),
        SECURITY_PROTOCOL(2, "securityProtocol"),
        ALTERNATIVE_SCPHOST_NAME(3, "alternativeSCPHostName"),
        SSH_PORT(4, "sshPort");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DATA_MOVEMENT_INTERFACE_ID;
                }
                case 2: {
                    return SECURITY_PROTOCOL;
                }
                case 3: {
                    return ALTERNATIVE_SCPHOST_NAME;
                }
                case 4: {
                    return SSH_PORT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

