/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security.authzcache;

import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.service.security.authzcache.AuthzCache;
import org.apache.airavata.service.security.authzcache.AuthzCacheEntry;
import org.apache.airavata.service.security.authzcache.AuthzCacheIndex;
import org.apache.airavata.service.security.authzcache.AuthzCacheManager;
import org.apache.airavata.service.security.authzcache.AuthzCachedStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthzCacheManager
implements AuthzCacheManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthzCacheManager.class);

    @Override
    public AuthzCachedStatus getAuthzCachedStatus(AuthzCacheIndex authzCacheIndex) throws AiravataSecurityException {
        if (this.isAuthzDecisionCached(authzCacheIndex)) {
            long currentTime;
            long timePassed;
            AuthzCacheEntry cacheEntry = this.getAuthzCacheEntry(authzCacheIndex);
            long expiryTime = cacheEntry.getExpiryTime();
            if (expiryTime > (timePassed = ((currentTime = System.currentTimeMillis()) - cacheEntry.getEntryTimestamp()) / 1000L)) {
                if (cacheEntry.getDecision()) {
                    return AuthzCachedStatus.AUTHORIZED;
                }
                return AuthzCachedStatus.NOT_AUTHORIZED;
            }
            this.removeAuthzCacheEntry(authzCacheIndex);
            return AuthzCachedStatus.NOT_CACHED;
        }
        return AuthzCachedStatus.NOT_CACHED;
    }

    @Override
    public void addToAuthzCache(AuthzCacheIndex authzCacheIndex, AuthzCacheEntry authzCacheEntry) throws AiravataSecurityException {
        try {
            AuthzCache.getInstance().put(authzCacheIndex, authzCacheEntry);
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in obtaining the authorization cache instance.");
        }
    }

    @Override
    public boolean isAuthzDecisionCached(AuthzCacheIndex authzCacheIndex) throws AiravataSecurityException {
        try {
            return AuthzCache.getInstance().containsKey(authzCacheIndex);
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in obtaining the authorization cache instance.");
        }
    }

    @Override
    public AuthzCacheEntry getAuthzCacheEntry(AuthzCacheIndex authzCacheIndex) throws AiravataSecurityException {
        try {
            return (AuthzCacheEntry)AuthzCache.getInstance().get(authzCacheIndex);
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in obtaining the authorization cache instance.");
        }
    }

    @Override
    public void removeAuthzCacheEntry(AuthzCacheIndex authzCacheIndex) throws AiravataSecurityException {
        try {
            AuthzCache.getInstance().remove(authzCacheIndex);
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in obtaining the authorization cache instance.");
        }
    }

    @Override
    public void clearCache() throws AiravataSecurityException {
        try {
            AuthzCache.getInstance().clear();
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in obtaining the authorization cache instance.");
        }
    }
}

