/*
 * Decompiled with CFR 0.152.
 */
package org.databene.profile;

import java.util.List;
import org.databene.profile.Profile;

public class Profiler {
    private static final Profiler DEFAULT_INSTANCE = new Profiler("default", 1L);
    private long granularity;
    private Profile rootProfile;

    public Profiler(String name, long granularity) {
        this.granularity = granularity;
        this.rootProfile = new Profile(name, null);
    }

    public static Profiler defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Profile getRootProfile() {
        return this.rootProfile;
    }

    public void addSample(List<String> path, long duration) {
        int depth = path.size();
        Profile profile = this.rootProfile;
        for (int i = 0; i < depth; ++i) {
            profile = profile.getOrCreateSubProfile(path.get(i));
        }
        profile.addSample((int)(duration / this.granularity));
    }

    public void printSummary() {
        this.printRecursively(this.rootProfile, "");
    }

    private void printRecursively(Profile profile, String indent) {
        System.out.println(indent + profile.toString());
        for (Profile subProfile : profile.getSubProfiles()) {
            this.printRecursively(subProfile, indent + "  ");
        }
    }
}

