/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class Roundtrip {
    private static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/features.html#xmldecl-standalone";
    private static final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    private XmlPullParser parser;
    private XmlSerializer serializer;

    private Roundtrip(XmlPullParser parser, XmlSerializer serializer) {
        this.parser = parser;
        this.serializer = serializer;
    }

    private void writeStartTag() throws XmlPullParserException, IOException {
        int i;
        if (!this.parser.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes")) {
            for (i = this.parser.getNamespaceCount(this.parser.getDepth() - 1); i <= this.parser.getNamespaceCount(this.parser.getDepth()) - 1; ++i) {
                this.serializer.setPrefix(this.parser.getNamespacePrefix(i), this.parser.getNamespaceUri(i));
            }
        }
        this.serializer.startTag(this.parser.getNamespace(), this.parser.getName());
        for (i = 0; i < this.parser.getAttributeCount(); ++i) {
            this.serializer.attribute(this.parser.getAttributeNamespace(i), this.parser.getAttributeName(i), this.parser.getAttributeValue(i));
        }
    }

    private void writeToken(int eventType) throws XmlPullParserException, IOException {
        switch (eventType) {
            case 0: {
                Boolean standalone = (Boolean)this.parser.getProperty(PROPERTY_XMLDECL_STANDALONE);
                this.serializer.startDocument(this.parser.getInputEncoding(), standalone);
                break;
            }
            case 1: {
                this.serializer.endDocument();
                break;
            }
            case 2: {
                this.writeStartTag();
                break;
            }
            case 3: {
                this.serializer.endTag(this.parser.getNamespace(), this.parser.getName());
                break;
            }
            case 7: {
                String s = this.parser.getText();
                this.serializer.ignorableWhitespace(s);
                break;
            }
            case 4: {
                this.serializer.text(this.parser.getText());
                break;
            }
            case 6: {
                this.serializer.entityRef(this.parser.getName());
                break;
            }
            case 5: {
                this.serializer.cdsect(this.parser.getText());
                break;
            }
            case 8: {
                this.serializer.processingInstruction(this.parser.getText());
                break;
            }
            case 9: {
                this.serializer.comment(this.parser.getText());
                break;
            }
            case 10: {
                this.serializer.docdecl(this.parser.getText());
            }
        }
    }

    private void roundTrip() throws XmlPullParserException, IOException {
        this.parser.nextToken();
        this.writeToken(0);
        while (this.parser.getEventType() != 1) {
            this.writeToken(this.parser.getEventType());
            this.parser.nextToken();
        }
        this.writeToken(1);
    }

    private static void roundTrip(Reader reader, Writer writer, String indent) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser pp = factory.newPullParser();
        pp.setInput(reader);
        XmlSerializer serializer = factory.newSerializer();
        serializer.setOutput(writer);
        if (indent != null) {
            serializer.setProperty(PROPERTY_SERIALIZER_INDENTATION, indent);
        }
        new Roundtrip(pp, serializer).roundTrip();
    }

    private static void roundTrip(XmlPullParserFactory factory, String loc) throws XmlPullParserException, IOException {
        Roundtrip.roundTrip(factory, loc, null);
    }

    private static void roundTrip(XmlPullParserFactory factory, String loc, String indent) throws XmlPullParserException, IOException {
        XmlPullParser pp = factory.newPullParser();
        pp.setInput(new URL(loc).openStream(), null);
        XmlSerializer serializer = factory.newSerializer();
        serializer.setOutput(System.out, null);
        if (indent != null) {
            serializer.setProperty(PROPERTY_SERIALIZER_INDENTATION, indent);
        }
        new Roundtrip(pp, serializer).roundTrip();
    }

    public static void main(String[] args) throws Exception {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        for (int i = 0; i < 1; ++i) {
            Roundtrip.roundTrip(factory, args[i], "  ");
        }
    }
}

