/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.tcp.TCPEndpoint;
import org.apache.axis2.transport.tcp.TCPWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPServer
implements Runnable {
    private TCPEndpoint endpoint;
    private ServerSocket serverSocket;
    private WorkerPool workerPool;
    private boolean started = false;
    private static final Log log = LogFactory.getLog(TCPServer.class);

    public TCPServer(TCPEndpoint endpoint, WorkerPool workerPool) {
        this.endpoint = endpoint;
        this.workerPool = workerPool;
    }

    public void run() {
        while (this.started) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (InterruptedIOException ignored) {
            }
            catch (Exception e) {
                log.debug((Object)e);
                break;
            }
            if (socket == null) continue;
            this.workerPool.execute(new TCPWorker(this.endpoint, socket));
        }
    }

    public void startServer() throws IOException {
        if (this.serverSocket == null) {
            if (this.endpoint.getHost() != null) {
                InetAddress address = InetAddress.getByName(this.endpoint.getHost());
                this.serverSocket = new ServerSocket(this.endpoint.getPort(), this.endpoint.getBacklog(), address);
            } else {
                this.serverSocket = new ServerSocket(this.endpoint.getPort(), this.endpoint.getBacklog());
            }
        }
        this.started = true;
        this.endpoint.getListener().getConfigurationContext().getThreadPool().execute(this);
        log.info((Object)("TCP server started on port : " + this.endpoint.getPort()));
    }

    public void stopServer() throws IOException {
        this.started = false;
        this.serverSocket.close();
        this.serverSocket = null;
        log.info((Object)("TCP server stopped on port : " + this.endpoint.getPort()));
    }
}

