/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.collection.CollectionPortableHook;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.concurrent.lock.client.AbstractLockRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;

public class MultiMapLockRequest
extends AbstractLockRequest {
    CollectionProxyId proxyId;

    public MultiMapLockRequest() {
    }

    public MultiMapLockRequest(Data key, int threadId, CollectionProxyId proxyId) {
        super(key, threadId);
        this.proxyId = proxyId;
    }

    public MultiMapLockRequest(Data key, int threadId, long ttl, long timeout, CollectionProxyId proxyId) {
        super(key, threadId, ttl, timeout);
        this.proxyId = proxyId;
    }

    @Override
    protected ObjectNamespace getNamespace() {
        return new DefaultObjectNamespace("hz:impl:collectionService", this.proxyId);
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        super.writePortable(writer);
        this.proxyId.writeData(writer.getRawDataOutput());
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        super.readPortable(reader);
        this.proxyId = new CollectionProxyId();
        this.proxyId.readData(reader.getRawDataInput());
    }

    @Override
    public int getFactoryId() {
        return CollectionPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 22;
    }
}

